/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.io.core.BatchSource;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.Source;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectorUtils.class);
    private static final String PULSAR_IO_SERVICE_NAME = "pulsar-io.yaml";

    public static String getIOSourceClass(NarClassLoader narClassLoader) throws IOException {
        ConnectorDefinition conf = ConnectorUtils.getConnectorDefinition(narClassLoader);
        if (StringUtils.isEmpty(conf.getSourceClass())) {
            throw new IOException(String.format("The '%s' connector does not provide a source implementation", conf.getName()));
        }
        try {
            Class<?> sourceClass = narClassLoader.loadClass(conf.getSourceClass());
            if (!Source.class.isAssignableFrom(sourceClass) && !BatchSource.class.isAssignableFrom(sourceClass)) {
                throw new IOException(String.format("Class %s does not implement interface %s or %s", conf.getSourceClass(), Source.class.getName(), BatchSource.class.getName()));
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getSourceClass();
    }

    public static String getIOSinkClass(NarClassLoader narClassLoader) throws IOException {
        ConnectorDefinition conf = ConnectorUtils.getConnectorDefinition(narClassLoader);
        if (StringUtils.isEmpty(conf.getSinkClass())) {
            throw new IOException(String.format("The '%s' connector does not provide a sink implementation", conf.getName()));
        }
        try {
            Class<?> sinkClass = narClassLoader.loadClass(conf.getSinkClass());
            if (!Sink.class.isAssignableFrom(sinkClass)) {
                throw new IOException("Class " + conf.getSinkClass() + " does not implement interface " + Sink.class.getName());
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getSinkClass();
    }

    public static ConnectorDefinition getConnectorDefinition(File narFile) throws IOException {
        return FunctionUtils.getPulsarIOServiceConfig(narFile, ConnectorDefinition.class);
    }

    public static ConnectorDefinition getConnectorDefinition(NarClassLoader narClassLoader) throws IOException {
        return FunctionUtils.getPulsarIOServiceConfig(narClassLoader, ConnectorDefinition.class);
    }

    public static List<ConfigFieldDefinition> getConnectorConfigDefinition(ValidatableFunctionPackage connectorFunctionPackage, String configClassName) {
        LinkedList<ConfigFieldDefinition> retval = new LinkedList<ConfigFieldDefinition>();
        TypeDescription configClass = connectorFunctionPackage.resolveType(configClassName);
        for (FieldDescription field : ConnectorUtils.getAllFields((TypeDefinition)configClass)) {
            if (field.isStatic()) continue;
            ConfigFieldDefinition configFieldDefinition = new ConfigFieldDefinition();
            configFieldDefinition.setFieldName(field.getName());
            configFieldDefinition.setTypeName(field.getType().getActualName());
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (AnnotationDescription annotation : field.getDeclaredAnnotations()) {
                if (!annotation.getAnnotationType().represents(FieldDoc.class)) continue;
                for (MethodDescription.InDefinedShape method : annotation.getAnnotationType().getDeclaredMethods()) {
                    AnnotationValue value = annotation.getValue(method.getName());
                    attributes.put(method.getName(), value == null || value.resolve() == null ? "" : value.resolve().toString());
                }
            }
            configFieldDefinition.setAttributes(attributes);
            retval.add(configFieldDefinition);
        }
        return retval;
    }

    private static List<FieldDescription> getAllFields(TypeDefinition type) {
        LinkedList<FieldDescription> fields = new LinkedList<FieldDescription>();
        fields.addAll((Collection<FieldDescription>)type.getDeclaredFields());
        if (type.getSuperClass() != null) {
            fields.addAll(ConnectorUtils.getAllFields((TypeDefinition)type.getSuperClass()));
        }
        return fields;
    }

    public static TreeMap<String, Connector> searchForConnectors(String connectorsDirectory, String narExtractionDirectory, boolean enableClassloading) throws IOException {
        Path path = Paths.get(connectorsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for connectors in {}", (Object)path);
        TreeMap<String, Connector> connectors = new TreeMap<String, Connector>();
        if (!path.toFile().exists()) {
            log.warn("Connectors archive directory not found");
            return connectors;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    ConnectorDefinition cntDef = ConnectorUtils.getConnectorDefinition(archive.toFile());
                    log.info("Found connector {} from {}", (Object)cntDef, (Object)archive);
                    Connector connector = new Connector(archive, cntDef, narExtractionDirectory, enableClassloading);
                    connectors.put(cntDef.getName(), connector);
                }
                catch (Throwable t) {
                    log.warn("Failed to load connector from {}", (Object)archive, (Object)t);
                }
            }
        }
        return connectors;
    }

    private ConnectorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

