/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.Cookie;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.CookieImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.ServerCookie;

public class CookieJar
extends AbstractSet<ServerCookie> {
    private static final CookieJar EMPTY = new CookieJar(Collections.emptyList());
    private final List<ServerCookie> list;

    public CookieJar() {
        this.list = new ArrayList<ServerCookie>(4);
    }

    public CookieJar(CharSequence cookieHeader) {
        Objects.requireNonNull(cookieHeader, "cookie header cannot be null");
        Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader.toString());
        this.list = new ArrayList<ServerCookie>(nettyCookies.size());
        for (Cookie cookie : nettyCookies) {
            this.list.add(new CookieImpl(cookie));
        }
    }

    private CookieJar(List<ServerCookie> list) {
        Objects.requireNonNull(list, "list cannot be null");
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean contains(Object o) {
        ServerCookie needle = (ServerCookie)o;
        for (ServerCookie cookie : this.list) {
            if (CookieJar.cookieUniqueIdComparator(cookie, needle.getName(), needle.getDomain(), needle.getPath()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ServerCookie> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean add(ServerCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie cannot be null");
        }
        for (int i = 0; i < this.list.size(); ++i) {
            int cmp = CookieJar.cookieUniqueIdComparator(this.list.get(i), cookie.getName(), cookie.getDomain(), cookie.getPath());
            if (cmp > 0) {
                this.list.add(i, cookie);
                return true;
            }
            if (cmp != 0) continue;
            this.list.set(i, cookie);
            return true;
        }
        this.list.add(cookie);
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    private static int cookieUniqueIdComparator(ServerCookie cookie, String name, String domain, String path) {
        Objects.requireNonNull(cookie);
        Objects.requireNonNull(name);
        int v = cookie.getName().compareTo(name);
        if (cookie.isFromUserAgent()) {
            return v;
        }
        if (v != 0) {
            return v;
        }
        if (cookie.getPath() == null) {
            if (path != null) {
                return -1;
            }
        } else {
            if (path == null) {
                return 1;
            }
            v = cookie.getPath().compareTo(path);
            if (v != 0) {
                return v;
            }
        }
        if (cookie.getDomain() == null) {
            if (domain != null) {
                return -1;
            }
        } else {
            if (domain == null) {
                return 1;
            }
            v = cookie.getDomain().compareToIgnoreCase(domain);
            return v;
        }
        return 0;
    }

    public ServerCookie get(String name) {
        for (ServerCookie cookie : this.list) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public CookieJar getAll(String name) {
        ArrayList<ServerCookie> subList = null;
        for (ServerCookie cookie : this.list) {
            if (subList == null) {
                subList = new ArrayList<ServerCookie>(Math.min(4, this.list.size()));
            }
            if (!cookie.getName().equals(name)) continue;
            subList.add(cookie);
        }
        if (subList != null) {
            return new CookieJar(Collections.unmodifiableList(subList));
        }
        return EMPTY;
    }

    public ServerCookie get(String name, String domain, String path) {
        for (ServerCookie cookie : this.list) {
            if (CookieJar.cookieUniqueIdComparator(cookie, name, domain, path) != 0) continue;
            return cookie;
        }
        return null;
    }

    public CookieJar removeOrInvalidateAll(String name, boolean invalidate) {
        Iterator<ServerCookie> it = this.list.iterator();
        ArrayList<ServerCookie> collector = null;
        while (it.hasNext()) {
            ServerCookie cookie = it.next();
            if (!cookie.getName().equals(name)) continue;
            CookieJar.removeOrInvalidateCookie(it, cookie, invalidate);
            if (collector == null) {
                collector = new ArrayList<ServerCookie>(Math.min(4, this.list.size()));
            }
            collector.add(cookie);
        }
        if (collector != null) {
            return new CookieJar(Collections.unmodifiableList(collector));
        }
        return EMPTY;
    }

    public ServerCookie removeOrInvalidate(String name, String domain, String path, boolean invalidate) {
        Iterator<ServerCookie> it = this.list.iterator();
        while (it.hasNext()) {
            ServerCookie cookie = it.next();
            if (CookieJar.cookieUniqueIdComparator(cookie, name, domain, path) != 0) continue;
            CookieJar.removeOrInvalidateCookie(it, cookie, invalidate);
            return cookie;
        }
        return null;
    }

    public ServerCookie removeOrInvalidate(String name, boolean invalidate) {
        Iterator<ServerCookie> it = this.list.iterator();
        while (it.hasNext()) {
            ServerCookie cookie = it.next();
            if (!cookie.getName().equals(name)) continue;
            CookieJar.removeOrInvalidateCookie(it, cookie, invalidate);
            return cookie;
        }
        return null;
    }

    private static void removeOrInvalidateCookie(Iterator<ServerCookie> it, ServerCookie cookie, boolean invalidate) {
        if (invalidate && cookie.isFromUserAgent()) {
            cookie.setMaxAge(0L);
            cookie.setValue("");
        } else {
            it.remove();
        }
    }
}

