/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web.plugin.servlet;

import java.io.IOException;
import lombok.Generated;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.functions.runtime.shaded.org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServletWithClassLoader
implements AdditionalServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdditionalServletWithClassLoader.class);
    private final AdditionalServlet servlet;
    private final NarClassLoader classLoader;

    @Override
    public void loadConfig(PulsarConfiguration pulsarConfiguration) {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.servlet.loadConfig(pulsarConfiguration);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public String getBasePath() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            String string = this.servlet.getBasePath();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public ServletHolder getServletHolder() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ServletHolder servletHolder = this.servlet.getServletHolder();
            return servletHolder;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public void close() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.servlet.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the broker additional servlet class loader", (Throwable)e);
        }
    }

    @Generated
    public AdditionalServlet getServlet() {
        return this.servlet;
    }

    @Generated
    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalServletWithClassLoader)) {
            return false;
        }
        AdditionalServletWithClassLoader other = (AdditionalServletWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdditionalServlet this$servlet = this.getServlet();
        AdditionalServlet other$servlet = other.getServlet();
        if (this$servlet == null ? other$servlet != null : !this$servlet.equals(other$servlet)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalServletWithClassLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdditionalServlet $servlet = this.getServlet();
        result = result * 59 + ($servlet == null ? 43 : $servlet.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalServletWithClassLoader(servlet=" + this.getServlet() + ", classLoader=" + this.getClassLoader() + ")";
    }

    @Generated
    public AdditionalServletWithClassLoader(AdditionalServlet servlet, NarClassLoader classLoader) {
        this.servlet = servlet;
        this.classLoader = classLoader;
    }
}

