/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie;

import java.nio.ByteBuffer;

public class LogMark {
    long logFileId;
    long logFileOffset;
    public static final LogMark MAX_VALUE = new LogMark(Long.MAX_VALUE, Long.MAX_VALUE);

    public LogMark() {
        this.setLogMark(0L, 0L);
    }

    public LogMark(LogMark other) {
        this.setLogMark(other.getLogFileId(), other.getLogFileOffset());
    }

    public LogMark(long logFileId, long logFileOffset) {
        this.setLogMark(logFileId, logFileOffset);
    }

    public synchronized long getLogFileId() {
        return this.logFileId;
    }

    public synchronized long getLogFileOffset() {
        return this.logFileOffset;
    }

    public synchronized void readLogMark(ByteBuffer bb) {
        this.logFileId = bb.getLong();
        this.logFileOffset = bb.getLong();
    }

    public synchronized void writeLogMark(ByteBuffer bb) {
        bb.putLong(this.logFileId);
        bb.putLong(this.logFileOffset);
    }

    public synchronized void setLogMark(long logFileId, long logFileOffset) {
        this.logFileId = logFileId;
        this.logFileOffset = logFileOffset;
    }

    public synchronized int compare(LogMark other) {
        long ret = this.logFileId - other.getLogFileId();
        if (ret == 0L) {
            ret = this.logFileOffset - other.getLogFileOffset();
        }
        return ret < 0L ? -1 : (ret > 0L ? 1 : 0);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LogMark: logFileId - ").append(this.logFileId).append(" , logFileOffset - ").append(this.logFileOffset);
        return sb.toString();
    }
}

