/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryLimitController {
    private final long memoryLimit;
    private final AtomicLong currentUsage = new AtomicLong();
    private final ReentrantLock mutex = new ReentrantLock(false);
    private final Condition condition = this.mutex.newCondition();

    public MemoryLimitController(long memoryLimitBytes) {
        this.memoryLimit = memoryLimitBytes;
    }

    public boolean tryReserveMemory(long size) {
        long newUsage;
        long current;
        do {
            current = this.currentUsage.get();
            newUsage = current + size;
            if (current <= this.memoryLimit || this.memoryLimit <= 0L) continue;
            return false;
        } while (!this.currentUsage.compareAndSet(current, newUsage));
        return true;
    }

    public void reserveMemory(long size) throws InterruptedException {
        if (!this.tryReserveMemory(size)) {
            this.mutex.lock();
            try {
                while (!this.tryReserveMemory(size)) {
                    this.condition.await();
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory(long size) {
        long newUsage = this.currentUsage.addAndGet(-size);
        if (newUsage + size > this.memoryLimit && newUsage <= this.memoryLimit) {
            this.mutex.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public long currentUsage() {
        return this.currentUsage.get();
    }
}

