/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LayoutManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZKUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkLedgerManagerFactory
implements LedgerManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractZkLedgerManagerFactory.class);
    protected ZooKeeper zk;
    static final int V1 = 1;

    @Override
    public void format(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, KeeperException, IOException {
        Class<LedgerManagerFactory> factoryClass;
        try (AbstractZkLedgerManager ledgerManager = (AbstractZkLedgerManager)this.newLedgerManager();){
            String ledgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf);
            List<String> children = this.zk.getChildren(ledgersRootPath, false);
            for (String child : children) {
                boolean lParentNode = !AbstractZkLedgerManager.isSpecialZnode(child) && ledgerManager.isLedgerParentNode(child);
                boolean lIdGenerator = AbstractZkLedgerManager.isLeadgerIdGeneratorZnode(child);
                if (!lParentNode && !lIdGenerator) continue;
                ZKUtil.deleteRecursive(this.zk, ledgersRootPath + "/" + child);
            }
        }
        try {
            factoryClass = conf.getLedgerManagerFactoryClass();
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to get ledger manager factory class from configuration : ", e);
        }
        layoutManager.deleteLedgerLayout();
        AbstractZkLedgerManagerFactory.createNewLMFactory(conf, layoutManager, factoryClass);
    }

    @Override
    public boolean validateAndNukeExistingCluster(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, KeeperException, IOException {
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf);
        String zkServers = ZKMetadataDriverBase.resolveZkServers(conf);
        AbstractZkLedgerManager zkLedgerManager = (AbstractZkLedgerManager)this.newLedgerManager();
        List<String> ledgersRootPathChildrenList = this.zk.getChildren(zkLedgersRootPath, false);
        for (String ledgersRootPathChildren : ledgersRootPathChildrenList) {
            if (AbstractZkLedgerManager.isSpecialZnode(ledgersRootPathChildren) || zkLedgerManager.isLedgerParentNode(ledgersRootPathChildren)) continue;
            log.error("Found unexpected znode : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)zkLedgersRootPath);
            return false;
        }
        this.format(conf, layoutManager);
        ledgersRootPathChildrenList = this.zk.getChildren(zkLedgersRootPath, false);
        for (String ledgersRootPathChildren : ledgersRootPathChildrenList) {
            if (AbstractZkLedgerManager.isSpecialZnode(ledgersRootPathChildren)) {
                ZKUtil.deleteRecursive(this.zk, zkLedgersRootPath + "/" + ledgersRootPathChildren);
                continue;
            }
            log.error("Found unexpected znode : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)zkLedgersRootPath);
            return false;
        }
        this.zk.delete(zkLedgersRootPath, -1);
        log.info("Successfully nuked existing cluster, ZKServers: {} ledger root path: {}", (Object)zkServers, (Object)zkLedgersRootPath);
        return true;
    }

    public static LedgerManagerFactory newLedgerManagerFactory(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws IOException, InterruptedException {
        LedgerManagerFactory lmFactory;
        String ledgerRootPath;
        Class<LedgerManagerFactory> factoryClass;
        String metadataServiceUriStr;
        try {
            metadataServiceUriStr = conf.getMetadataServiceUri();
        }
        catch (ConfigurationException e) {
            log.error("Failed to retrieve metadata service uri from configuration", (Throwable)e);
            throw new IOException("Failed to retrieve metadata service uri from configuration", e);
        }
        if (null == metadataServiceUriStr) {
            try {
                factoryClass = conf.getLedgerManagerFactoryClass();
            }
            catch (ConfigurationException e) {
                log.error("Failed to get ledger manager factory class when using an external zookeeper client", (Throwable)e);
                throw new IOException("Failed to get ledger manager factory class when using an external zookeeper client", e);
            }
            ledgerRootPath = conf.getZkLedgersRootPath();
        } else {
            URI metadataServiceUri = URI.create(metadataServiceUriStr);
            factoryClass = ZKMetadataDriverBase.resolveLedgerManagerFactory(metadataServiceUri);
            ledgerRootPath = metadataServiceUri.getPath();
        }
        if (null == ledgerRootPath || ledgerRootPath.length() == 0) {
            throw new IOException("Empty Ledger Root Path.");
        }
        if (layoutManager == null) {
            return new FlatLedgerManagerFactory().initialize(conf, null, 1);
        }
        LedgerLayout layout = layoutManager.readLedgerLayout();
        if (layout == null) {
            lmFactory = AbstractZkLedgerManagerFactory.createNewLMFactory(conf, layoutManager, factoryClass);
            return lmFactory.initialize(conf, layoutManager, lmFactory.getCurrentVersion());
        }
        if (log.isDebugEnabled()) {
            log.debug("read ledger layout {}", (Object)layout);
        }
        if (layout.getLayoutFormatVersion() <= 1) {
            String lmType = conf.getLedgerManagerType();
            if (lmType != null && !layout.getManagerFactoryClass().equals(lmType)) {
                throw new IOException("Configured layout " + lmType + " does not match existing layout " + layout.getManagerFactoryClass());
            }
            if ("flat".equals(layout.getManagerFactoryClass())) {
                lmFactory = new FlatLedgerManagerFactory();
            } else if ("hierarchical".equals(layout.getManagerFactoryClass())) {
                lmFactory = new HierarchicalLedgerManagerFactory();
            } else {
                throw new IOException("Unknown ledger manager type: " + lmType);
            }
            return lmFactory.initialize(conf, layoutManager, layout.getManagerVersion());
        }
        if (factoryClass != null && !AbstractZkLedgerManagerFactory.isSameLedgerManagerFactory(conf, layout.getManagerFactoryClass(), factoryClass.getName()) && conf.getProperty("ledgerManagerFactoryDisableClassCheck") == null) {
            throw new IOException("Configured layout " + factoryClass.getName() + " does not match existing layout " + layout.getManagerFactoryClass());
        }
        if (factoryClass == null) {
            try {
                Class<?> theCls = Class.forName(layout.getManagerFactoryClass());
                if (!LedgerManagerFactory.class.isAssignableFrom(theCls)) {
                    throw new IOException("Wrong ledger manager factory " + layout.getManagerFactoryClass());
                }
                factoryClass = theCls.asSubclass(LedgerManagerFactory.class);
            }
            catch (IOException | ClassNotFoundException e) {
                factoryClass = AbstractZkLedgerManagerFactory.attemptToResolveShadedLedgerManagerFactory(conf, layout.getManagerFactoryClass(), e);
            }
        }
        lmFactory = ReflectionUtils.newInstance(factoryClass);
        return lmFactory.initialize(conf, layoutManager, layout.getManagerVersion());
    }

    private static String normalizedLedgerManagerFactoryClassName(String factoryClass, String shadedClassPrefix, boolean isShadedClassAllowed) {
        if (isShadedClassAllowed) {
            if (null == factoryClass || null == shadedClassPrefix) {
                return factoryClass;
            }
            return factoryClass.replace(shadedClassPrefix, "");
        }
        return factoryClass;
    }

    private static boolean isSameLedgerManagerFactory(AbstractConfiguration<?> conf, String leftFactoryClass, String rightFactoryClass) {
        leftFactoryClass = AbstractZkLedgerManagerFactory.normalizedLedgerManagerFactoryClassName(leftFactoryClass, conf.getShadedLedgerManagerFactoryClassPrefix(), conf.isShadedLedgerManagerFactoryClassAllowed());
        rightFactoryClass = AbstractZkLedgerManagerFactory.normalizedLedgerManagerFactoryClassName(rightFactoryClass, conf.getShadedLedgerManagerFactoryClassPrefix(), conf.isShadedLedgerManagerFactoryClassAllowed());
        return Objects.equals(leftFactoryClass, rightFactoryClass);
    }

    private static Class<? extends LedgerManagerFactory> attemptToResolveShadedLedgerManagerFactory(AbstractConfiguration<?> conf, String lmfClassName, Throwable cause) throws IOException {
        if (conf.isShadedLedgerManagerFactoryClassAllowed()) {
            String shadedPrefix = conf.getShadedLedgerManagerFactoryClassPrefix();
            log.warn("Failed to instantiate ledger manager factory {}, trying its shaded class {}{}", new Object[]{lmfClassName, shadedPrefix, lmfClassName});
            try {
                return AbstractZkLedgerManagerFactory.resolveShadedLedgerManagerFactory(lmfClassName, shadedPrefix);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Failed to instantiate ledger manager factory " + lmfClassName + " and its shaded class " + shadedPrefix + lmfClassName, cnfe);
            }
        }
        throw new IOException("Failed to instantiate ledger manager factory " + lmfClassName, cause);
    }

    private static Class<? extends LedgerManagerFactory> resolveShadedLedgerManagerFactory(String lmfClassName, String shadedClassPrefix) throws ClassNotFoundException, IOException {
        if (null == lmfClassName) {
            return null;
        }
        Class<?> theCls = Class.forName(shadedClassPrefix + lmfClassName);
        if (!LedgerManagerFactory.class.isAssignableFrom(theCls)) {
            throw new IOException("Wrong shaded ledger manager factory : " + shadedClassPrefix + lmfClassName);
        }
        return theCls.asSubclass(LedgerManagerFactory.class);
    }

    protected static LedgerManagerFactory createNewLMFactory(AbstractConfiguration conf, LayoutManager layoutManager, Class<? extends LedgerManagerFactory> factoryClass) throws IOException, InterruptedException {
        LedgerManagerFactory lmFactory;
        block11: {
            if (factoryClass == null) {
                String lmType = conf.getLedgerManagerType();
                if (lmType == null) {
                    factoryClass = HierarchicalLedgerManagerFactory.class;
                } else if ("flat".equals(lmType)) {
                    factoryClass = FlatLedgerManagerFactory.class;
                } else if ("hierarchical".equals(lmType)) {
                    factoryClass = HierarchicalLedgerManagerFactory.class;
                } else if ("longhierarchical".equals(lmType)) {
                    factoryClass = LongHierarchicalLedgerManagerFactory.class;
                } else {
                    throw new IOException("Unknown ledger manager type: " + lmType);
                }
            }
            lmFactory = ReflectionUtils.newInstance(factoryClass);
            LedgerLayout layout = new LedgerLayout(factoryClass.getName(), lmFactory.getCurrentVersion());
            try {
                layoutManager.storeLedgerLayout(layout);
            }
            catch (LayoutManager.LedgerLayoutExistsException e) {
                LedgerLayout layout2 = layoutManager.readLedgerLayout();
                if (layout2.equals(layout)) break block11;
                throw new IOException("Contention writing to layout to zookeeper,  other layout " + layout2 + " is incompatible with our layout " + layout);
            }
        }
        return lmFactory;
    }
}

