/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework;

import com.beust.jcommander.JCommander;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Strings;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.Command;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CommandUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.HelpCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli<CliFlagsT extends CliFlags> {
    private static final Logger log = LoggerFactory.getLogger(Cli.class);
    private final CliSpec<CliFlagsT> spec;
    private final JCommander commander;
    private final Map<String, Command> commandMap;
    private final Function<CliFlagsT, Boolean> runFunc;
    private final String cmdPath;
    private final PrintStream console;

    public Cli(CliSpec<CliFlagsT> spec) {
        this.spec = this.updateSpecWithDefaultValues(spec);
        this.cmdPath = Cli.getCmdPath(spec);
        this.commandMap = new TreeMap<String, Command>();
        this.console = Cli.setupConsole(spec);
        this.commander = Cli.setupCli(this.cmdPath, spec, this.commandMap);
        this.runFunc = null == spec.runFunc() ? args -> {
            this.usage();
            return false;
        } : spec.runFunc();
        if (!spec.commands().isEmpty() && !this.hasCommand("help")) {
            this.commandMap.put("help", new HelpCommand(this));
        }
    }

    static <CliFlagsT extends CliFlags> String getCmdPath(CliSpec<CliFlagsT> spec) {
        if (Strings.isNullOrEmpty(spec.parent())) {
            return spec.name();
        }
        return spec.parent() + " " + spec.name();
    }

    static <CliFlagsT extends CliFlags> PrintStream setupConsole(CliSpec<CliFlagsT> spec) {
        if (null == spec.console()) {
            return System.out;
        }
        return spec.console();
    }

    CliSpec<CliFlagsT> updateSpecWithDefaultValues(CliSpec<CliFlagsT> spec) {
        CliSpec.Builder<CliFlagsT> builder = CliSpec.newBuilder(spec);
        if (Strings.isNullOrEmpty(spec.usage())) {
            if (spec.commands().isEmpty()) {
                builder.withUsage(String.format("%s [flags] " + spec.argumentsUsage(), Cli.getCmdPath(spec)));
            } else {
                builder.withUsage(String.format("%s [flags] [command] [command options]", Cli.getCmdPath(spec)));
            }
        }
        if (!spec.commands().isEmpty() && Strings.isNullOrEmpty(spec.tailer())) {
            builder.withTailer(String.format("Use \"%s [command] --help\" or \"%s help [command]\" for more information about a command", Cli.getCmdPath(spec), Cli.getCmdPath(spec)));
        }
        return builder.build();
    }

    String name() {
        return this.spec.name();
    }

    String cmdPath() {
        return this.cmdPath;
    }

    boolean hasCommand(String command) {
        return this.commandMap.containsKey(command);
    }

    Command getCommand(String command) {
        return this.commandMap.get(command);
    }

    static <CliFlagsT extends CliFlags> JCommander setupCli(String cmdPath, CliSpec<CliFlagsT> spec, Map<String, Command> commandMap) {
        JCommander commander = new JCommander();
        commander.setProgramName(cmdPath);
        if (null != spec.flags()) {
            commander.addObject(spec.flags());
        }
        for (Command cmd : spec.commands()) {
            commandMap.put(cmd.name(), cmd);
        }
        StringBuilder usageBuilder = new StringBuilder();
        commander.getUsageFormatter().usage(usageBuilder);
        return commander;
    }

    protected void console(String msg) {
        this.console().println(msg);
    }

    protected PrintStream console() {
        return this.console;
    }

    void usage() {
        this.usage("");
    }

    void usage(String errorMsg) {
        if (Strings.isNullOrEmpty(errorMsg)) {
            CommandUtils.printDescription(this.console(), 0, 0, this.spec.description());
            this.console("");
        } else {
            CommandUtils.printDescription(this.console(), 0, 0, "Error : " + errorMsg);
            this.console("");
        }
        CommandUtils.printUsage(this.console(), this.spec.usage());
        CommandUtils.printAvailableCommands(this.commandMap, this.console());
        if (!this.spec.isCommandGroup()) {
            CommandUtils.printAvailableFlags(this.commander, this.console());
        }
        if (!this.spec.commands().isEmpty()) {
            CommandUtils.printDescription(this.console(), 0, 0, this.spec.tailer());
        }
    }

    boolean run(String[] args) {
        if (!this.spec.commands().isEmpty() && args.length == 0) {
            this.usage();
            return false;
        }
        int cmdPos = IntStream.range(0, args.length).filter(pos -> this.commandMap.containsKey(args[pos])).findFirst().orElse(args.length);
        String[] flagArgs = Arrays.copyOfRange(args, 0, cmdPos);
        if (this.spec.isCommandGroup() && flagArgs.length > 0) {
            this.usage();
            return false;
        }
        if (flagArgs.length != 0) {
            try {
                this.commander.parse(flagArgs);
            }
            catch (Exception e) {
                this.usage(e.getMessage());
                return false;
            }
        }
        if (((CliFlags)this.spec.flags()).help) {
            this.usage();
            return false;
        }
        if (cmdPos == args.length) {
            return this.runFunc.apply(this.spec.flags());
        }
        String cmd = args[cmdPos];
        Command command = this.commandMap.get(cmd);
        String[] subCmdArgs = Arrays.copyOfRange(args, cmdPos + 1, args.length);
        try {
            return command.apply(this.spec.flags(), subCmdArgs);
        }
        catch (Exception e) {
            e.printStackTrace(this.spec.console());
            this.usage(e.getMessage());
            return false;
        }
    }

    public static <CliOptsT extends CliFlags> int runCli(CliSpec<CliOptsT> spec, String[] args) {
        Cli<CliOptsT> cli = new Cli<CliOptsT>(spec);
        return cli.run(args) ? 0 : -1;
    }

    public static <CliOptsT extends CliFlags> void printUsage(CliSpec<CliOptsT> spec) {
        Cli<CliOptsT> cli = new Cli<CliOptsT>(spec);
        cli.usage();
    }

    Map<String, Command> getCommandMap() {
        return this.commandMap;
    }
}

