/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.mutable.MutableInt;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.mutable.MutableLong;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.mutable.MutableObject;

public class AvailabilityOfEntriesOfLedger {
    public static final long INVALID_ENTRYID = -1L;
    public static final AvailabilityOfEntriesOfLedger EMPTY_AVAILABILITYOFENTRIESOFLEDGER;
    public static final int HEADER_SIZE = 64;
    public static final int V0 = 0;
    public static final int CURRENT_HEADER_VERSION = 0;
    private final TreeMap<Long, SequenceGroup> sortedSequenceGroups = new TreeMap();
    private MutableObject<SequenceGroup> curSequenceGroup = new MutableObject<Object>(null);
    private MutableLong curSequenceStartEntryId = new MutableLong(-1L);
    private MutableInt curSequenceSize = new MutableInt(0);
    private boolean availabilityOfEntriesOfLedgerClosed = false;
    private long totalNumOfAvailableEntries = 0L;

    public AvailabilityOfEntriesOfLedger(PrimitiveIterator.OfLong entriesOfLedgerItr) {
        while (entriesOfLedgerItr.hasNext()) {
            this.addEntryToAvailabileEntriesOfLedger(entriesOfLedgerItr.nextLong());
        }
        this.closeStateOfEntriesOfALedger();
    }

    public AvailabilityOfEntriesOfLedger(long[] entriesOfLedger) {
        for (long entry : entriesOfLedger) {
            this.addEntryToAvailabileEntriesOfLedger(entry);
        }
        this.closeStateOfEntriesOfALedger();
    }

    public AvailabilityOfEntriesOfLedger(byte[] serializeStateOfEntriesOfLedger) {
        byte[] header = new byte[64];
        byte[] serializedSequenceGroupByteArray = new byte[24];
        System.arraycopy(serializeStateOfEntriesOfLedger, 0, header, 0, 64);
        ByteBuffer headerByteBuf = ByteBuffer.wrap(header);
        int headerVersion = headerByteBuf.getInt();
        if (headerVersion > 0) {
            throw new IllegalArgumentException("Unsupported Header Version: " + headerVersion);
        }
        int numOfSequenceGroups = headerByteBuf.getInt();
        for (int i = 0; i < numOfSequenceGroups; ++i) {
            Arrays.fill(serializedSequenceGroupByteArray, (byte)0);
            System.arraycopy(serializeStateOfEntriesOfLedger, 64 + i * 24, serializedSequenceGroupByteArray, 0, 24);
            SequenceGroup newSequenceGroup = new SequenceGroup(serializedSequenceGroupByteArray);
            this.sortedSequenceGroups.put(newSequenceGroup.getFirstSequenceStart(), newSequenceGroup);
        }
        this.setAvailabilityOfEntriesOfLedgerClosed();
    }

    public AvailabilityOfEntriesOfLedger(ByteBuf byteBuf) {
        byte[] header = new byte[64];
        byte[] serializedSequenceGroupByteArray = new byte[24];
        int readerIndex = byteBuf.readerIndex();
        byteBuf.getBytes(readerIndex, header, 0, 64);
        ByteBuffer headerByteBuf = ByteBuffer.wrap(header);
        int headerVersion = headerByteBuf.getInt();
        if (headerVersion > 0) {
            throw new IllegalArgumentException("Unsupported Header Version: " + headerVersion);
        }
        int numOfSequenceGroups = headerByteBuf.getInt();
        for (int i = 0; i < numOfSequenceGroups; ++i) {
            Arrays.fill(serializedSequenceGroupByteArray, (byte)0);
            byteBuf.getBytes(readerIndex + 64 + i * 24, serializedSequenceGroupByteArray, 0, 24);
            SequenceGroup newSequenceGroup = new SequenceGroup(serializedSequenceGroupByteArray);
            this.sortedSequenceGroups.put(newSequenceGroup.getFirstSequenceStart(), newSequenceGroup);
        }
        this.setAvailabilityOfEntriesOfLedgerClosed();
    }

    private void initializeCurSequence(long curSequenceStartEntryIdValue) {
        this.curSequenceStartEntryId.setValue(curSequenceStartEntryIdValue);
        this.curSequenceSize.setValue(1);
    }

    private void resetCurSequence() {
        this.curSequenceStartEntryId.setValue(-1L);
        this.curSequenceSize.setValue(0);
    }

    private boolean isCurSequenceInitialized() {
        return this.curSequenceStartEntryId.longValue() != -1L;
    }

    private boolean isEntryExistingInCurSequence(long entryId) {
        return this.curSequenceStartEntryId.longValue() <= entryId && entryId < this.curSequenceStartEntryId.longValue() + (long)this.curSequenceSize.intValue();
    }

    private boolean isEntryAppendableToCurSequence(long entryId) {
        return this.curSequenceStartEntryId.longValue() + (long)this.curSequenceSize.intValue() == entryId;
    }

    private void incrementCurSequenceSize() {
        this.curSequenceSize.increment();
    }

    private void createNewSequenceGroupWithCurSequence() {
        SequenceGroup curSequenceGroupValue = this.curSequenceGroup.getValue();
        curSequenceGroupValue.setSequenceGroupClosed();
        this.sortedSequenceGroups.put(curSequenceGroupValue.getFirstSequenceStart(), curSequenceGroupValue);
        this.curSequenceGroup.setValue(new SequenceGroup(this.curSequenceStartEntryId.longValue(), this.curSequenceSize.intValue()));
    }

    private boolean isCurSequenceGroupInitialized() {
        return this.curSequenceGroup.getValue() != null;
    }

    private void initializeCurSequenceGroupWithCurSequence() {
        this.curSequenceGroup.setValue(new SequenceGroup(this.curSequenceStartEntryId.longValue(), this.curSequenceSize.intValue()));
    }

    private boolean doesCurSequenceBelongToCurSequenceGroup() {
        long curSequenceStartEntryIdValue = this.curSequenceStartEntryId.longValue();
        int curSequenceSizeValue = this.curSequenceSize.intValue();
        boolean belongsToThisSequenceGroup = false;
        SequenceGroup curSequenceGroupValue = this.curSequenceGroup.getValue();
        if (curSequenceGroupValue.sequenceSize == curSequenceSizeValue && (curSequenceGroupValue.getLastSequenceStart() == -1L || curSequenceStartEntryIdValue - curSequenceGroupValue.getLastSequenceStart() == (long)curSequenceGroupValue.getSequencePeriod())) {
            belongsToThisSequenceGroup = true;
        }
        return belongsToThisSequenceGroup;
    }

    private void appendCurSequenceToCurSequenceGroup() {
        SequenceGroup curSequenceGroupValue = this.curSequenceGroup.getValue();
        curSequenceGroupValue.setLastSequenceStart(this.curSequenceStartEntryId.longValue());
        if (curSequenceGroupValue.getSequencePeriod() == 0) {
            curSequenceGroupValue.setSequencePeriod((int)(curSequenceGroupValue.getLastSequenceStart() - curSequenceGroupValue.firstSequenceStart));
        }
    }

    private void addCurSequenceToSequenceGroup() {
        if (!this.isCurSequenceGroupInitialized()) {
            this.initializeCurSequenceGroupWithCurSequence();
        } else if (this.doesCurSequenceBelongToCurSequenceGroup()) {
            this.appendCurSequenceToCurSequenceGroup();
        } else {
            this.createNewSequenceGroupWithCurSequence();
        }
    }

    private void addEntryToAvailabileEntriesOfLedger(long entryId) {
        if (!this.isCurSequenceInitialized()) {
            this.initializeCurSequence(entryId);
        } else if (!this.isEntryExistingInCurSequence(entryId)) {
            if (this.isEntryAppendableToCurSequence(entryId)) {
                this.incrementCurSequenceSize();
            } else {
                this.addCurSequenceToSequenceGroup();
                this.initializeCurSequence(entryId);
            }
        }
    }

    private void closeStateOfEntriesOfALedger() {
        SequenceGroup curSequenceGroupValue;
        if (this.isCurSequenceInitialized()) {
            this.addCurSequenceToSequenceGroup();
            this.resetCurSequence();
        }
        if ((curSequenceGroupValue = this.curSequenceGroup.getValue()) != null) {
            curSequenceGroupValue.setSequenceGroupClosed();
            this.sortedSequenceGroups.put(curSequenceGroupValue.getFirstSequenceStart(), curSequenceGroupValue);
        }
        this.setAvailabilityOfEntriesOfLedgerClosed();
    }

    private boolean isAvailabilityOfEntriesOfLedgerClosed() {
        return this.availabilityOfEntriesOfLedgerClosed;
    }

    private void setAvailabilityOfEntriesOfLedgerClosed() {
        this.availabilityOfEntriesOfLedgerClosed = true;
        for (Map.Entry<Long, SequenceGroup> seqGroupEntry : this.sortedSequenceGroups.entrySet()) {
            this.totalNumOfAvailableEntries += seqGroupEntry.getValue().getNumOfEntriesInSequenceGroup();
        }
    }

    public byte[] serializeStateOfEntriesOfLedger() {
        if (!this.isAvailabilityOfEntriesOfLedgerClosed()) {
            throw new IllegalStateException("AvailabilityOfEntriesOfLedger is not yet closed,it is illegal to call serializeStateOfEntriesOfLedger");
        }
        byte[] header = new byte[64];
        ByteBuffer headerByteBuf = ByteBuffer.wrap(header);
        byte[] serializedSequenceGroupByteArray = new byte[24];
        byte[] serializedStateByteArray = new byte[64 + this.sortedSequenceGroups.size() * 24];
        int numOfSequenceGroups = this.sortedSequenceGroups.size();
        headerByteBuf.putInt(0);
        headerByteBuf.putInt(numOfSequenceGroups);
        System.arraycopy(header, 0, serializedStateByteArray, 0, 64);
        int seqNum = 0;
        for (Map.Entry<Long, SequenceGroup> seqGroupEntry : this.sortedSequenceGroups.entrySet()) {
            SequenceGroup seqGroup = seqGroupEntry.getValue();
            Arrays.fill(serializedSequenceGroupByteArray, (byte)0);
            seqGroup.serializeSequenceGroup(serializedSequenceGroupByteArray);
            System.arraycopy(serializedSequenceGroupByteArray, 0, serializedStateByteArray, 64 + seqNum++ * 24, 24);
        }
        return serializedStateByteArray;
    }

    public boolean isEntryAvailable(long entryId) {
        if (!this.isAvailabilityOfEntriesOfLedgerClosed()) {
            throw new IllegalStateException("AvailabilityOfEntriesOfLedger is not yet closed, it is illegal to call isEntryAvailable");
        }
        Map.Entry<Long, SequenceGroup> seqGroup = this.sortedSequenceGroups.floorEntry(entryId);
        if (seqGroup == null) {
            return false;
        }
        return seqGroup.getValue().isEntryAvailable(entryId);
    }

    /*
     * Unable to fully structure code
     */
    public List<Long> getUnavailableEntries(long startEntryId, long lastEntryId, BitSet availabilityOfEntries) {
        if (!this.isAvailabilityOfEntriesOfLedgerClosed()) {
            throw new IllegalStateException("AvailabilityOfEntriesOfLedger is not yet closed, it is illegal to call getUnavailableEntries");
        }
        unavailableEntries = new ArrayList<Long>();
        curSeqGroup = null;
        noSeqGroupRemaining = false;
        bitSetIndex = 0;
        entryId = startEntryId;
        while (entryId <= lastEntryId) {
            block12: {
                block11: {
                    if (!noSeqGroupRemaining) break block11;
                    if (availabilityOfEntries.get(bitSetIndex)) {
                        unavailableEntries.add(entryId);
                    }
                    break block12;
                }
                if (curSeqGroup != null && entryId <= SequenceGroup.access$1300(curSeqGroup)) ** GOTO lbl-1000
                curSeqGroupEntry = this.sortedSequenceGroups.floorEntry(entryId);
                if (curSeqGroupEntry == null) {
                    if (availabilityOfEntries.get(bitSetIndex)) {
                        unavailableEntries.add(entryId);
                    }
                    if (this.sortedSequenceGroups.ceilingEntry(entryId) == null) {
                        noSeqGroupRemaining = true;
                    }
                } else {
                    curSeqGroup = curSeqGroupEntry.getValue();
                    if (entryId > SequenceGroup.access$1300(curSeqGroup)) {
                        if (availabilityOfEntries.get(bitSetIndex)) {
                            unavailableEntries.add(entryId);
                        }
                        noSeqGroupRemaining = true;
                    } else if (availabilityOfEntries.get(bitSetIndex) && !SequenceGroup.access$1200(curSeqGroup, entryId)) {
                        unavailableEntries.add(entryId);
                    }
                }
            }
            ++entryId;
            ++bitSetIndex;
        }
        return unavailableEntries;
    }

    public long getTotalNumOfAvailableEntries() {
        if (!this.isAvailabilityOfEntriesOfLedgerClosed()) {
            throw new IllegalStateException("AvailabilityOfEntriesOfLedger is not yet closed, it is illegal to call getTotalNumOfAvailableEntries");
        }
        return this.totalNumOfAvailableEntries;
    }

    static {
        long[] tmpArray = new long[]{};
        EMPTY_AVAILABILITYOFENTRIESOFLEDGER = new AvailabilityOfEntriesOfLedger(Arrays.stream(tmpArray).iterator());
    }

    private static class SequenceGroup {
        private static final int SEQUENCEGROUP_BYTES = 24;
        private final long firstSequenceStart;
        private final int sequenceSize;
        private long lastSequenceStart = -1L;
        private int sequencePeriod;
        private boolean isSequenceGroupClosed = false;
        private long numOfEntriesInSequenceGroup = 0L;

        private SequenceGroup(long firstSequenceStart, int sequenceSize) {
            this.firstSequenceStart = firstSequenceStart;
            this.lastSequenceStart = firstSequenceStart;
            this.sequenceSize = sequenceSize;
            this.sequencePeriod = 0;
        }

        private SequenceGroup(byte[] serializedSequenceGroup) {
            ByteBuffer buffer = ByteBuffer.wrap(serializedSequenceGroup);
            this.firstSequenceStart = buffer.getLong();
            this.lastSequenceStart = buffer.getLong();
            this.sequenceSize = buffer.getInt();
            this.sequencePeriod = buffer.getInt();
            this.setSequenceGroupClosed();
        }

        private boolean isSequenceGroupClosed() {
            return this.isSequenceGroupClosed;
        }

        private void setSequenceGroupClosed() {
            this.isSequenceGroupClosed = true;
            this.numOfEntriesInSequenceGroup = this.lastSequenceStart - this.firstSequenceStart == 0L ? (long)this.sequenceSize : ((this.lastSequenceStart - this.firstSequenceStart) / (long)this.sequencePeriod + 1L) * (long)this.sequenceSize;
        }

        private long getNumOfEntriesInSequenceGroup() {
            if (!this.isSequenceGroupClosed()) {
                throw new IllegalStateException("SequenceGroup is not yet closed, it is illegal to call getNumOfEntriesInSequenceGroup");
            }
            return this.numOfEntriesInSequenceGroup;
        }

        private long getLastSequenceStart() {
            return this.lastSequenceStart;
        }

        private long getLastEntryInSequenceGroup() {
            return this.lastSequenceStart + (long)this.sequenceSize;
        }

        private void setLastSequenceStart(long lastSequenceStart) {
            this.lastSequenceStart = lastSequenceStart;
        }

        private int getSequencePeriod() {
            return this.sequencePeriod;
        }

        private void setSequencePeriod(int sequencePeriod) {
            this.sequencePeriod = sequencePeriod;
        }

        private long getFirstSequenceStart() {
            return this.firstSequenceStart;
        }

        private void serializeSequenceGroup(byte[] byteArrayForSerialization) {
            if (!this.isSequenceGroupClosed()) {
                throw new IllegalStateException("SequenceGroup is not yet closed, it is illegal to call serializeSequenceGroup");
            }
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayForSerialization);
            buffer.putLong(this.firstSequenceStart);
            buffer.putLong(this.lastSequenceStart);
            buffer.putInt(this.sequenceSize);
            buffer.putInt(this.sequencePeriod);
        }

        private boolean isEntryAvailable(long entryId) {
            if (!this.isSequenceGroupClosed()) {
                throw new IllegalStateException("SequenceGroup is not yet closed, it is illegal to call isEntryAvailable");
            }
            if (entryId >= this.firstSequenceStart && entryId <= this.lastSequenceStart + (long)this.sequenceSize) {
                if (this.sequencePeriod == 0) {
                    return entryId - this.firstSequenceStart < (long)this.sequenceSize;
                }
                return (entryId - this.firstSequenceStart) % (long)this.sequencePeriod < (long)this.sequenceSize;
            }
            return false;
        }

        static /* synthetic */ long access$1300(SequenceGroup x0) {
            return x0.getLastEntryInSequenceGroup();
        }
    }
}

