/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.FileUpload;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerFileUpload;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpServerFileUploadImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.NettyFileUpload;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;

class NettyFileUploadDataFactory
extends DefaultHttpDataFactory {
    private final ContextInternal context;
    private final HttpServerRequest request;
    private final Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler;

    NettyFileUploadDataFactory(ContextInternal context, HttpServerRequest request, Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler) {
        super(false);
        this.context = context;
        this.request = request;
        this.lazyUploadHandler = lazyUploadHandler;
    }

    public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        NettyFileUpload nettyUpload = new NettyFileUpload(this.context, this.request, name, filename, contentType, contentTransferEncoding, charset, size);
        HttpServerFileUploadImpl upload = new HttpServerFileUploadImpl(this.context, nettyUpload, name, filename, contentType, contentTransferEncoding, charset, size);
        Handler<HttpServerFileUpload> uploadHandler = this.lazyUploadHandler.get();
        if (uploadHandler != null) {
            this.context.dispatch(upload, uploadHandler);
        }
        return nettyUpload;
    }
}

