/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdSessionWatcher
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdSessionWatcher.class);
    private final Client client;
    private SessionEvent currentStatus;
    private final Consumer<SessionEvent> sessionListener;
    private final long monitorTimeoutMillis;
    private final long tickTimeMillis;
    private final ScheduledExecutorService scheduler;
    private final ScheduledFuture<?> task;
    private long disconnectedAt = 0L;

    public EtcdSessionWatcher(Client client, long sessionTimeoutMillis, Consumer<SessionEvent> sessionListener) {
        this.client = client;
        this.monitorTimeoutMillis = sessionTimeoutMillis * 5L / 6L;
        this.tickTimeMillis = sessionTimeoutMillis / 15L;
        this.sessionListener = sessionListener;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("metadata-store-etcd-session-watcher"));
        this.task = this.scheduler.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::checkConnectionStatus), this.tickTimeMillis, this.tickTimeMillis, TimeUnit.MILLISECONDS);
        this.currentStatus = SessionEvent.SessionReestablished;
    }

    @Override
    public void close() throws Exception {
        this.task.cancel(true);
        this.scheduler.shutdownNow();
        this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private synchronized void checkConnectionStatus() {
        try {
            SessionEvent ectdClientState;
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)this.client.getKVClient().get(ByteSequence.from("/".getBytes(StandardCharsets.UTF_8))).thenRun(() -> future.complete(SessionEvent.Reconnected))).exceptionally(ex -> {
                future.complete(SessionEvent.ConnectionLost);
                return null;
            });
            try {
                ectdClientState = (SessionEvent)((Object)future.get(this.tickTimeMillis, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                ectdClientState = SessionEvent.ConnectionLost;
            }
            this.checkState(ectdClientState);
        }
        catch (InterruptedException | RejectedExecutionException e) {
            this.task.cancel(true);
        }
        catch (Throwable t) {
            log.warn("Error while checking Etcd connection status", t);
        }
    }

    synchronized void setSessionInvalid() {
        this.currentStatus = SessionEvent.SessionLost;
    }

    private void checkState(SessionEvent etcdlientState) {
        switch (etcdlientState) {
            case SessionLost: {
                if (this.currentStatus == SessionEvent.SessionLost) break;
                log.error("Etcd lease has expired");
                this.currentStatus = SessionEvent.SessionLost;
                this.sessionListener.accept(this.currentStatus);
                break;
            }
            case ConnectionLost: {
                long timeRemainingMillis;
                if (this.disconnectedAt == 0L) {
                    this.disconnectedAt = System.nanoTime();
                }
                if ((timeRemainingMillis = this.monitorTimeoutMillis - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.disconnectedAt)) <= 0L && this.currentStatus != SessionEvent.SessionLost) {
                    log.error("Etcd lease keep-alive timeout. Notifying session is lost.");
                    this.currentStatus = SessionEvent.SessionLost;
                    this.sessionListener.accept(this.currentStatus);
                    break;
                }
                if (this.currentStatus == SessionEvent.SessionLost) break;
                log.warn("Etcd client is disconnected. Waiting to reconnect, time remaining = {} seconds", (Object)((double)timeRemainingMillis / 1000.0));
                if (this.currentStatus != SessionEvent.SessionReestablished) break;
                this.currentStatus = SessionEvent.ConnectionLost;
                this.sessionListener.accept(this.currentStatus);
                break;
            }
            default: {
                if (this.currentStatus == SessionEvent.SessionReestablished) break;
                log.info("Etcd client reconnection with server quorum. Current status: {}", (Object)this.currentStatus);
                this.disconnectedAt = 0L;
                this.sessionListener.accept(SessionEvent.Reconnected);
                if (this.currentStatus == SessionEvent.SessionLost) {
                    this.sessionListener.accept(SessionEvent.SessionReestablished);
                }
                this.currentStatus = SessionEvent.SessionReestablished;
            }
        }
    }
}

