/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class WorkerConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String workerId;
    private String workerHostname;
    private int workerPort;
    private String functionMetadataTopicName;
    private String pulsarServiceUrl;
    private String pulsarWebServiceUrl;
    private String clusterCoordinationTopicName;
    private String functionMetadataSnapshotsTopicPath;
    private String pulsarFunctionsNamespace;
    private int numFunctionPackageReplicas;
    private String downloadDirectory;
    private long snapshotFreqMs;
    private String stateStorageServiceUrl;
    private String functionAssignmentTopicName;
    private String schedulerClassName;
    private long failureCheckFreqMs;
    private long rescheduleTimeoutMs;
    private int initialBrokerReconnectMaxRetries;
    private int assignmentWriteMaxRetries;
    private long instanceLivenessCheckFreqMs;
    private ThreadContainerFactory threadContainerFactory;
    private ProcessContainerFactory processContainerFactory;

    public String getFunctionMetadataTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionMetadataTopicName);
    }

    public String getClusterCoordinationTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.clusterCoordinationTopicName);
    }

    public String getFunctionAssignmentTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionAssignmentTopicName);
    }

    public static WorkerConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (WorkerConfig)mapper.readValue(new File(yamlFile), WorkerConfig.class);
    }

    public WorkerConfig setWorkerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    public WorkerConfig setWorkerHostname(String workerHostname) {
        this.workerHostname = workerHostname;
        return this;
    }

    public WorkerConfig setWorkerPort(int workerPort) {
        this.workerPort = workerPort;
        return this;
    }

    public WorkerConfig setFunctionMetadataTopicName(String functionMetadataTopicName) {
        this.functionMetadataTopicName = functionMetadataTopicName;
        return this;
    }

    public WorkerConfig setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        return this;
    }

    public WorkerConfig setPulsarWebServiceUrl(String pulsarWebServiceUrl) {
        this.pulsarWebServiceUrl = pulsarWebServiceUrl;
        return this;
    }

    public WorkerConfig setClusterCoordinationTopicName(String clusterCoordinationTopicName) {
        this.clusterCoordinationTopicName = clusterCoordinationTopicName;
        return this;
    }

    public WorkerConfig setFunctionMetadataSnapshotsTopicPath(String functionMetadataSnapshotsTopicPath) {
        this.functionMetadataSnapshotsTopicPath = functionMetadataSnapshotsTopicPath;
        return this;
    }

    public WorkerConfig setPulsarFunctionsNamespace(String pulsarFunctionsNamespace) {
        this.pulsarFunctionsNamespace = pulsarFunctionsNamespace;
        return this;
    }

    public WorkerConfig setNumFunctionPackageReplicas(int numFunctionPackageReplicas) {
        this.numFunctionPackageReplicas = numFunctionPackageReplicas;
        return this;
    }

    public WorkerConfig setDownloadDirectory(String downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
        return this;
    }

    public WorkerConfig setSnapshotFreqMs(long snapshotFreqMs) {
        this.snapshotFreqMs = snapshotFreqMs;
        return this;
    }

    public WorkerConfig setStateStorageServiceUrl(String stateStorageServiceUrl) {
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        return this;
    }

    public WorkerConfig setFunctionAssignmentTopicName(String functionAssignmentTopicName) {
        this.functionAssignmentTopicName = functionAssignmentTopicName;
        return this;
    }

    public WorkerConfig setSchedulerClassName(String schedulerClassName) {
        this.schedulerClassName = schedulerClassName;
        return this;
    }

    public WorkerConfig setFailureCheckFreqMs(long failureCheckFreqMs) {
        this.failureCheckFreqMs = failureCheckFreqMs;
        return this;
    }

    public WorkerConfig setRescheduleTimeoutMs(long rescheduleTimeoutMs) {
        this.rescheduleTimeoutMs = rescheduleTimeoutMs;
        return this;
    }

    public WorkerConfig setInitialBrokerReconnectMaxRetries(int initialBrokerReconnectMaxRetries) {
        this.initialBrokerReconnectMaxRetries = initialBrokerReconnectMaxRetries;
        return this;
    }

    public WorkerConfig setAssignmentWriteMaxRetries(int assignmentWriteMaxRetries) {
        this.assignmentWriteMaxRetries = assignmentWriteMaxRetries;
        return this;
    }

    public WorkerConfig setInstanceLivenessCheckFreqMs(long instanceLivenessCheckFreqMs) {
        this.instanceLivenessCheckFreqMs = instanceLivenessCheckFreqMs;
        return this;
    }

    public WorkerConfig setThreadContainerFactory(ThreadContainerFactory threadContainerFactory) {
        this.threadContainerFactory = threadContainerFactory;
        return this;
    }

    public WorkerConfig setProcessContainerFactory(ProcessContainerFactory processContainerFactory) {
        this.processContainerFactory = processContainerFactory;
        return this;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getWorkerHostname() {
        return this.workerHostname;
    }

    public int getWorkerPort() {
        return this.workerPort;
    }

    public String getFunctionMetadataTopicName() {
        return this.functionMetadataTopicName;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPulsarWebServiceUrl() {
        return this.pulsarWebServiceUrl;
    }

    public String getClusterCoordinationTopicName() {
        return this.clusterCoordinationTopicName;
    }

    public String getFunctionMetadataSnapshotsTopicPath() {
        return this.functionMetadataSnapshotsTopicPath;
    }

    public String getPulsarFunctionsNamespace() {
        return this.pulsarFunctionsNamespace;
    }

    public int getNumFunctionPackageReplicas() {
        return this.numFunctionPackageReplicas;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public long getSnapshotFreqMs() {
        return this.snapshotFreqMs;
    }

    public String getStateStorageServiceUrl() {
        return this.stateStorageServiceUrl;
    }

    public String getFunctionAssignmentTopicName() {
        return this.functionAssignmentTopicName;
    }

    public String getSchedulerClassName() {
        return this.schedulerClassName;
    }

    public long getFailureCheckFreqMs() {
        return this.failureCheckFreqMs;
    }

    public long getRescheduleTimeoutMs() {
        return this.rescheduleTimeoutMs;
    }

    public int getInitialBrokerReconnectMaxRetries() {
        return this.initialBrokerReconnectMaxRetries;
    }

    public int getAssignmentWriteMaxRetries() {
        return this.assignmentWriteMaxRetries;
    }

    public long getInstanceLivenessCheckFreqMs() {
        return this.instanceLivenessCheckFreqMs;
    }

    public ThreadContainerFactory getThreadContainerFactory() {
        return this.threadContainerFactory;
    }

    public ProcessContainerFactory getProcessContainerFactory() {
        return this.processContainerFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        String this$workerHostname = this.getWorkerHostname();
        String other$workerHostname = other.getWorkerHostname();
        if (this$workerHostname == null ? other$workerHostname != null : !this$workerHostname.equals(other$workerHostname)) {
            return false;
        }
        if (this.getWorkerPort() != other.getWorkerPort()) {
            return false;
        }
        String this$functionMetadataTopicName = this.getFunctionMetadataTopicName();
        String other$functionMetadataTopicName = other.getFunctionMetadataTopicName();
        if (this$functionMetadataTopicName == null ? other$functionMetadataTopicName != null : !this$functionMetadataTopicName.equals(other$functionMetadataTopicName)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        String other$pulsarWebServiceUrl = other.getPulsarWebServiceUrl();
        if (this$pulsarWebServiceUrl == null ? other$pulsarWebServiceUrl != null : !this$pulsarWebServiceUrl.equals(other$pulsarWebServiceUrl)) {
            return false;
        }
        String this$clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        String other$clusterCoordinationTopicName = other.getClusterCoordinationTopicName();
        if (this$clusterCoordinationTopicName == null ? other$clusterCoordinationTopicName != null : !this$clusterCoordinationTopicName.equals(other$clusterCoordinationTopicName)) {
            return false;
        }
        String this$functionMetadataSnapshotsTopicPath = this.getFunctionMetadataSnapshotsTopicPath();
        String other$functionMetadataSnapshotsTopicPath = other.getFunctionMetadataSnapshotsTopicPath();
        if (this$functionMetadataSnapshotsTopicPath == null ? other$functionMetadataSnapshotsTopicPath != null : !this$functionMetadataSnapshotsTopicPath.equals(other$functionMetadataSnapshotsTopicPath)) {
            return false;
        }
        String this$pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        String other$pulsarFunctionsNamespace = other.getPulsarFunctionsNamespace();
        if (this$pulsarFunctionsNamespace == null ? other$pulsarFunctionsNamespace != null : !this$pulsarFunctionsNamespace.equals(other$pulsarFunctionsNamespace)) {
            return false;
        }
        if (this.getNumFunctionPackageReplicas() != other.getNumFunctionPackageReplicas()) {
            return false;
        }
        String this$downloadDirectory = this.getDownloadDirectory();
        String other$downloadDirectory = other.getDownloadDirectory();
        if (this$downloadDirectory == null ? other$downloadDirectory != null : !this$downloadDirectory.equals(other$downloadDirectory)) {
            return false;
        }
        if (this.getSnapshotFreqMs() != other.getSnapshotFreqMs()) {
            return false;
        }
        String this$stateStorageServiceUrl = this.getStateStorageServiceUrl();
        String other$stateStorageServiceUrl = other.getStateStorageServiceUrl();
        if (this$stateStorageServiceUrl == null ? other$stateStorageServiceUrl != null : !this$stateStorageServiceUrl.equals(other$stateStorageServiceUrl)) {
            return false;
        }
        String this$functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        String other$functionAssignmentTopicName = other.getFunctionAssignmentTopicName();
        if (this$functionAssignmentTopicName == null ? other$functionAssignmentTopicName != null : !this$functionAssignmentTopicName.equals(other$functionAssignmentTopicName)) {
            return false;
        }
        String this$schedulerClassName = this.getSchedulerClassName();
        String other$schedulerClassName = other.getSchedulerClassName();
        if (this$schedulerClassName == null ? other$schedulerClassName != null : !this$schedulerClassName.equals(other$schedulerClassName)) {
            return false;
        }
        if (this.getFailureCheckFreqMs() != other.getFailureCheckFreqMs()) {
            return false;
        }
        if (this.getRescheduleTimeoutMs() != other.getRescheduleTimeoutMs()) {
            return false;
        }
        if (this.getInitialBrokerReconnectMaxRetries() != other.getInitialBrokerReconnectMaxRetries()) {
            return false;
        }
        if (this.getAssignmentWriteMaxRetries() != other.getAssignmentWriteMaxRetries()) {
            return false;
        }
        if (this.getInstanceLivenessCheckFreqMs() != other.getInstanceLivenessCheckFreqMs()) {
            return false;
        }
        ThreadContainerFactory this$threadContainerFactory = this.getThreadContainerFactory();
        ThreadContainerFactory other$threadContainerFactory = other.getThreadContainerFactory();
        if (this$threadContainerFactory == null ? other$threadContainerFactory != null : !((Object)this$threadContainerFactory).equals(other$threadContainerFactory)) {
            return false;
        }
        ProcessContainerFactory this$processContainerFactory = this.getProcessContainerFactory();
        ProcessContainerFactory other$processContainerFactory = other.getProcessContainerFactory();
        return !(this$processContainerFactory == null ? other$processContainerFactory != null : !((Object)this$processContainerFactory).equals(other$processContainerFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        String $workerHostname = this.getWorkerHostname();
        result = result * 59 + ($workerHostname == null ? 43 : $workerHostname.hashCode());
        result = result * 59 + this.getWorkerPort();
        String $functionMetadataTopicName = this.getFunctionMetadataTopicName();
        result = result * 59 + ($functionMetadataTopicName == null ? 43 : $functionMetadataTopicName.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        result = result * 59 + ($pulsarWebServiceUrl == null ? 43 : $pulsarWebServiceUrl.hashCode());
        String $clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        result = result * 59 + ($clusterCoordinationTopicName == null ? 43 : $clusterCoordinationTopicName.hashCode());
        String $functionMetadataSnapshotsTopicPath = this.getFunctionMetadataSnapshotsTopicPath();
        result = result * 59 + ($functionMetadataSnapshotsTopicPath == null ? 43 : $functionMetadataSnapshotsTopicPath.hashCode());
        String $pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        result = result * 59 + ($pulsarFunctionsNamespace == null ? 43 : $pulsarFunctionsNamespace.hashCode());
        result = result * 59 + this.getNumFunctionPackageReplicas();
        String $downloadDirectory = this.getDownloadDirectory();
        result = result * 59 + ($downloadDirectory == null ? 43 : $downloadDirectory.hashCode());
        long $snapshotFreqMs = this.getSnapshotFreqMs();
        result = result * 59 + (int)($snapshotFreqMs >>> 32 ^ $snapshotFreqMs);
        String $stateStorageServiceUrl = this.getStateStorageServiceUrl();
        result = result * 59 + ($stateStorageServiceUrl == null ? 43 : $stateStorageServiceUrl.hashCode());
        String $functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        result = result * 59 + ($functionAssignmentTopicName == null ? 43 : $functionAssignmentTopicName.hashCode());
        String $schedulerClassName = this.getSchedulerClassName();
        result = result * 59 + ($schedulerClassName == null ? 43 : $schedulerClassName.hashCode());
        long $failureCheckFreqMs = this.getFailureCheckFreqMs();
        result = result * 59 + (int)($failureCheckFreqMs >>> 32 ^ $failureCheckFreqMs);
        long $rescheduleTimeoutMs = this.getRescheduleTimeoutMs();
        result = result * 59 + (int)($rescheduleTimeoutMs >>> 32 ^ $rescheduleTimeoutMs);
        result = result * 59 + this.getInitialBrokerReconnectMaxRetries();
        result = result * 59 + this.getAssignmentWriteMaxRetries();
        long $instanceLivenessCheckFreqMs = this.getInstanceLivenessCheckFreqMs();
        result = result * 59 + (int)($instanceLivenessCheckFreqMs >>> 32 ^ $instanceLivenessCheckFreqMs);
        ThreadContainerFactory $threadContainerFactory = this.getThreadContainerFactory();
        result = result * 59 + ($threadContainerFactory == null ? 43 : ((Object)$threadContainerFactory).hashCode());
        ProcessContainerFactory $processContainerFactory = this.getProcessContainerFactory();
        result = result * 59 + ($processContainerFactory == null ? 43 : ((Object)$processContainerFactory).hashCode());
        return result;
    }

    public String toString() {
        return "WorkerConfig(workerId=" + this.getWorkerId() + ", workerHostname=" + this.getWorkerHostname() + ", workerPort=" + this.getWorkerPort() + ", functionMetadataTopicName=" + this.getFunctionMetadataTopicName() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarWebServiceUrl=" + this.getPulsarWebServiceUrl() + ", clusterCoordinationTopicName=" + this.getClusterCoordinationTopicName() + ", functionMetadataSnapshotsTopicPath=" + this.getFunctionMetadataSnapshotsTopicPath() + ", pulsarFunctionsNamespace=" + this.getPulsarFunctionsNamespace() + ", numFunctionPackageReplicas=" + this.getNumFunctionPackageReplicas() + ", downloadDirectory=" + this.getDownloadDirectory() + ", snapshotFreqMs=" + this.getSnapshotFreqMs() + ", stateStorageServiceUrl=" + this.getStateStorageServiceUrl() + ", functionAssignmentTopicName=" + this.getFunctionAssignmentTopicName() + ", schedulerClassName=" + this.getSchedulerClassName() + ", failureCheckFreqMs=" + this.getFailureCheckFreqMs() + ", rescheduleTimeoutMs=" + this.getRescheduleTimeoutMs() + ", initialBrokerReconnectMaxRetries=" + this.getInitialBrokerReconnectMaxRetries() + ", assignmentWriteMaxRetries=" + this.getAssignmentWriteMaxRetries() + ", instanceLivenessCheckFreqMs=" + this.getInstanceLivenessCheckFreqMs() + ", threadContainerFactory=" + this.getThreadContainerFactory() + ", processContainerFactory=" + this.getProcessContainerFactory() + ")";
    }

    static class ProcessContainerFactory {
        private String javaInstanceJarLocation;
        private String pythonInstanceLocation;
        private String logDirectory;

        public ProcessContainerFactory setJavaInstanceJarLocation(String javaInstanceJarLocation) {
            this.javaInstanceJarLocation = javaInstanceJarLocation;
            return this;
        }

        public ProcessContainerFactory setPythonInstanceLocation(String pythonInstanceLocation) {
            this.pythonInstanceLocation = pythonInstanceLocation;
            return this;
        }

        public ProcessContainerFactory setLogDirectory(String logDirectory) {
            this.logDirectory = logDirectory;
            return this;
        }

        public String getJavaInstanceJarLocation() {
            return this.javaInstanceJarLocation;
        }

        public String getPythonInstanceLocation() {
            return this.pythonInstanceLocation;
        }

        public String getLogDirectory() {
            return this.logDirectory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessContainerFactory)) {
                return false;
            }
            ProcessContainerFactory other = (ProcessContainerFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$javaInstanceJarLocation = this.getJavaInstanceJarLocation();
            String other$javaInstanceJarLocation = other.getJavaInstanceJarLocation();
            if (this$javaInstanceJarLocation == null ? other$javaInstanceJarLocation != null : !this$javaInstanceJarLocation.equals(other$javaInstanceJarLocation)) {
                return false;
            }
            String this$pythonInstanceLocation = this.getPythonInstanceLocation();
            String other$pythonInstanceLocation = other.getPythonInstanceLocation();
            if (this$pythonInstanceLocation == null ? other$pythonInstanceLocation != null : !this$pythonInstanceLocation.equals(other$pythonInstanceLocation)) {
                return false;
            }
            String this$logDirectory = this.getLogDirectory();
            String other$logDirectory = other.getLogDirectory();
            return !(this$logDirectory == null ? other$logDirectory != null : !this$logDirectory.equals(other$logDirectory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessContainerFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $javaInstanceJarLocation = this.getJavaInstanceJarLocation();
            result = result * 59 + ($javaInstanceJarLocation == null ? 43 : $javaInstanceJarLocation.hashCode());
            String $pythonInstanceLocation = this.getPythonInstanceLocation();
            result = result * 59 + ($pythonInstanceLocation == null ? 43 : $pythonInstanceLocation.hashCode());
            String $logDirectory = this.getLogDirectory();
            result = result * 59 + ($logDirectory == null ? 43 : $logDirectory.hashCode());
            return result;
        }

        public String toString() {
            return "WorkerConfig.ProcessContainerFactory(javaInstanceJarLocation=" + this.getJavaInstanceJarLocation() + ", pythonInstanceLocation=" + this.getPythonInstanceLocation() + ", logDirectory=" + this.getLogDirectory() + ")";
        }
    }

    static class ThreadContainerFactory {
        private String threadGroupName;

        public ThreadContainerFactory setThreadGroupName(String threadGroupName) {
            this.threadGroupName = threadGroupName;
            return this;
        }

        public String getThreadGroupName() {
            return this.threadGroupName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadContainerFactory)) {
                return false;
            }
            ThreadContainerFactory other = (ThreadContainerFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$threadGroupName = this.getThreadGroupName();
            String other$threadGroupName = other.getThreadGroupName();
            return !(this$threadGroupName == null ? other$threadGroupName != null : !this$threadGroupName.equals(other$threadGroupName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadContainerFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $threadGroupName = this.getThreadGroupName();
            result = result * 59 + ($threadGroupName == null ? 43 : $threadGroupName.hashCode());
            return result;
        }

        public String toString() {
            return "WorkerConfig.ThreadContainerFactory(threadGroupName=" + this.getThreadGroupName() + ")";
        }
    }
}

