/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.worker.ClusterServiceCoordinator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.Utils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerService {
    private static final Logger log = LoggerFactory.getLogger(WorkerService.class);
    private final WorkerConfig workerConfig;
    private PulsarClient client;
    private FunctionRuntimeManager functionRuntimeManager;
    private FunctionMetaDataManager functionMetaDataManager;
    private ClusterServiceCoordinator clusterServiceCoordinator;
    private Namespace dlogNamespace;
    private MembershipManager membershipManager;
    private SchedulerManager schedulerManager;
    private boolean isInitialized = false;
    private final ScheduledExecutorService statsUpdater;
    private ConnectorsManager connectorsManager;

    public WorkerService(WorkerConfig workerConfig) {
        this.workerConfig = workerConfig;
        this.statsUpdater = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("worker-stats-updater"));
    }

    public void start(URI dlogUri) throws InterruptedException {
        log.info("Starting worker {}...", (Object)this.workerConfig.getWorkerId());
        try {
            log.info("Worker Configs: {}", (Object)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.workerConfig));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to print worker configs with error {}", (Object)e.getMessage(), (Object)e);
        }
        DistributedLogConfiguration dlogConf = Utils.getDlogConf(this.workerConfig);
        try {
            this.dlogNamespace = NamespaceBuilder.newBuilder().conf(dlogConf).clientId("function-worker-" + this.workerConfig.getWorkerId()).uri(dlogUri).build();
        }
        catch (Exception e) {
            log.error("Failed to initialize dlog namespace {} for storing function packages", (Object)dlogUri, (Object)e);
            throw new RuntimeException(e);
        }
        try {
            ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.workerConfig.getPulsarServiceUrl());
            if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.workerConfig.getClientAuthenticationParameters())) {
                clientBuilder.authentication(this.workerConfig.getClientAuthenticationPlugin(), this.workerConfig.getClientAuthenticationParameters());
            }
            clientBuilder.enableTls(this.workerConfig.isUseTls());
            clientBuilder.allowTlsInsecureConnection(this.workerConfig.isTlsAllowInsecureConnection());
            clientBuilder.tlsTrustCertsFilePath(this.workerConfig.getTlsTrustCertsFilePath());
            clientBuilder.enableTlsHostnameVerification(this.workerConfig.isTlsHostnameVerificationEnable());
            this.client = clientBuilder.build();
            log.info("Created Pulsar client");
            this.schedulerManager = new SchedulerManager(this.workerConfig, this.client);
            this.functionMetaDataManager = new FunctionMetaDataManager(this.workerConfig, this.schedulerManager, this.client);
            this.connectorsManager = new ConnectorsManager(this.workerConfig);
            this.membershipManager = new MembershipManager(this.workerConfig, this.client);
            this.functionRuntimeManager = new FunctionRuntimeManager(this.workerConfig, this.client, this.dlogNamespace, this.membershipManager, this.connectorsManager);
            this.schedulerManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.schedulerManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.schedulerManager.setMembershipManager(this.membershipManager);
            this.functionMetaDataManager.initialize();
            log.info("Start cluster services...");
            this.clusterServiceCoordinator = new ClusterServiceCoordinator(this.workerConfig.getWorkerId(), this.membershipManager);
            this.clusterServiceCoordinator.addTask("membership-monitor", this.workerConfig.getFailureCheckFreqMs(), () -> this.membershipManager.checkFailures(this.functionMetaDataManager, this.functionRuntimeManager, this.schedulerManager));
            this.clusterServiceCoordinator.start();
            this.functionRuntimeManager.start();
            this.isInitialized = true;
            this.connectorsManager = new ConnectorsManager(this.workerConfig);
            int metricsSamplingPeriodSec = this.workerConfig.getMetricsSamplingPeriodSec();
            if (metricsSamplingPeriodSec > 0) {
                this.statsUpdater.scheduleAtFixedRate(() -> this.functionRuntimeManager.updateRates(), metricsSamplingPeriodSec, metricsSamplingPeriodSec, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            log.error("Error Starting up in worker", t);
            throw new RuntimeException(t);
        }
    }

    public void stop() {
        if (null != this.functionMetaDataManager) {
            try {
                this.functionMetaDataManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function metadata manager", (Throwable)e);
            }
        }
        if (null != this.functionRuntimeManager) {
            try {
                this.functionRuntimeManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function runtime manager", (Throwable)e);
            }
        }
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close pulsar client", (Throwable)e);
            }
        }
        if (null != this.clusterServiceCoordinator) {
            this.clusterServiceCoordinator.close();
        }
        if (null != this.membershipManager) {
            try {
                this.membershipManager.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close membership manager", (Throwable)e);
            }
        }
        if (null != this.schedulerManager) {
            this.schedulerManager.close();
        }
    }

    public WorkerConfig getWorkerConfig() {
        return this.workerConfig;
    }

    public PulsarClient getClient() {
        return this.client;
    }

    public FunctionRuntimeManager getFunctionRuntimeManager() {
        return this.functionRuntimeManager;
    }

    public FunctionMetaDataManager getFunctionMetaDataManager() {
        return this.functionMetaDataManager;
    }

    public ClusterServiceCoordinator getClusterServiceCoordinator() {
        return this.clusterServiceCoordinator;
    }

    public Namespace getDlogNamespace() {
        return this.dlogNamespace;
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ScheduledExecutorService getStatsUpdater() {
        return this.statsUpdater;
    }

    public ConnectorsManager getConnectorsManager() {
        return this.connectorsManager;
    }
}

