/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.Resources;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private final WorkerConfig workerConfig;
    private final WorkerService workerService;
    private static final String MATCH_ALL = "/*";

    private static String getErrorMessage(Server server, int port, Exception ex) {
        if (ex instanceof BindException) {
            URI uri = server.getURI();
            return String.format("%s http://%s:%d", ex.getMessage(), uri.getHost(), port);
        }
        return ex.getMessage();
    }

    public WorkerServer(WorkerService workerService) {
        this.workerConfig = workerService.getWorkerConfig();
        this.workerService = workerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Server server = new Server(this.workerConfig.getWorkerPort());
        ArrayList<ServletContextHandler> handlers = new ArrayList<ServletContextHandler>(2);
        handlers.add(WorkerServer.newServletContextHandler("/admin", new ResourceConfig(Resources.getApiResources()), this.workerService));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v2", new ResourceConfig(Resources.getApiResources()), this.workerService));
        handlers.add(WorkerServer.newServletContextHandler("/", new ResourceConfig(Resources.getRootResources()), this.workerService));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler()});
        server.setHandler((Handler)handlerCollection);
        try {
            server.start();
            log.info("Worker Server started at {}", (Object)server.getURI());
            server.join();
        }
        catch (Exception ex) {
            log.error("ex: {}", (Object)ex, (Object)ex);
            String message = WorkerServer.getErrorMessage(server, this.workerConfig.getWorkerPort(), ex);
            log.error(message);
            System.exit(1);
        }
        finally {
            server.destroy();
        }
    }

    public String getThreadName() {
        return "worker-server-thread-" + this.workerConfig.getWorkerId();
    }

    public static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService) {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setAttribute("function-worker", (Object)workerService);
        contextHandler.setContextPath(contextPath);
        ServletHolder apiServlet = new ServletHolder((Servlet)new ServletContainer(config));
        contextHandler.addServlet(apiServlet, MATCH_ALL);
        if (workerService.getWorkerConfig().isAuthenticationEnabled()) {
            FilterHolder filter = new FilterHolder((Filter)new AuthenticationFilter(workerService.getAuthenticationService()));
            contextHandler.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        return contextHandler;
    }
}

