/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.configuration.PulsarConfiguration;

public class WorkerConfig
implements Serializable,
PulsarConfiguration {
    private static final long serialVersionUID = 1L;
    private String workerId;
    private String workerHostname;
    private int workerPort;
    private int workerPortTls;
    private String connectorsDirectory = "./connectors";
    private String functionMetadataTopicName;
    private String functionWebServiceUrl;
    private String pulsarServiceUrl;
    private String pulsarWebServiceUrl;
    private String clusterCoordinationTopicName;
    private String pulsarFunctionsNamespace;
    private String pulsarFunctionsCluster;
    private int numFunctionPackageReplicas;
    private String downloadDirectory;
    private String stateStorageServiceUrl;
    private String functionAssignmentTopicName;
    private String schedulerClassName;
    private long failureCheckFreqMs;
    private long rescheduleTimeoutMs;
    private int initialBrokerReconnectMaxRetries;
    private int assignmentWriteMaxRetries;
    private long instanceLivenessCheckFreqMs;
    private String clientAuthenticationPlugin;
    private String clientAuthenticationParameters;
    private long topicCompactionFrequencySec = 1800L;
    private int metricsSamplingPeriodSec = 60;
    private boolean tlsEnabled = false;
    private String tlsCertificateFilePath;
    private String tlsKeyFilePath;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    private boolean useTls = false;
    private boolean tlsHostnameVerificationEnable = false;
    private boolean authenticationEnabled = false;
    private Set<String> authenticationProviders = Sets.newTreeSet();
    private boolean authorizationEnabled = false;
    private Set<String> superUserRoles = Sets.newTreeSet();
    private Properties properties = new Properties();
    private ThreadContainerFactory threadContainerFactory;
    private ProcessContainerFactory processContainerFactory;
    private KubernetesContainerFactory kubernetesContainerFactory;

    public String getFunctionMetadataTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionMetadataTopicName);
    }

    public String getClusterCoordinationTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.clusterCoordinationTopicName);
    }

    public String getFunctionAssignmentTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionAssignmentTopicName);
    }

    public static WorkerConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (WorkerConfig)mapper.readValue(new File(yamlFile), WorkerConfig.class);
    }

    public String getWorkerId() {
        if (StringUtils.isBlank((CharSequence)this.workerId)) {
            this.workerId = String.format("%s-%s", this.getWorkerHostname(), this.getWorkerPort());
        }
        return this.workerId;
    }

    public String getWorkerHostname() {
        if (StringUtils.isBlank((CharSequence)this.workerHostname)) {
            this.workerHostname = WorkerConfig.unsafeLocalhostResolve();
        }
        return this.workerHostname;
    }

    public String getWorkerWebAddress() {
        return String.format("http://%s:%d", this.getWorkerHostname(), this.getWorkerPort());
    }

    public static String unsafeLocalhostResolve() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Failed to resolve localhost name.", ex);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public WorkerConfig setWorkerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    public WorkerConfig setWorkerHostname(String workerHostname) {
        this.workerHostname = workerHostname;
        return this;
    }

    public WorkerConfig setWorkerPort(int workerPort) {
        this.workerPort = workerPort;
        return this;
    }

    public WorkerConfig setWorkerPortTls(int workerPortTls) {
        this.workerPortTls = workerPortTls;
        return this;
    }

    public WorkerConfig setConnectorsDirectory(String connectorsDirectory) {
        this.connectorsDirectory = connectorsDirectory;
        return this;
    }

    public WorkerConfig setFunctionMetadataTopicName(String functionMetadataTopicName) {
        this.functionMetadataTopicName = functionMetadataTopicName;
        return this;
    }

    public WorkerConfig setFunctionWebServiceUrl(String functionWebServiceUrl) {
        this.functionWebServiceUrl = functionWebServiceUrl;
        return this;
    }

    public WorkerConfig setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        return this;
    }

    public WorkerConfig setPulsarWebServiceUrl(String pulsarWebServiceUrl) {
        this.pulsarWebServiceUrl = pulsarWebServiceUrl;
        return this;
    }

    public WorkerConfig setClusterCoordinationTopicName(String clusterCoordinationTopicName) {
        this.clusterCoordinationTopicName = clusterCoordinationTopicName;
        return this;
    }

    public WorkerConfig setPulsarFunctionsNamespace(String pulsarFunctionsNamespace) {
        this.pulsarFunctionsNamespace = pulsarFunctionsNamespace;
        return this;
    }

    public WorkerConfig setPulsarFunctionsCluster(String pulsarFunctionsCluster) {
        this.pulsarFunctionsCluster = pulsarFunctionsCluster;
        return this;
    }

    public WorkerConfig setNumFunctionPackageReplicas(int numFunctionPackageReplicas) {
        this.numFunctionPackageReplicas = numFunctionPackageReplicas;
        return this;
    }

    public WorkerConfig setDownloadDirectory(String downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
        return this;
    }

    public WorkerConfig setStateStorageServiceUrl(String stateStorageServiceUrl) {
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        return this;
    }

    public WorkerConfig setFunctionAssignmentTopicName(String functionAssignmentTopicName) {
        this.functionAssignmentTopicName = functionAssignmentTopicName;
        return this;
    }

    public WorkerConfig setSchedulerClassName(String schedulerClassName) {
        this.schedulerClassName = schedulerClassName;
        return this;
    }

    public WorkerConfig setFailureCheckFreqMs(long failureCheckFreqMs) {
        this.failureCheckFreqMs = failureCheckFreqMs;
        return this;
    }

    public WorkerConfig setRescheduleTimeoutMs(long rescheduleTimeoutMs) {
        this.rescheduleTimeoutMs = rescheduleTimeoutMs;
        return this;
    }

    public WorkerConfig setInitialBrokerReconnectMaxRetries(int initialBrokerReconnectMaxRetries) {
        this.initialBrokerReconnectMaxRetries = initialBrokerReconnectMaxRetries;
        return this;
    }

    public WorkerConfig setAssignmentWriteMaxRetries(int assignmentWriteMaxRetries) {
        this.assignmentWriteMaxRetries = assignmentWriteMaxRetries;
        return this;
    }

    public WorkerConfig setInstanceLivenessCheckFreqMs(long instanceLivenessCheckFreqMs) {
        this.instanceLivenessCheckFreqMs = instanceLivenessCheckFreqMs;
        return this;
    }

    public WorkerConfig setClientAuthenticationPlugin(String clientAuthenticationPlugin) {
        this.clientAuthenticationPlugin = clientAuthenticationPlugin;
        return this;
    }

    public WorkerConfig setClientAuthenticationParameters(String clientAuthenticationParameters) {
        this.clientAuthenticationParameters = clientAuthenticationParameters;
        return this;
    }

    public WorkerConfig setTopicCompactionFrequencySec(long topicCompactionFrequencySec) {
        this.topicCompactionFrequencySec = topicCompactionFrequencySec;
        return this;
    }

    public WorkerConfig setMetricsSamplingPeriodSec(int metricsSamplingPeriodSec) {
        this.metricsSamplingPeriodSec = metricsSamplingPeriodSec;
        return this;
    }

    public WorkerConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public WorkerConfig setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
        return this;
    }

    public WorkerConfig setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
        return this;
    }

    public WorkerConfig setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        return this;
    }

    public WorkerConfig setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        return this;
    }

    public WorkerConfig setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
        return this;
    }

    public WorkerConfig setUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    public WorkerConfig setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        return this;
    }

    public WorkerConfig setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
        return this;
    }

    public WorkerConfig setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
        return this;
    }

    public WorkerConfig setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
        return this;
    }

    public WorkerConfig setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
        return this;
    }

    public WorkerConfig setThreadContainerFactory(ThreadContainerFactory threadContainerFactory) {
        this.threadContainerFactory = threadContainerFactory;
        return this;
    }

    public WorkerConfig setProcessContainerFactory(ProcessContainerFactory processContainerFactory) {
        this.processContainerFactory = processContainerFactory;
        return this;
    }

    public WorkerConfig setKubernetesContainerFactory(KubernetesContainerFactory kubernetesContainerFactory) {
        this.kubernetesContainerFactory = kubernetesContainerFactory;
        return this;
    }

    public int getWorkerPort() {
        return this.workerPort;
    }

    public int getWorkerPortTls() {
        return this.workerPortTls;
    }

    public String getConnectorsDirectory() {
        return this.connectorsDirectory;
    }

    public String getFunctionMetadataTopicName() {
        return this.functionMetadataTopicName;
    }

    public String getFunctionWebServiceUrl() {
        return this.functionWebServiceUrl;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPulsarWebServiceUrl() {
        return this.pulsarWebServiceUrl;
    }

    public String getClusterCoordinationTopicName() {
        return this.clusterCoordinationTopicName;
    }

    public String getPulsarFunctionsNamespace() {
        return this.pulsarFunctionsNamespace;
    }

    public String getPulsarFunctionsCluster() {
        return this.pulsarFunctionsCluster;
    }

    public int getNumFunctionPackageReplicas() {
        return this.numFunctionPackageReplicas;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public String getStateStorageServiceUrl() {
        return this.stateStorageServiceUrl;
    }

    public String getFunctionAssignmentTopicName() {
        return this.functionAssignmentTopicName;
    }

    public String getSchedulerClassName() {
        return this.schedulerClassName;
    }

    public long getFailureCheckFreqMs() {
        return this.failureCheckFreqMs;
    }

    public long getRescheduleTimeoutMs() {
        return this.rescheduleTimeoutMs;
    }

    public int getInitialBrokerReconnectMaxRetries() {
        return this.initialBrokerReconnectMaxRetries;
    }

    public int getAssignmentWriteMaxRetries() {
        return this.assignmentWriteMaxRetries;
    }

    public long getInstanceLivenessCheckFreqMs() {
        return this.instanceLivenessCheckFreqMs;
    }

    public String getClientAuthenticationPlugin() {
        return this.clientAuthenticationPlugin;
    }

    public String getClientAuthenticationParameters() {
        return this.clientAuthenticationParameters;
    }

    public long getTopicCompactionFrequencySec() {
        return this.topicCompactionFrequencySec;
    }

    public int getMetricsSamplingPeriodSec() {
        return this.metricsSamplingPeriodSec;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ThreadContainerFactory getThreadContainerFactory() {
        return this.threadContainerFactory;
    }

    public ProcessContainerFactory getProcessContainerFactory() {
        return this.processContainerFactory;
    }

    public KubernetesContainerFactory getKubernetesContainerFactory() {
        return this.kubernetesContainerFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        String this$workerHostname = this.getWorkerHostname();
        String other$workerHostname = other.getWorkerHostname();
        if (this$workerHostname == null ? other$workerHostname != null : !this$workerHostname.equals(other$workerHostname)) {
            return false;
        }
        if (this.getWorkerPort() != other.getWorkerPort()) {
            return false;
        }
        if (this.getWorkerPortTls() != other.getWorkerPortTls()) {
            return false;
        }
        String this$connectorsDirectory = this.getConnectorsDirectory();
        String other$connectorsDirectory = other.getConnectorsDirectory();
        if (this$connectorsDirectory == null ? other$connectorsDirectory != null : !this$connectorsDirectory.equals(other$connectorsDirectory)) {
            return false;
        }
        String this$functionMetadataTopicName = this.getFunctionMetadataTopicName();
        String other$functionMetadataTopicName = other.getFunctionMetadataTopicName();
        if (this$functionMetadataTopicName == null ? other$functionMetadataTopicName != null : !this$functionMetadataTopicName.equals(other$functionMetadataTopicName)) {
            return false;
        }
        String this$functionWebServiceUrl = this.getFunctionWebServiceUrl();
        String other$functionWebServiceUrl = other.getFunctionWebServiceUrl();
        if (this$functionWebServiceUrl == null ? other$functionWebServiceUrl != null : !this$functionWebServiceUrl.equals(other$functionWebServiceUrl)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        String other$pulsarWebServiceUrl = other.getPulsarWebServiceUrl();
        if (this$pulsarWebServiceUrl == null ? other$pulsarWebServiceUrl != null : !this$pulsarWebServiceUrl.equals(other$pulsarWebServiceUrl)) {
            return false;
        }
        String this$clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        String other$clusterCoordinationTopicName = other.getClusterCoordinationTopicName();
        if (this$clusterCoordinationTopicName == null ? other$clusterCoordinationTopicName != null : !this$clusterCoordinationTopicName.equals(other$clusterCoordinationTopicName)) {
            return false;
        }
        String this$pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        String other$pulsarFunctionsNamespace = other.getPulsarFunctionsNamespace();
        if (this$pulsarFunctionsNamespace == null ? other$pulsarFunctionsNamespace != null : !this$pulsarFunctionsNamespace.equals(other$pulsarFunctionsNamespace)) {
            return false;
        }
        String this$pulsarFunctionsCluster = this.getPulsarFunctionsCluster();
        String other$pulsarFunctionsCluster = other.getPulsarFunctionsCluster();
        if (this$pulsarFunctionsCluster == null ? other$pulsarFunctionsCluster != null : !this$pulsarFunctionsCluster.equals(other$pulsarFunctionsCluster)) {
            return false;
        }
        if (this.getNumFunctionPackageReplicas() != other.getNumFunctionPackageReplicas()) {
            return false;
        }
        String this$downloadDirectory = this.getDownloadDirectory();
        String other$downloadDirectory = other.getDownloadDirectory();
        if (this$downloadDirectory == null ? other$downloadDirectory != null : !this$downloadDirectory.equals(other$downloadDirectory)) {
            return false;
        }
        String this$stateStorageServiceUrl = this.getStateStorageServiceUrl();
        String other$stateStorageServiceUrl = other.getStateStorageServiceUrl();
        if (this$stateStorageServiceUrl == null ? other$stateStorageServiceUrl != null : !this$stateStorageServiceUrl.equals(other$stateStorageServiceUrl)) {
            return false;
        }
        String this$functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        String other$functionAssignmentTopicName = other.getFunctionAssignmentTopicName();
        if (this$functionAssignmentTopicName == null ? other$functionAssignmentTopicName != null : !this$functionAssignmentTopicName.equals(other$functionAssignmentTopicName)) {
            return false;
        }
        String this$schedulerClassName = this.getSchedulerClassName();
        String other$schedulerClassName = other.getSchedulerClassName();
        if (this$schedulerClassName == null ? other$schedulerClassName != null : !this$schedulerClassName.equals(other$schedulerClassName)) {
            return false;
        }
        if (this.getFailureCheckFreqMs() != other.getFailureCheckFreqMs()) {
            return false;
        }
        if (this.getRescheduleTimeoutMs() != other.getRescheduleTimeoutMs()) {
            return false;
        }
        if (this.getInitialBrokerReconnectMaxRetries() != other.getInitialBrokerReconnectMaxRetries()) {
            return false;
        }
        if (this.getAssignmentWriteMaxRetries() != other.getAssignmentWriteMaxRetries()) {
            return false;
        }
        if (this.getInstanceLivenessCheckFreqMs() != other.getInstanceLivenessCheckFreqMs()) {
            return false;
        }
        String this$clientAuthenticationPlugin = this.getClientAuthenticationPlugin();
        String other$clientAuthenticationPlugin = other.getClientAuthenticationPlugin();
        if (this$clientAuthenticationPlugin == null ? other$clientAuthenticationPlugin != null : !this$clientAuthenticationPlugin.equals(other$clientAuthenticationPlugin)) {
            return false;
        }
        String this$clientAuthenticationParameters = this.getClientAuthenticationParameters();
        String other$clientAuthenticationParameters = other.getClientAuthenticationParameters();
        if (this$clientAuthenticationParameters == null ? other$clientAuthenticationParameters != null : !this$clientAuthenticationParameters.equals(other$clientAuthenticationParameters)) {
            return false;
        }
        if (this.getTopicCompactionFrequencySec() != other.getTopicCompactionFrequencySec()) {
            return false;
        }
        if (this.getMetricsSamplingPeriodSec() != other.getMetricsSamplingPeriodSec()) {
            return false;
        }
        if (this.isTlsEnabled() != other.isTlsEnabled()) {
            return false;
        }
        String this$tlsCertificateFilePath = this.getTlsCertificateFilePath();
        String other$tlsCertificateFilePath = other.getTlsCertificateFilePath();
        if (this$tlsCertificateFilePath == null ? other$tlsCertificateFilePath != null : !this$tlsCertificateFilePath.equals(other$tlsCertificateFilePath)) {
            return false;
        }
        String this$tlsKeyFilePath = this.getTlsKeyFilePath();
        String other$tlsKeyFilePath = other.getTlsKeyFilePath();
        if (this$tlsKeyFilePath == null ? other$tlsKeyFilePath != null : !this$tlsKeyFilePath.equals(other$tlsKeyFilePath)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsRequireTrustedClientCertOnConnect() != other.isTlsRequireTrustedClientCertOnConnect()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        Set<String> this$authenticationProviders = this.getAuthenticationProviders();
        Set<String> other$authenticationProviders = other.getAuthenticationProviders();
        if (this$authenticationProviders == null ? other$authenticationProviders != null : !((Object)this$authenticationProviders).equals(other$authenticationProviders)) {
            return false;
        }
        if (this.isAuthorizationEnabled() != other.isAuthorizationEnabled()) {
            return false;
        }
        Set<String> this$superUserRoles = this.getSuperUserRoles();
        Set<String> other$superUserRoles = other.getSuperUserRoles();
        if (this$superUserRoles == null ? other$superUserRoles != null : !((Object)this$superUserRoles).equals(other$superUserRoles)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        ThreadContainerFactory this$threadContainerFactory = this.getThreadContainerFactory();
        ThreadContainerFactory other$threadContainerFactory = other.getThreadContainerFactory();
        if (this$threadContainerFactory == null ? other$threadContainerFactory != null : !((Object)this$threadContainerFactory).equals(other$threadContainerFactory)) {
            return false;
        }
        ProcessContainerFactory this$processContainerFactory = this.getProcessContainerFactory();
        ProcessContainerFactory other$processContainerFactory = other.getProcessContainerFactory();
        if (this$processContainerFactory == null ? other$processContainerFactory != null : !((Object)this$processContainerFactory).equals(other$processContainerFactory)) {
            return false;
        }
        KubernetesContainerFactory this$kubernetesContainerFactory = this.getKubernetesContainerFactory();
        KubernetesContainerFactory other$kubernetesContainerFactory = other.getKubernetesContainerFactory();
        return !(this$kubernetesContainerFactory == null ? other$kubernetesContainerFactory != null : !((Object)this$kubernetesContainerFactory).equals(other$kubernetesContainerFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        String $workerHostname = this.getWorkerHostname();
        result = result * 59 + ($workerHostname == null ? 43 : $workerHostname.hashCode());
        result = result * 59 + this.getWorkerPort();
        result = result * 59 + this.getWorkerPortTls();
        String $connectorsDirectory = this.getConnectorsDirectory();
        result = result * 59 + ($connectorsDirectory == null ? 43 : $connectorsDirectory.hashCode());
        String $functionMetadataTopicName = this.getFunctionMetadataTopicName();
        result = result * 59 + ($functionMetadataTopicName == null ? 43 : $functionMetadataTopicName.hashCode());
        String $functionWebServiceUrl = this.getFunctionWebServiceUrl();
        result = result * 59 + ($functionWebServiceUrl == null ? 43 : $functionWebServiceUrl.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        result = result * 59 + ($pulsarWebServiceUrl == null ? 43 : $pulsarWebServiceUrl.hashCode());
        String $clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        result = result * 59 + ($clusterCoordinationTopicName == null ? 43 : $clusterCoordinationTopicName.hashCode());
        String $pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        result = result * 59 + ($pulsarFunctionsNamespace == null ? 43 : $pulsarFunctionsNamespace.hashCode());
        String $pulsarFunctionsCluster = this.getPulsarFunctionsCluster();
        result = result * 59 + ($pulsarFunctionsCluster == null ? 43 : $pulsarFunctionsCluster.hashCode());
        result = result * 59 + this.getNumFunctionPackageReplicas();
        String $downloadDirectory = this.getDownloadDirectory();
        result = result * 59 + ($downloadDirectory == null ? 43 : $downloadDirectory.hashCode());
        String $stateStorageServiceUrl = this.getStateStorageServiceUrl();
        result = result * 59 + ($stateStorageServiceUrl == null ? 43 : $stateStorageServiceUrl.hashCode());
        String $functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        result = result * 59 + ($functionAssignmentTopicName == null ? 43 : $functionAssignmentTopicName.hashCode());
        String $schedulerClassName = this.getSchedulerClassName();
        result = result * 59 + ($schedulerClassName == null ? 43 : $schedulerClassName.hashCode());
        long $failureCheckFreqMs = this.getFailureCheckFreqMs();
        result = result * 59 + (int)($failureCheckFreqMs >>> 32 ^ $failureCheckFreqMs);
        long $rescheduleTimeoutMs = this.getRescheduleTimeoutMs();
        result = result * 59 + (int)($rescheduleTimeoutMs >>> 32 ^ $rescheduleTimeoutMs);
        result = result * 59 + this.getInitialBrokerReconnectMaxRetries();
        result = result * 59 + this.getAssignmentWriteMaxRetries();
        long $instanceLivenessCheckFreqMs = this.getInstanceLivenessCheckFreqMs();
        result = result * 59 + (int)($instanceLivenessCheckFreqMs >>> 32 ^ $instanceLivenessCheckFreqMs);
        String $clientAuthenticationPlugin = this.getClientAuthenticationPlugin();
        result = result * 59 + ($clientAuthenticationPlugin == null ? 43 : $clientAuthenticationPlugin.hashCode());
        String $clientAuthenticationParameters = this.getClientAuthenticationParameters();
        result = result * 59 + ($clientAuthenticationParameters == null ? 43 : $clientAuthenticationParameters.hashCode());
        long $topicCompactionFrequencySec = this.getTopicCompactionFrequencySec();
        result = result * 59 + (int)($topicCompactionFrequencySec >>> 32 ^ $topicCompactionFrequencySec);
        result = result * 59 + this.getMetricsSamplingPeriodSec();
        result = result * 59 + (this.isTlsEnabled() ? 79 : 97);
        String $tlsCertificateFilePath = this.getTlsCertificateFilePath();
        result = result * 59 + ($tlsCertificateFilePath == null ? 43 : $tlsCertificateFilePath.hashCode());
        String $tlsKeyFilePath = this.getTlsKeyFilePath();
        result = result * 59 + ($tlsKeyFilePath == null ? 43 : $tlsKeyFilePath.hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsRequireTrustedClientCertOnConnect() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        Set<String> $authenticationProviders = this.getAuthenticationProviders();
        result = result * 59 + ($authenticationProviders == null ? 43 : ((Object)$authenticationProviders).hashCode());
        result = result * 59 + (this.isAuthorizationEnabled() ? 79 : 97);
        Set<String> $superUserRoles = this.getSuperUserRoles();
        result = result * 59 + ($superUserRoles == null ? 43 : ((Object)$superUserRoles).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        ThreadContainerFactory $threadContainerFactory = this.getThreadContainerFactory();
        result = result * 59 + ($threadContainerFactory == null ? 43 : ((Object)$threadContainerFactory).hashCode());
        ProcessContainerFactory $processContainerFactory = this.getProcessContainerFactory();
        result = result * 59 + ($processContainerFactory == null ? 43 : ((Object)$processContainerFactory).hashCode());
        KubernetesContainerFactory $kubernetesContainerFactory = this.getKubernetesContainerFactory();
        result = result * 59 + ($kubernetesContainerFactory == null ? 43 : ((Object)$kubernetesContainerFactory).hashCode());
        return result;
    }

    public String toString() {
        return "WorkerConfig(workerId=" + this.getWorkerId() + ", workerHostname=" + this.getWorkerHostname() + ", workerPort=" + this.getWorkerPort() + ", workerPortTls=" + this.getWorkerPortTls() + ", connectorsDirectory=" + this.getConnectorsDirectory() + ", functionMetadataTopicName=" + this.getFunctionMetadataTopicName() + ", functionWebServiceUrl=" + this.getFunctionWebServiceUrl() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarWebServiceUrl=" + this.getPulsarWebServiceUrl() + ", clusterCoordinationTopicName=" + this.getClusterCoordinationTopicName() + ", pulsarFunctionsNamespace=" + this.getPulsarFunctionsNamespace() + ", pulsarFunctionsCluster=" + this.getPulsarFunctionsCluster() + ", numFunctionPackageReplicas=" + this.getNumFunctionPackageReplicas() + ", downloadDirectory=" + this.getDownloadDirectory() + ", stateStorageServiceUrl=" + this.getStateStorageServiceUrl() + ", functionAssignmentTopicName=" + this.getFunctionAssignmentTopicName() + ", schedulerClassName=" + this.getSchedulerClassName() + ", failureCheckFreqMs=" + this.getFailureCheckFreqMs() + ", rescheduleTimeoutMs=" + this.getRescheduleTimeoutMs() + ", initialBrokerReconnectMaxRetries=" + this.getInitialBrokerReconnectMaxRetries() + ", assignmentWriteMaxRetries=" + this.getAssignmentWriteMaxRetries() + ", instanceLivenessCheckFreqMs=" + this.getInstanceLivenessCheckFreqMs() + ", clientAuthenticationPlugin=" + this.getClientAuthenticationPlugin() + ", clientAuthenticationParameters=" + this.getClientAuthenticationParameters() + ", topicCompactionFrequencySec=" + this.getTopicCompactionFrequencySec() + ", metricsSamplingPeriodSec=" + this.getMetricsSamplingPeriodSec() + ", tlsEnabled=" + this.isTlsEnabled() + ", tlsCertificateFilePath=" + this.getTlsCertificateFilePath() + ", tlsKeyFilePath=" + this.getTlsKeyFilePath() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsRequireTrustedClientCertOnConnect=" + this.isTlsRequireTrustedClientCertOnConnect() + ", useTls=" + this.isUseTls() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", authenticationProviders=" + this.getAuthenticationProviders() + ", authorizationEnabled=" + this.isAuthorizationEnabled() + ", superUserRoles=" + this.getSuperUserRoles() + ", properties=" + this.getProperties() + ", threadContainerFactory=" + this.getThreadContainerFactory() + ", processContainerFactory=" + this.getProcessContainerFactory() + ", kubernetesContainerFactory=" + this.getKubernetesContainerFactory() + ")";
    }

    public static class KubernetesContainerFactory {
        private String k8Uri;
        private String jobNamespace;
        private String pulsarDockerImageName;
        private String pulsarRootDir;
        private Boolean submittingInsidePod;
        private String pulsarServiceUrl;
        private String pulsarAdminUrl;
        private Boolean installUserCodeDependencies;
        private Map<String, String> customLabels;
        private Integer expectedMetricsCollectionInterval;

        public KubernetesContainerFactory setK8Uri(String k8Uri) {
            this.k8Uri = k8Uri;
            return this;
        }

        public KubernetesContainerFactory setJobNamespace(String jobNamespace) {
            this.jobNamespace = jobNamespace;
            return this;
        }

        public KubernetesContainerFactory setPulsarDockerImageName(String pulsarDockerImageName) {
            this.pulsarDockerImageName = pulsarDockerImageName;
            return this;
        }

        public KubernetesContainerFactory setPulsarRootDir(String pulsarRootDir) {
            this.pulsarRootDir = pulsarRootDir;
            return this;
        }

        public KubernetesContainerFactory setSubmittingInsidePod(Boolean submittingInsidePod) {
            this.submittingInsidePod = submittingInsidePod;
            return this;
        }

        public KubernetesContainerFactory setPulsarServiceUrl(String pulsarServiceUrl) {
            this.pulsarServiceUrl = pulsarServiceUrl;
            return this;
        }

        public KubernetesContainerFactory setPulsarAdminUrl(String pulsarAdminUrl) {
            this.pulsarAdminUrl = pulsarAdminUrl;
            return this;
        }

        public KubernetesContainerFactory setInstallUserCodeDependencies(Boolean installUserCodeDependencies) {
            this.installUserCodeDependencies = installUserCodeDependencies;
            return this;
        }

        public KubernetesContainerFactory setCustomLabels(Map<String, String> customLabels) {
            this.customLabels = customLabels;
            return this;
        }

        public KubernetesContainerFactory setExpectedMetricsCollectionInterval(Integer expectedMetricsCollectionInterval) {
            this.expectedMetricsCollectionInterval = expectedMetricsCollectionInterval;
            return this;
        }

        public String getK8Uri() {
            return this.k8Uri;
        }

        public String getJobNamespace() {
            return this.jobNamespace;
        }

        public String getPulsarDockerImageName() {
            return this.pulsarDockerImageName;
        }

        public String getPulsarRootDir() {
            return this.pulsarRootDir;
        }

        public Boolean getSubmittingInsidePod() {
            return this.submittingInsidePod;
        }

        public String getPulsarServiceUrl() {
            return this.pulsarServiceUrl;
        }

        public String getPulsarAdminUrl() {
            return this.pulsarAdminUrl;
        }

        public Boolean getInstallUserCodeDependencies() {
            return this.installUserCodeDependencies;
        }

        public Map<String, String> getCustomLabels() {
            return this.customLabels;
        }

        public Integer getExpectedMetricsCollectionInterval() {
            return this.expectedMetricsCollectionInterval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KubernetesContainerFactory)) {
                return false;
            }
            KubernetesContainerFactory other = (KubernetesContainerFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$k8Uri = this.getK8Uri();
            String other$k8Uri = other.getK8Uri();
            if (this$k8Uri == null ? other$k8Uri != null : !this$k8Uri.equals(other$k8Uri)) {
                return false;
            }
            String this$jobNamespace = this.getJobNamespace();
            String other$jobNamespace = other.getJobNamespace();
            if (this$jobNamespace == null ? other$jobNamespace != null : !this$jobNamespace.equals(other$jobNamespace)) {
                return false;
            }
            String this$pulsarDockerImageName = this.getPulsarDockerImageName();
            String other$pulsarDockerImageName = other.getPulsarDockerImageName();
            if (this$pulsarDockerImageName == null ? other$pulsarDockerImageName != null : !this$pulsarDockerImageName.equals(other$pulsarDockerImageName)) {
                return false;
            }
            String this$pulsarRootDir = this.getPulsarRootDir();
            String other$pulsarRootDir = other.getPulsarRootDir();
            if (this$pulsarRootDir == null ? other$pulsarRootDir != null : !this$pulsarRootDir.equals(other$pulsarRootDir)) {
                return false;
            }
            Boolean this$submittingInsidePod = this.getSubmittingInsidePod();
            Boolean other$submittingInsidePod = other.getSubmittingInsidePod();
            if (this$submittingInsidePod == null ? other$submittingInsidePod != null : !((Object)this$submittingInsidePod).equals(other$submittingInsidePod)) {
                return false;
            }
            String this$pulsarServiceUrl = this.getPulsarServiceUrl();
            String other$pulsarServiceUrl = other.getPulsarServiceUrl();
            if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
                return false;
            }
            String this$pulsarAdminUrl = this.getPulsarAdminUrl();
            String other$pulsarAdminUrl = other.getPulsarAdminUrl();
            if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
                return false;
            }
            Boolean this$installUserCodeDependencies = this.getInstallUserCodeDependencies();
            Boolean other$installUserCodeDependencies = other.getInstallUserCodeDependencies();
            if (this$installUserCodeDependencies == null ? other$installUserCodeDependencies != null : !((Object)this$installUserCodeDependencies).equals(other$installUserCodeDependencies)) {
                return false;
            }
            Map<String, String> this$customLabels = this.getCustomLabels();
            Map<String, String> other$customLabels = other.getCustomLabels();
            if (this$customLabels == null ? other$customLabels != null : !((Object)this$customLabels).equals(other$customLabels)) {
                return false;
            }
            Integer this$expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
            Integer other$expectedMetricsCollectionInterval = other.getExpectedMetricsCollectionInterval();
            return !(this$expectedMetricsCollectionInterval == null ? other$expectedMetricsCollectionInterval != null : !((Object)this$expectedMetricsCollectionInterval).equals(other$expectedMetricsCollectionInterval));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KubernetesContainerFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $k8Uri = this.getK8Uri();
            result = result * 59 + ($k8Uri == null ? 43 : $k8Uri.hashCode());
            String $jobNamespace = this.getJobNamespace();
            result = result * 59 + ($jobNamespace == null ? 43 : $jobNamespace.hashCode());
            String $pulsarDockerImageName = this.getPulsarDockerImageName();
            result = result * 59 + ($pulsarDockerImageName == null ? 43 : $pulsarDockerImageName.hashCode());
            String $pulsarRootDir = this.getPulsarRootDir();
            result = result * 59 + ($pulsarRootDir == null ? 43 : $pulsarRootDir.hashCode());
            Boolean $submittingInsidePod = this.getSubmittingInsidePod();
            result = result * 59 + ($submittingInsidePod == null ? 43 : ((Object)$submittingInsidePod).hashCode());
            String $pulsarServiceUrl = this.getPulsarServiceUrl();
            result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
            String $pulsarAdminUrl = this.getPulsarAdminUrl();
            result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
            Boolean $installUserCodeDependencies = this.getInstallUserCodeDependencies();
            result = result * 59 + ($installUserCodeDependencies == null ? 43 : ((Object)$installUserCodeDependencies).hashCode());
            Map<String, String> $customLabels = this.getCustomLabels();
            result = result * 59 + ($customLabels == null ? 43 : ((Object)$customLabels).hashCode());
            Integer $expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
            result = result * 59 + ($expectedMetricsCollectionInterval == null ? 43 : ((Object)$expectedMetricsCollectionInterval).hashCode());
            return result;
        }

        public String toString() {
            return "WorkerConfig.KubernetesContainerFactory(k8Uri=" + this.getK8Uri() + ", jobNamespace=" + this.getJobNamespace() + ", pulsarDockerImageName=" + this.getPulsarDockerImageName() + ", pulsarRootDir=" + this.getPulsarRootDir() + ", submittingInsidePod=" + this.getSubmittingInsidePod() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", installUserCodeDependencies=" + this.getInstallUserCodeDependencies() + ", customLabels=" + this.getCustomLabels() + ", expectedMetricsCollectionInterval=" + this.getExpectedMetricsCollectionInterval() + ")";
        }
    }

    public static class ProcessContainerFactory {
        private String javaInstanceJarLocation;
        private String pythonInstanceLocation;
        private String logDirectory;

        public ProcessContainerFactory setJavaInstanceJarLocation(String javaInstanceJarLocation) {
            this.javaInstanceJarLocation = javaInstanceJarLocation;
            return this;
        }

        public ProcessContainerFactory setPythonInstanceLocation(String pythonInstanceLocation) {
            this.pythonInstanceLocation = pythonInstanceLocation;
            return this;
        }

        public ProcessContainerFactory setLogDirectory(String logDirectory) {
            this.logDirectory = logDirectory;
            return this;
        }

        public String getJavaInstanceJarLocation() {
            return this.javaInstanceJarLocation;
        }

        public String getPythonInstanceLocation() {
            return this.pythonInstanceLocation;
        }

        public String getLogDirectory() {
            return this.logDirectory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessContainerFactory)) {
                return false;
            }
            ProcessContainerFactory other = (ProcessContainerFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$javaInstanceJarLocation = this.getJavaInstanceJarLocation();
            String other$javaInstanceJarLocation = other.getJavaInstanceJarLocation();
            if (this$javaInstanceJarLocation == null ? other$javaInstanceJarLocation != null : !this$javaInstanceJarLocation.equals(other$javaInstanceJarLocation)) {
                return false;
            }
            String this$pythonInstanceLocation = this.getPythonInstanceLocation();
            String other$pythonInstanceLocation = other.getPythonInstanceLocation();
            if (this$pythonInstanceLocation == null ? other$pythonInstanceLocation != null : !this$pythonInstanceLocation.equals(other$pythonInstanceLocation)) {
                return false;
            }
            String this$logDirectory = this.getLogDirectory();
            String other$logDirectory = other.getLogDirectory();
            return !(this$logDirectory == null ? other$logDirectory != null : !this$logDirectory.equals(other$logDirectory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessContainerFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $javaInstanceJarLocation = this.getJavaInstanceJarLocation();
            result = result * 59 + ($javaInstanceJarLocation == null ? 43 : $javaInstanceJarLocation.hashCode());
            String $pythonInstanceLocation = this.getPythonInstanceLocation();
            result = result * 59 + ($pythonInstanceLocation == null ? 43 : $pythonInstanceLocation.hashCode());
            String $logDirectory = this.getLogDirectory();
            result = result * 59 + ($logDirectory == null ? 43 : $logDirectory.hashCode());
            return result;
        }

        public String toString() {
            return "WorkerConfig.ProcessContainerFactory(javaInstanceJarLocation=" + this.getJavaInstanceJarLocation() + ", pythonInstanceLocation=" + this.getPythonInstanceLocation() + ", logDirectory=" + this.getLogDirectory() + ")";
        }
    }

    public static class ThreadContainerFactory {
        private String threadGroupName;

        public ThreadContainerFactory setThreadGroupName(String threadGroupName) {
            this.threadGroupName = threadGroupName;
            return this;
        }

        public String getThreadGroupName() {
            return this.threadGroupName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadContainerFactory)) {
                return false;
            }
            ThreadContainerFactory other = (ThreadContainerFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$threadGroupName = this.getThreadGroupName();
            String other$threadGroupName = other.getThreadGroupName();
            return !(this$threadGroupName == null ? other$threadGroupName != null : !this$threadGroupName.equals(other$threadGroupName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadContainerFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $threadGroupName = this.getThreadGroupName();
            result = result * 59 + ($threadGroupName == null ? 43 : $threadGroupName.hashCode());
            return result;
        }

        public String toString() {
            return "WorkerConfig.ThreadContainerFactory(threadGroupName=" + this.getThreadGroupName() + ")";
        }
    }
}

