/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.Resources;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private final WorkerConfig workerConfig;
    private final WorkerService workerService;
    private static final String MATCH_ALL = "/*";
    private static final int NUM_ACCEPTORS = 16;
    private static final int MAX_CONCURRENT_REQUESTS = 1024;
    private final ExecutorService webServerExecutor;
    private Server server;

    private static String getErrorMessage(Server server, int port, Exception ex) {
        if (ex instanceof BindException) {
            URI uri = server.getURI();
            return String.format("%s http://%s:%d", ex.getMessage(), uri.getHost(), port);
        }
        return ex.getMessage();
    }

    public WorkerServer(WorkerService workerService) {
        this.workerConfig = workerService.getWorkerConfig();
        this.workerService = workerService;
        this.webServerExecutor = Executors.newFixedThreadPool(16, (ThreadFactory)new DefaultThreadFactory("function-web"));
        this.init();
    }

    public void start() throws Exception {
        this.server.start();
        log.info("Worker Server started at {}", (Object)this.server.getURI());
    }

    private void init() {
        this.server = new Server((ThreadPool)new ExecutorThreadPool(this.webServerExecutor));
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        ServerConnector connector = new ServerConnector(this.server, 1, 1);
        connector.setPort(this.workerConfig.getWorkerPort());
        connectors.add(connector);
        ArrayList<Object> handlers = new ArrayList<Object>(3);
        handlers.add(WorkerServer.newServletContextHandler("/admin", new ResourceConfig(Resources.getApiResources()), this.workerService));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v2", new ResourceConfig(Resources.getApiResources()), this.workerService));
        handlers.add(WorkerServer.newServletContextHandler("/", new ResourceConfig(Resources.getRootResources()), this.workerService));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setExtended(true);
        requestLog.setLogTimeZone(TimeZone.getDefault().getID());
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        handlers.add(0, new ContextHandlerCollection());
        handlers.add(requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.server.setHandler((Handler)handlerCollection);
        if (this.workerConfig.isTlsEnabled()) {
            try {
                SslContextFactory sslCtxFactory = SecurityUtility.createSslContextFactory((boolean)this.workerConfig.isTlsAllowInsecureConnection(), (String)this.workerConfig.getTlsTrustCertsFilePath(), (String)this.workerConfig.getTlsCertificateFilePath(), (String)this.workerConfig.getTlsKeyFilePath(), (boolean)this.workerConfig.isTlsRequireTrustedClientCertOnConnect());
                ServerConnector tlsConnector = new ServerConnector(this.server, 1, 1, sslCtxFactory);
                tlsConnector.setPort(this.workerConfig.getWorkerPortTls());
                connectors.add(tlsConnector);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        connectors.forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService) {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setAttribute("function-worker", (Object)workerService);
        contextHandler.setAttribute("worker", (Object)workerService);
        contextHandler.setAttribute("worker-stats", (Object)workerService);
        contextHandler.setContextPath(contextPath);
        ServletHolder apiServlet = new ServletHolder((Servlet)new ServletContainer(config));
        contextHandler.addServlet(apiServlet, MATCH_ALL);
        if (workerService.getWorkerConfig().isAuthenticationEnabled()) {
            FilterHolder filter = new FilterHolder((Filter)new AuthenticationFilter(workerService.getAuthenticationService()));
            contextHandler.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        return contextHandler;
    }

    @VisibleForTesting
    public void stop() {
        if (this.server != null) {
            try {
                this.server.destroy();
            }
            catch (Exception e) {
                log.error("Failed to stop function web-server ", (Throwable)e);
            }
        }
        if (this.webServerExecutor != null && !this.webServerExecutor.isShutdown()) {
            this.webServerExecutor.shutdown();
        }
    }
}

