/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/worker", description="Workers admin api", tags={"workers"})
public class WorkerApiV2Resource
implements Supplier<WorkerService> {
    private static final Logger log = LoggerFactory.getLogger(WorkerApiV2Resource.class);
    public static final String ATTRIBUTE_WORKER_SERVICE = "worker";
    protected final WorkerImpl worker = new WorkerImpl(this);
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKER_SERVICE);
        }
        return this.workerService;
    }

    public String clientAppId() {
        return this.httpRequest != null ? (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName) : null;
    }

    @GET
    @Path(value="/cluster")
    @ApiOperation(value="Fetches information about the Pulsar cluster running Pulsar Functions")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="WorkerApiV2Resource service is not running")})
    @Produces(value={"application/json"})
    public Response getCluster() {
        return this.worker.getCluster();
    }

    @GET
    @Path(value="/cluster/leader")
    @ApiOperation(value="Fetches info about the leader node of the Pulsar cluster running Pulsar Functions")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="WorkerApiV2Resource service is not running")})
    @Produces(value={"application/json"})
    public Response getClusterLeader() {
        return this.worker.getClusterLeader();
    }

    @GET
    @Path(value="/assignments")
    @ApiOperation(value="Fetches information about which Pulsar Functions are assigned to which Pulsar clusters", response=Function.Assignment.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="WorkerApiV2Resource service is not running")})
    public Response getAssignments() {
        return this.worker.getAssignments();
    }
}

