/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker-stats")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/worker-stats", description="Workers stats api", tags={"workers-stats"})
public class WorkerStatsApiV2Resource
implements Supplier<WorkerService> {
    private static final Logger log = LoggerFactory.getLogger(WorkerStatsApiV2Resource.class);
    public static final String ATTRIBUTE_WORKERSTATS_SERVICE = "worker-stats";
    protected final WorkerImpl worker = new WorkerImpl(this);
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKERSTATS_SERVICE);
        }
        return this.workerService;
    }

    public String clientAppId() {
        return this.httpRequest != null ? (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName) : null;
    }

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Request should be executed by Monitoring agent on each worker to fetch the worker-metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission")})
    public Collection<Metrics> getMetrics() throws Exception {
        return this.worker.getWorkerMetrcis(this.clientAppId());
    }

    @GET
    @Path(value="/functionsmetrics")
    @ApiOperation(value="Get metrics for all functions owned by worker", notes="Requested should be executed by Monitoring agent on each worker to fetch the metrics", response=InstanceCommunication.Metrics.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    public Response getFunctionsMetrics() throws IOException {
        return this.worker.getFunctionsMetrics(this.clientAppId());
    }
}

