/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.worker.FunctionsStatsGenerator;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;

@Path(value="/")
public class FunctionsMetricsResource
extends FunctionApiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="metrics")
    @GET
    @Produces(value={"text/plain"})
    public Response getMetrics() throws JsonProcessingException {
        WorkerService workerService = this.get();
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            FunctionsStatsGenerator.generate(workerService, "default", stream);
            byte[] payload = buf.array();
            int arrayOffset = buf.arrayOffset();
            int readableBytes = buf.readableBytes();
            StreamingOutput streamOut = out -> {
                out.write(payload, arrayOffset, readableBytes);
                out.flush();
            };
            Response response = Response.ok((Object)streamOut).type(MediaType.TEXT_PLAIN_TYPE).build();
            return response;
        }
        finally {
            buf.release();
        }
    }
}

