/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.utils.Utils;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.WorkerInfo;
import org.apache.pulsar.functions.worker.WorkerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final Supplier<WorkerService> workerServiceSupplier;

    public WorkerImpl(Supplier<WorkerService> workerServiceSupplier) {
        this.workerServiceSupplier = workerServiceSupplier;
    }

    private WorkerService worker() {
        try {
            return (WorkerService)Preconditions.checkNotNull((Object)this.workerServiceSupplier.get());
        }
        catch (Throwable t) {
            log.info("Failed to get worker service", t);
            throw t;
        }
    }

    private boolean isWorkerServiceAvailable() {
        WorkerService workerService = this.workerServiceSupplier.get();
        if (workerService == null) {
            return false;
        }
        return workerService.isInitialized();
    }

    public Response getCluster() {
        if (!this.isWorkerServiceAvailable()) {
            return this.getUnavailableResponse();
        }
        List<WorkerInfo> workers = this.worker().getMembershipManager().getCurrentMembership();
        String jsonString = new Gson().toJson(workers);
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)jsonString).build();
    }

    public Response getClusterLeader() {
        if (!this.isWorkerServiceAvailable()) {
            return this.getUnavailableResponse();
        }
        MembershipManager membershipManager = this.worker().getMembershipManager();
        WorkerInfo leader = membershipManager.getLeader();
        if (leader == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)new ErrorData("Leader cannot be determined")).build();
        }
        String jsonString = new Gson().toJson((Object)leader);
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)jsonString).build();
    }

    public Response getAssignments() {
        if (!this.isWorkerServiceAvailable()) {
            return this.getUnavailableResponse();
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        Map<String, Map<String, Function.Assignment>> assignments = functionRuntimeManager.getCurrentAssignments();
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, Function.Assignment>> entry : assignments.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().keySet());
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)new Gson().toJson(ret)).build();
    }

    private Response getUnavailableResponse() {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("application/json").entity((Object)new ErrorData("Function worker service is not done initializing. Please try again in a little while.")).build();
    }

    public boolean isSuperUser(String clientRole) {
        return clientRole != null && this.worker().getWorkerConfig().getSuperUserRoles().contains(clientRole);
    }

    public List<Metrics> getWorkerMetrcis(String clientRole) throws IOException {
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not admin and authorized to get function-stats", (Object)clientRole);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ErrorData(clientRole + " is not authorize to get metrics")).build());
        }
        return this.getWorkerMetrcis();
    }

    private List<Metrics> getWorkerMetrcis() {
        if (!this.isWorkerServiceAvailable()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("application/json").entity((Object)new ErrorData("Function worker service is not avaialable")).build());
        }
        return this.worker().getMetricsGenerator().generate();
    }

    public Response getFunctionsMetrics(String clientRole) throws IOException {
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not admin and authorized to get function-stats", (Object)clientRole);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ErrorData("client is not authorize to perform operation")).build();
        }
        return this.getFunctionsMetrics();
    }

    private Response getFunctionsMetrics() throws IOException {
        if (!this.isWorkerServiceAvailable()) {
            return this.getUnavailableResponse();
        }
        WorkerService workerService = this.worker();
        Map<String, FunctionRuntimeInfo> functionRuntimes = workerService.getFunctionRuntimeManager().getFunctionRuntimeInfos();
        InstanceCommunication.Metrics.Builder metricsBuilder = InstanceCommunication.Metrics.newBuilder();
        for (Map.Entry<String, FunctionRuntimeInfo> entry : functionRuntimes.entrySet()) {
            Runtime functionRuntime;
            String fullyQualifiedInstanceName = entry.getKey();
            FunctionRuntimeInfo functionRuntimeInfo = entry.getValue();
            RuntimeSpawner functionRuntimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
            if (functionRuntimeSpawner == null || (functionRuntime = functionRuntimeSpawner.getRuntime()) == null) continue;
            try {
                InstanceCommunication.MetricsData metricsData = workerService.getWorkerConfig().getMetricsSamplingPeriodSec() > 0 ? (InstanceCommunication.MetricsData)functionRuntime.getMetrics().get() : (InstanceCommunication.MetricsData)functionRuntime.getAndResetMetrics().get();
                String tenant = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getTenant();
                String namespace = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getNamespace();
                String name = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getName();
                int instanceId = functionRuntimeInfo.getFunctionInstance().getInstanceId();
                String qualifiedFunctionName = String.format("%s/%s/%s", tenant, namespace, name);
                InstanceCommunication.Metrics.InstanceMetrics.Builder instanceBuilder = InstanceCommunication.Metrics.InstanceMetrics.newBuilder();
                instanceBuilder.setName(qualifiedFunctionName);
                instanceBuilder.setInstanceId(instanceId);
                if (metricsData != null) {
                    instanceBuilder.setMetricsData(metricsData);
                }
                metricsBuilder.addMetrics(instanceBuilder.build());
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to collect metrics for function instance {}", (Object)fullyQualifiedInstanceName, (Object)e);
            }
        }
        String jsonResponse = Utils.printJson((MessageOrBuilder)metricsBuilder);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse).build();
    }
}

