/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/functions")
public class FunctionApiV2Resource
extends FunctionApiResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiV2Resource.class);

    @POST
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response registerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson, @FormDataParam(value="functionConfig") String functionConfigJson) {
        return this.functions.registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, functionConfigJson, this.clientAppId());
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response updateFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson, @FormDataParam(value="functionConfig") String functionConfigJson) {
        return this.functions.updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, functionConfigJson, this.clientAppId());
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response deregisterFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions.deregisterFunction(tenant, namespace, functionName, this.clientAppId());
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response getFunctionInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionInfo(tenant, namespace, functionName);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/status")
    public Response getFunctionInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions.getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, this.uri.getRequestUri());
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}/status")
    public Response getFunctionStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionStatus(tenant, namespace, functionName, this.uri.getRequestUri());
    }

    @GET
    @Path(value="/{tenant}/{namespace}")
    public Response listFunctions(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.functions.listFunctions(tenant, namespace);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{functionName}/trigger")
    @Consumes(value={"multipart/form-data"})
    public Response triggerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") String input, @FormDataParam(value="dataStream") InputStream uploadedInputStream, @FormDataParam(value="topic") String topic) {
        return this.functions.triggerFunction(tenant, namespace, functionName, input, uploadedInputStream, topic);
    }

    @POST
    @ApiOperation(value="Restart function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions.restartFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Restart all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions.restartFunctionInstances(tenant, namespace, functionName);
    }

    @POST
    @ApiOperation(value="Stop function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions.stopFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Stop all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions.stopFunctionInstances(tenant, namespace, functionName);
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public Response uploadFunction(@FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="path") String path) {
        return this.functions.uploadFunction(uploadedInputStream, path);
    }

    @GET
    @Path(value="/download")
    public Response downloadFunction(@QueryParam(value="path") String path) {
        return this.functions.downloadFunction(path);
    }

    @GET
    @Path(value="/connectors")
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.functions.getListOfConnectors();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    public Response getFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key) throws IOException {
        return this.functions.getFunctionState(tenant, namespace, functionName, key);
    }
}

