/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.AppendOnlyStreamWriter;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.dlog.DLInputStream;
import org.apache.pulsar.functions.worker.dlog.DLOutputStream;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static byte[] toByteArray(Object obj) throws IOException {
        byte[] bytes = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        return bytes;
    }

    public static String getUniquePackageName(String packageName) {
        return String.format("%s-%s", UUID.randomUUID().toString(), packageName);
    }

    public static void uploadFileToBookkeeper(String packagePath, File sourceFile, Namespace dlogNamespace) throws IOException {
        FileInputStream uploadedInputStream = new FileInputStream(sourceFile);
        Utils.uploadToBookeeper(dlogNamespace, uploadedInputStream, packagePath);
    }

    public static void uploadToBookeeper(Namespace dlogNamespace, InputStream uploadedInputStream, String destPkgPath) throws IOException {
        if (dlogNamespace.logExists(destPkgPath)) {
            log.info(String.format("Target function file already exists at '%s'. Overwriting it now", destPkgPath));
            dlogNamespace.deleteLog(destPkgPath);
        }
        log.info(String.format("Uploading function package to '%s'", destPkgPath));
        try (DistributedLogManager dlm = dlogNamespace.openLog(destPkgPath);
             AppendOnlyStreamWriter writer = dlm.getAppendOnlyStreamWriter();
             DLOutputStream out = new DLOutputStream(dlm, writer);){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            ((OutputStream)out).flush();
        }
    }

    public static void downloadFromHttpUrl(String destPkgUrl, FileOutputStream outputStream) throws IOException {
        URL website = new URL(destPkgUrl);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        outputStream.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    public static void downloadFromBookkeeper(Namespace namespace, File outputFile, String packagePath) throws IOException {
        Utils.downloadFromBookkeeper(namespace, new FileOutputStream(outputFile), packagePath);
    }

    public static void downloadFromBookkeeper(Namespace namespace, OutputStream outputStream, String packagePath) throws IOException {
        DistributedLogManager dlm = namespace.openLog(packagePath);
        try (DLInputStream in = new DLInputStream(dlm);){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.flush();
        }
    }

    public static DistributedLogConfiguration getDlogConf(WorkerConfig workerConfig) {
        int numReplicas = workerConfig.getNumFunctionPackageReplicas();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setWriteLockEnabled(false).setOutputBufferSize(262144).setPeriodicFlushFrequencyMilliSeconds(0).setImmediateFlushEnabled(false).setLogSegmentRollingIntervalMinutes(0).setMaxLogSegmentBytes(Long.MAX_VALUE).setExplicitTruncationByApplication(true).setRetentionPeriodHours(Integer.MAX_VALUE).setEnsembleSize(numReplicas).setWriteQuorumSize(numReplicas).setAckQuorumSize(numReplicas).setUseDaemonThread(true);
        conf.setProperty("bkc.allowShadedLedgerManagerFactoryClass", (Object)true);
        conf.setProperty("bkc.shadedLedgerManagerFactoryClassPrefix", (Object)"dlshade.");
        return conf;
    }

    public static URI initializeDlogNamespace(String zkServers, String ledgersRootPath) throws IOException {
        BKDLConfig dlConfig = new BKDLConfig(zkServers, ledgersRootPath);
        DLMetadata dlMetadata = DLMetadata.create((BKDLConfig)dlConfig);
        URI dlogUri = URI.create(String.format("distributedlog://%s/pulsar/functions", zkServers));
        try {
            dlMetadata.create(dlogUri);
        }
        catch (ZKException e) {
            if (e.getKeeperExceptionCode() == KeeperException.Code.NODEEXISTS) {
                return dlogUri;
            }
            throw e;
        }
        return dlogUri;
    }

    public static PulsarAdmin getPulsarAdminClient(String pulsarWebServiceUrl, String authPlugin, String authParams, String tlsTrustCertsFilePath, boolean allowTlsInsecureConnection) {
        try {
            PulsarAdminBuilder adminBuilder = PulsarAdmin.builder().serviceHttpUrl(pulsarWebServiceUrl);
            if (StringUtils.isNotBlank((CharSequence)authPlugin) && StringUtils.isNotBlank((CharSequence)authParams)) {
                adminBuilder.authentication(authPlugin, authParams);
            }
            if (StringUtils.isNotBlank((CharSequence)tlsTrustCertsFilePath)) {
                adminBuilder.tlsTrustCertsFilePath(tlsTrustCertsFilePath);
            }
            adminBuilder.allowTlsInsecureConnection(allowTlsInsecureConnection);
            return adminBuilder.build();
        }
        catch (PulsarClientException e) {
            log.error("Error creating pulsar admin client", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static FunctionStats.FunctionInstanceStats getFunctionInstanceStats(String fullyQualifiedInstanceName, FunctionRuntimeInfo functionRuntimeInfo, int instanceId) {
        Runtime functionRuntime;
        RuntimeSpawner functionRuntimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
        FunctionStats.FunctionInstanceStats functionInstanceStats = new FunctionStats.FunctionInstanceStats();
        if (functionRuntimeSpawner != null && (functionRuntime = functionRuntimeSpawner.getRuntime()) != null) {
            try {
                InstanceCommunication.MetricsData metricsData = (InstanceCommunication.MetricsData)functionRuntime.getMetrics(instanceId).get();
                functionInstanceStats.setInstanceId(instanceId);
                FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData functionInstanceStatsData = new FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData();
                functionInstanceStatsData.setReceivedTotal(metricsData.getReceivedTotal());
                functionInstanceStatsData.setProcessedSuccessfullyTotal(metricsData.getProcessedSuccessfullyTotal());
                functionInstanceStatsData.setSystemExceptionsTotal(metricsData.getSystemExceptionsTotal());
                functionInstanceStatsData.setUserExceptionsTotal(metricsData.getUserExceptionsTotal());
                functionInstanceStatsData.setAvgProcessLatency(metricsData.getAvgProcessLatency() == 0.0 ? null : Double.valueOf(metricsData.getAvgProcessLatency()));
                functionInstanceStatsData.setLastInvocation(metricsData.getLastInvocation() == 0L ? null : Long.valueOf(metricsData.getLastInvocation()));
                functionInstanceStatsData.oneMin.setReceivedTotal(metricsData.getReceivedTotal1Min());
                functionInstanceStatsData.oneMin.setProcessedSuccessfullyTotal(metricsData.getProcessedSuccessfullyTotal1Min());
                functionInstanceStatsData.oneMin.setSystemExceptionsTotal(metricsData.getSystemExceptionsTotal1Min());
                functionInstanceStatsData.oneMin.setUserExceptionsTotal(metricsData.getUserExceptionsTotal1Min());
                functionInstanceStatsData.oneMin.setAvgProcessLatency(metricsData.getAvgProcessLatency1Min() == 0.0 ? null : Double.valueOf(metricsData.getAvgProcessLatency1Min()));
                Map<String, Double> statsDataMap = metricsData.getUserMetricsMap().entrySet().stream().filter(stringDoubleEntry -> !((Double)stringDoubleEntry.getValue()).isNaN()).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (Double)x.getValue()));
                functionInstanceStatsData.setUserMetrics(statsDataMap);
                functionInstanceStats.setMetrics(functionInstanceStatsData);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to collect metrics for function instance {}", (Object)fullyQualifiedInstanceName, (Object)e);
            }
        }
        return functionInstanceStats;
    }
}

