/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.worker.Worker;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionWorkerStarter {
    private static final Logger log = LoggerFactory.getLogger(FunctionWorkerStarter.class);

    public static void main(String[] args) throws Exception {
        WorkerArguments workerArguments = new WorkerArguments();
        JCommander commander = new JCommander((Object)workerArguments);
        commander.setProgramName("FunctionWorkerStarter");
        commander.parse(args);
        if (workerArguments.help) {
            commander.usage();
            System.exit(-1);
            return;
        }
        WorkerConfig workerConfig = StringUtils.isBlank((CharSequence)workerArguments.configFile) ? new WorkerConfig() : WorkerConfig.load(workerArguments.configFile);
        Worker worker = new Worker(workerConfig);
        try {
            worker.start();
        }
        catch (Exception e) {
            log.error("Failed to start function worker", (Throwable)e);
            worker.stop();
            System.exit(-1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping function worker service ..");
            worker.stop();
        }));
    }

    private static class WorkerArguments {
        @Parameter(names={"-c", "--conf"}, description="Configuration File for Function Worker")
        private String configFile;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private WorkerArguments() {
        }
    }
}

