/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/worker", description="Workers admin api", tags={"workers"})
public class WorkerApiV2Resource
implements Supplier<WorkerService> {
    private static final Logger log = LoggerFactory.getLogger(WorkerApiV2Resource.class);
    public static final String ATTRIBUTE_WORKER_SERVICE = "worker";
    protected final WorkerImpl worker = new WorkerImpl(this);
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKER_SERVICE);
        }
        return this.workerService;
    }

    public String clientAppId() {
        return this.httpRequest != null ? (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName) : null;
    }

    @GET
    @ApiOperation(value="Fetches information about the Pulsar cluster running Pulsar Functions", response=WorkerInfo.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    public List<WorkerInfo> getCluster() {
        return this.worker.getCluster();
    }

    @GET
    @ApiOperation(value="Fetches info about the leader node of the Pulsar cluster running Pulsar Functions", response=WorkerInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/cluster/leader")
    @Produces(value={"application/json"})
    public WorkerInfo getClusterLeader() {
        return this.worker.getClusterLeader();
    }

    @GET
    @ApiOperation(value="Fetches information about which Pulsar Functions are assigned to which Pulsar clusters", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/assignments")
    @Produces(value={"application/json"})
    public Map<String, Collection<String>> getAssignments() {
        return this.worker.getAssignments();
    }
}

