/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v3;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/functions")
public class FunctionsApiV3Resource
extends FunctionApiResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionsApiV3Resource.class);
    protected final FunctionsImpl functions = new FunctionsImpl(this);

    @POST
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public void registerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionConfig") String functionConfigJson) {
        this.functions.registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfigJson, this.clientAppId(), this.clientAuthData());
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public void updateFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionConfig") String functionConfigJson, @FormDataParam(value="updateOptions") UpdateOptions updateOptions) {
        this.functions.updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfigJson, this.clientAppId(), this.clientAuthData(), updateOptions);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public void deregisterFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        this.functions.deregisterFunction(tenant, namespace, functionName, this.clientAppId(), this.clientAuthData());
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public FunctionConfig getFunctionInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions.getFunctionInfo(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function instance", response=FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/status")
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions.getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function", response=FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/status")
    public FunctionStatus getFunctionStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionStatus(tenant, namespace, functionName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the stats of a Pulsar Function", response=FunctionStats.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/stats")
    public FunctionStats getFunctionStats(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionStats(tenant, namespace, functionName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the stats of a Pulsar Function instance", response=FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stats")
    public FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData getFunctionInstanceStats(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions.getFunctionsInstanceStats(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{functionName}/trigger")
    @Consumes(value={"multipart/form-data"})
    public String triggerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") String input, @FormDataParam(value="dataStream") InputStream uploadedInputStream, @FormDataParam(value="topic") String topic) {
        return this.functions.triggerFunction(tenant, namespace, functionName, input, uploadedInputStream, topic, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        this.functions.restartFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/restart")
    @Consumes(value={"application/json"})
    public void restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        this.functions.restartFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        this.functions.stopFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/stop")
    @Consumes(value={"application/json"})
    public void stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        this.functions.stopFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        this.functions.startFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/start")
    @Consumes(value={"application/json"})
    public void startFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        this.functions.startFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public void uploadFunction(@FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="path") String path) {
        this.functions.uploadFunction(uploadedInputStream, path);
    }

    @GET
    @Path(value="/download")
    public StreamingOutput downloadFunction(@QueryParam(value="path") String path) {
        return this.functions.downloadFunction(path);
    }

    @GET
    @Path(value="/connectors")
    @Deprecated
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.functions.getListOfConnectors();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    public FunctionState getFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key) throws IOException {
        return this.functions.getFunctionState(tenant, namespace, functionName, key, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    @Consumes(value={"multipart/form-data"})
    public void putFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key, @FormDataParam(value="state") FunctionState stateJson) throws IOException {
        this.functions.putFunctionState(tenant, namespace, functionName, key, stateJson, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }
}

