/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.worker.ClusterServiceCoordinator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.MetricsGenerator;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerService {
    private static final Logger log = LoggerFactory.getLogger(WorkerService.class);
    private final WorkerConfig workerConfig;
    private PulsarClient client;
    private FunctionRuntimeManager functionRuntimeManager;
    private FunctionMetaDataManager functionMetaDataManager;
    private ClusterServiceCoordinator clusterServiceCoordinator;
    private Namespace dlogNamespace;
    private StorageAdminClient stateStoreAdminClient;
    private MembershipManager membershipManager;
    private SchedulerManager schedulerManager;
    private boolean isInitialized = false;
    private final ScheduledExecutorService statsUpdater;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private ConnectorsManager connectorsManager;
    private PulsarAdmin brokerAdmin;
    private PulsarAdmin functionAdmin;
    private final MetricsGenerator metricsGenerator;
    private final ScheduledExecutorService executor;
    @VisibleForTesting
    private URI dlogUri;

    public WorkerService(WorkerConfig workerConfig) {
        this.workerConfig = workerConfig;
        this.statsUpdater = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("worker-stats-updater"));
        this.executor = Executors.newScheduledThreadPool(10, (ThreadFactory)new DefaultThreadFactory("pulsar-worker"));
        this.metricsGenerator = new MetricsGenerator(this.statsUpdater, workerConfig);
    }

    public void start(URI dlogUri, AuthenticationService authenticationService, AuthorizationService authorizationService) throws InterruptedException {
        log.info("Starting worker {}...", (Object)this.workerConfig.getWorkerId());
        try {
            log.info("Worker Configs: {}", (Object)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.workerConfig));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to print worker configs with error {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            String functionWebServiceUrl;
            this.dlogUri = dlogUri;
            DistributedLogConfiguration dlogConf = WorkerUtils.getDlogConf(this.workerConfig);
            try {
                this.dlogNamespace = NamespaceBuilder.newBuilder().conf(dlogConf).clientId("function-worker-" + this.workerConfig.getWorkerId()).uri(this.dlogUri).build();
            }
            catch (Exception e) {
                log.error("Failed to initialize dlog namespace {} for storing function packages", (Object)dlogUri, (Object)e);
                throw new RuntimeException(e);
            }
            if (this.workerConfig.getStateStorageServiceUrl() != null) {
                StorageClientSettings clientSettings = StorageClientSettings.newBuilder().serviceUri(this.workerConfig.getStateStorageServiceUrl()).build();
                this.stateStoreAdminClient = StorageClientBuilder.newBuilder().withSettings(clientSettings).buildAdmin();
            }
            String string = functionWebServiceUrl = StringUtils.isNotBlank((CharSequence)this.workerConfig.getFunctionWebServiceUrl()) ? this.workerConfig.getFunctionWebServiceUrl() : this.workerConfig.getWorkerWebAddress();
            if (this.workerConfig.isAuthenticationEnabled()) {
                this.brokerAdmin = WorkerUtils.getPulsarAdminClient(this.workerConfig.getPulsarWebServiceUrl(), this.workerConfig.getClientAuthenticationPlugin(), this.workerConfig.getClientAuthenticationParameters(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsHostnameVerificationEnable());
                this.functionAdmin = WorkerUtils.getPulsarAdminClient(functionWebServiceUrl, this.workerConfig.getClientAuthenticationPlugin(), this.workerConfig.getClientAuthenticationParameters(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsHostnameVerificationEnable());
                this.client = WorkerUtils.getPulsarClient(this.workerConfig.getPulsarServiceUrl(), this.workerConfig.getClientAuthenticationPlugin(), this.workerConfig.getClientAuthenticationParameters(), this.workerConfig.isUseTls(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsHostnameVerificationEnable());
            } else {
                this.brokerAdmin = WorkerUtils.getPulsarAdminClient(this.workerConfig.getPulsarWebServiceUrl());
                this.functionAdmin = WorkerUtils.getPulsarAdminClient(functionWebServiceUrl);
                this.client = WorkerUtils.getPulsarClient(this.workerConfig.getPulsarServiceUrl());
            }
            log.info("Created Pulsar client");
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getFunctionAssignmentTopic());
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getClusterCoordinationTopic());
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getFunctionMetadataTopic());
            this.schedulerManager = new SchedulerManager(this.workerConfig, this.client, this.brokerAdmin, this.executor);
            this.functionMetaDataManager = new FunctionMetaDataManager(this.workerConfig, this.schedulerManager, this.client);
            this.connectorsManager = new ConnectorsManager(this.workerConfig);
            this.membershipManager = new MembershipManager(this, this.client, this.brokerAdmin);
            this.functionRuntimeManager = new FunctionRuntimeManager(this.workerConfig, this, this.dlogNamespace, this.membershipManager, this.connectorsManager, this.functionMetaDataManager);
            this.schedulerManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.schedulerManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.schedulerManager.setMembershipManager(this.membershipManager);
            this.functionMetaDataManager.initialize();
            this.functionRuntimeManager.initialize();
            this.authenticationService = authenticationService;
            this.authorizationService = authorizationService;
            log.info("Start cluster services...");
            this.clusterServiceCoordinator = new ClusterServiceCoordinator(this.workerConfig.getWorkerId(), this.membershipManager);
            this.clusterServiceCoordinator.addTask("membership-monitor", this.workerConfig.getFailureCheckFreqMs(), () -> this.membershipManager.checkFailures(this.functionMetaDataManager, this.functionRuntimeManager, this.schedulerManager));
            this.clusterServiceCoordinator.start();
            this.functionRuntimeManager.start();
            this.isInitialized = true;
        }
        catch (Throwable t) {
            log.error("Error Starting up in worker", t);
            throw new RuntimeException(t);
        }
    }

    public void stop() {
        if (null != this.functionMetaDataManager) {
            try {
                this.functionMetaDataManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function metadata manager", (Throwable)e);
            }
        }
        if (null != this.functionRuntimeManager) {
            try {
                this.functionRuntimeManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function runtime manager", (Throwable)e);
            }
        }
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close pulsar client", (Throwable)e);
            }
        }
        if (null != this.clusterServiceCoordinator) {
            this.clusterServiceCoordinator.close();
        }
        if (null != this.membershipManager) {
            try {
                this.membershipManager.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close membership manager", (Throwable)e);
            }
        }
        if (null != this.schedulerManager) {
            this.schedulerManager.close();
        }
        if (null != this.brokerAdmin) {
            this.brokerAdmin.close();
        }
        if (null != this.functionAdmin) {
            this.functionAdmin.close();
        }
        if (null != this.stateStoreAdminClient) {
            this.stateStoreAdminClient.close();
        }
        if (null != this.dlogNamespace) {
            this.dlogNamespace.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public WorkerConfig getWorkerConfig() {
        return this.workerConfig;
    }

    public PulsarClient getClient() {
        return this.client;
    }

    public FunctionRuntimeManager getFunctionRuntimeManager() {
        return this.functionRuntimeManager;
    }

    public FunctionMetaDataManager getFunctionMetaDataManager() {
        return this.functionMetaDataManager;
    }

    public ClusterServiceCoordinator getClusterServiceCoordinator() {
        return this.clusterServiceCoordinator;
    }

    public Namespace getDlogNamespace() {
        return this.dlogNamespace;
    }

    public StorageAdminClient getStateStoreAdminClient() {
        return this.stateStoreAdminClient;
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ScheduledExecutorService getStatsUpdater() {
        return this.statsUpdater;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ConnectorsManager getConnectorsManager() {
        return this.connectorsManager;
    }

    public PulsarAdmin getBrokerAdmin() {
        return this.brokerAdmin;
    }

    public PulsarAdmin getFunctionAdmin() {
        return this.functionAdmin;
    }

    public MetricsGenerator getMetricsGenerator() {
        return this.metricsGenerator;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public URI getDlogUri() {
        return this.dlogUri;
    }
}

