/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceCoordinator
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClusterServiceCoordinator.class);
    private final String workerId;
    private final Map<String, TimerTaskInfo> tasks = new HashMap<String, TimerTaskInfo>();
    private final ScheduledExecutorService executor;
    private final MembershipManager membershipManager;

    public ClusterServiceCoordinator(String workerId, MembershipManager membershipManager) {
        this.workerId = workerId;
        this.membershipManager = membershipManager;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("cluster-service-coordinator-timer").build());
    }

    public void addTask(String taskName, long interval, Runnable task) {
        this.tasks.put(taskName, new TimerTaskInfo(interval, task));
    }

    public void start() {
        for (Map.Entry<String, TimerTaskInfo> entry : this.tasks.entrySet()) {
            TimerTaskInfo timerTaskInfo = entry.getValue();
            String taskName = entry.getKey();
            this.executor.scheduleAtFixedRate(() -> {
                boolean isLeader = this.membershipManager.isLeader();
                if (isLeader) {
                    try {
                        timerTaskInfo.getTask().run();
                    }
                    catch (Exception e) {
                        log.error("Cluster timer task {} failed with exception.", (Object)taskName, (Object)e);
                    }
                }
            }, timerTaskInfo.getInterval(), timerTaskInfo.getInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() {
        log.info("Stopping Cluster Service Coordinator for worker {}", (Object)this.workerId);
        this.executor.shutdown();
        log.info("Stopped Cluster Service Coordinator for worker", (Object)this.workerId);
    }

    private static class TimerTaskInfo {
        private long interval;
        private Runnable task;

        public TimerTaskInfo(long interval, Runnable task) {
            this.interval = interval;
            this.task = task;
        }

        public long getInterval() {
            return this.interval;
        }

        public Runnable getTask() {
            return this.task;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void setTask(Runnable task) {
            this.task = task;
        }
    }
}

