/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssignmentTailer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionAssignmentTailer.class);
    private final FunctionRuntimeManager functionRuntimeManager;
    private final Reader<byte[]> reader;
    private volatile boolean isRunning = false;
    private final Thread tailerThread;

    public FunctionAssignmentTailer(FunctionRuntimeManager functionRuntimeManager, ReaderBuilder readerBuilder, WorkerConfig workerConfig, ErrorNotifier errorNotifier) throws PulsarClientException {
        this.functionRuntimeManager = functionRuntimeManager;
        this.reader = readerBuilder.subscriptionRolePrefix(workerConfig.getWorkerId() + "-function-runtime-manager").readerName(workerConfig.getWorkerId() + "-function-runtime-manager").topic(workerConfig.getFunctionAssignmentTopic()).readCompacted(true).startMessageId(MessageId.earliest).create();
        this.tailerThread = new Thread(() -> {
            while (this.isRunning) {
                try {
                    Message msg = this.reader.readNext();
                    this.processAssignment((Message<byte[]>)msg);
                }
                catch (Throwable th) {
                    if (this.isRunning) {
                        log.error("Encountered error in assignment tailer", th);
                        this.isRunning = false;
                        errorNotifier.triggerError(th);
                        continue;
                    }
                    if (th instanceof InterruptedException || th.getCause() instanceof InterruptedException) continue;
                    log.warn("Encountered error when assignment tailer is not running", th);
                }
            }
        });
        this.tailerThread.setName("assignment-tailer-thread");
    }

    public void start() {
        this.isRunning = true;
        this.tailerThread.start();
    }

    @Override
    public void close() {
        log.info("Stopping function assignment tailer");
        try {
            this.isRunning = false;
            if (this.tailerThread != null && this.tailerThread.isAlive()) {
                this.tailerThread.interrupt();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            log.error("Failed to stop function assignment tailer", (Throwable)e);
        }
        log.info("Stopped function assignment tailer");
    }

    public void processAssignment(Message<byte[]> msg) {
        if (msg.getData() == null || msg.getData().length == 0) {
            log.info("Received assignment delete: {}", (Object)msg.getKey());
            this.functionRuntimeManager.deleteAssignment(msg.getKey());
        } else {
            Function.Assignment assignment;
            try {
                assignment = Function.Assignment.parseFrom((byte[])msg.getData());
            }
            catch (IOException e) {
                log.error("[{}] Received bad assignment update at message {}", new Object[]{this.reader.getTopic(), msg.getMessageId(), e});
                throw new RuntimeException(e);
            }
            log.info("Received assignment update: {}", (Object)assignment);
            this.functionRuntimeManager.processAssignment(assignment);
        }
    }

    public Reader<byte[]> getReader() {
        return this.reader;
    }
}

