/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.functions.proto.Request;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetaDataTopicTailer
implements Consumer<Message<byte[]>>,
Function<Throwable, Void>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionMetaDataTopicTailer.class);
    private final FunctionMetaDataManager functionMetaDataManager;
    private final Reader<byte[]> reader;

    public FunctionMetaDataTopicTailer(FunctionMetaDataManager functionMetaDataManager, Reader<byte[]> reader) throws PulsarClientException {
        this.functionMetaDataManager = functionMetaDataManager;
        this.reader = reader;
    }

    public void start() {
        this.receiveOne();
    }

    private void receiveOne() {
        ((CompletableFuture)this.reader.readNextAsync().thenAccept((Consumer)this)).exceptionally((Function)this);
    }

    @Override
    public void close() {
        log.info("Stopping function metadata tailer");
        try {
            this.reader.close();
        }
        catch (IOException e) {
            log.error("Failed to stop function metadata tailer", (Throwable)e);
        }
        log.info("Stopped function function metadata tailer");
    }

    public void processRequest(Message<byte[]> msg) {
        Request.ServiceRequest serviceRequest;
        try {
            serviceRequest = Request.ServiceRequest.parseFrom((byte[])msg.getData());
        }
        catch (IOException e) {
            log.error("Received bad service request at message {}", (Object)msg.getMessageId(), (Object)e);
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Received Service Request: {}", (Object)serviceRequest);
        }
        this.functionMetaDataManager.processRequest(msg.getMessageId(), serviceRequest);
    }

    @Override
    public void accept(Message<byte[]> msg) {
        this.processRequest(msg);
        this.receiveOne();
    }

    @Override
    public Void apply(Throwable cause) {
        log.error("Failed to retrieve messages from function state topic", cause);
        throw new RuntimeException(cause);
    }
}

