/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.FunctionsImpl;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.utils.ComponentTypeUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.utils.FunctionMetaDataUtils;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentImpl {
    private static final Logger log = LoggerFactory.getLogger(ComponentImpl.class);
    private final AtomicReference<StorageClient> storageClient = new AtomicReference();
    protected final Supplier<WorkerService> workerServiceSupplier;
    protected final Function.FunctionDetails.ComponentType componentType;

    public ComponentImpl(Supplier<WorkerService> workerServiceSupplier, Function.FunctionDetails.ComponentType componentType) {
        this.workerServiceSupplier = workerServiceSupplier;
        this.componentType = componentType;
    }

    protected WorkerService worker() {
        try {
            return (WorkerService)Preconditions.checkNotNull((Object)this.workerServiceSupplier.get());
        }
        catch (Throwable t) {
            log.info("Failed to get worker service", t);
            throw t;
        }
    }

    boolean isWorkerServiceAvailable() {
        WorkerService workerService = this.workerServiceSupplier.get();
        if (workerService == null) {
            return false;
        }
        return workerService.isInitialized();
    }

    Function.PackageLocationMetaData.Builder getFunctionPackageLocation(Function.FunctionMetaData functionMetaData, String functionPkgUrl, FormDataContentDisposition fileDetail, File uploadedInputStreamAsFile) throws Exception {
        Function.FunctionDetails functionDetails = functionMetaData.getFunctionDetails();
        String tenant = functionDetails.getTenant();
        String namespace = functionDetails.getNamespace();
        String componentName = functionDetails.getName();
        Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder = Function.PackageLocationMetaData.newBuilder();
        boolean isBuiltin = WorkerUtils.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)functionDetails);
        boolean isPkgUrlProvided = StringUtils.isNotBlank((CharSequence)functionPkgUrl);
        if (this.worker().getFunctionRuntimeManager().getRuntimeFactory().externallyManaged()) {
            if (isBuiltin) {
                File sinkOrSource;
                if (this.componentType == Function.FunctionDetails.ComponentType.SOURCE) {
                    String archiveName = functionDetails.getSource().getBuiltin();
                    sinkOrSource = this.worker().getConnectorsManager().getSourceArchive(archiveName).toFile();
                } else {
                    String archiveName = functionDetails.getSink().getBuiltin();
                    sinkOrSource = this.worker().getConnectorsManager().getSinkArchive(archiveName).toFile();
                }
                packageLocationMetaDataBuilder.setPackagePath(ComponentImpl.createPackagePath(tenant, namespace, componentName, sinkOrSource.getName()));
                packageLocationMetaDataBuilder.setOriginalFileName(sinkOrSource.getName());
                log.info("Uploading {} package to {}", (Object)ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), (Object)packageLocationMetaDataBuilder.getPackagePath());
                WorkerUtils.uploadFileToBookkeeper(packageLocationMetaDataBuilder.getPackagePath(), sinkOrSource, this.worker().getDlogNamespace());
            } else if (isPkgUrlProvided) {
                packageLocationMetaDataBuilder.setPackagePath(ComponentImpl.createPackagePath(tenant, namespace, componentName, uploadedInputStreamAsFile.getName()));
                packageLocationMetaDataBuilder.setOriginalFileName(uploadedInputStreamAsFile.getName());
                log.info("Uploading {} package to {}", (Object)ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), (Object)packageLocationMetaDataBuilder.getPackagePath());
                WorkerUtils.uploadFileToBookkeeper(packageLocationMetaDataBuilder.getPackagePath(), uploadedInputStreamAsFile, this.worker().getDlogNamespace());
            } else if (functionMetaData.getPackageLocation().getPackagePath().startsWith("http") || functionMetaData.getPackageLocation().getPackagePath().startsWith("file")) {
                String fileName = new File(new URL(functionMetaData.getPackageLocation().getPackagePath()).toURI()).getName();
                packageLocationMetaDataBuilder.setPackagePath(ComponentImpl.createPackagePath(tenant, namespace, componentName, fileName));
                packageLocationMetaDataBuilder.setOriginalFileName(fileName);
                log.info("Uploading {} package to {}", (Object)ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), (Object)packageLocationMetaDataBuilder.getPackagePath());
                WorkerUtils.uploadFileToBookkeeper(packageLocationMetaDataBuilder.getPackagePath(), uploadedInputStreamAsFile, this.worker().getDlogNamespace());
            } else {
                packageLocationMetaDataBuilder.setPackagePath(ComponentImpl.createPackagePath(tenant, namespace, componentName, fileDetail.getFileName()));
                packageLocationMetaDataBuilder.setOriginalFileName(fileDetail.getFileName());
                log.info("Uploading {} package to {}", (Object)ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), (Object)packageLocationMetaDataBuilder.getPackagePath());
                WorkerUtils.uploadFileToBookkeeper(packageLocationMetaDataBuilder.getPackagePath(), uploadedInputStreamAsFile, this.worker().getDlogNamespace());
            }
        } else if (isBuiltin) {
            packageLocationMetaDataBuilder.setPackagePath("builtin://" + this.getFunctionCodeBuiltin(functionDetails));
        } else if (isPkgUrlProvided) {
            packageLocationMetaDataBuilder.setPackagePath(functionPkgUrl);
        } else if (functionMetaData.getPackageLocation().getPackagePath().startsWith("http") || functionMetaData.getPackageLocation().getPackagePath().startsWith("file")) {
            packageLocationMetaDataBuilder.setPackagePath(functionMetaData.getPackageLocation().getPackagePath());
        } else {
            packageLocationMetaDataBuilder.setPackagePath(ComponentImpl.createPackagePath(tenant, namespace, componentName, fileDetail.getFileName()));
            packageLocationMetaDataBuilder.setOriginalFileName(fileDetail.getFileName());
            log.info("Uploading {} package to {}", (Object)ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), (Object)packageLocationMetaDataBuilder.getPackagePath());
            WorkerUtils.uploadFileToBookkeeper(packageLocationMetaDataBuilder.getPackagePath(), uploadedInputStreamAsFile, this.worker().getDlogNamespace());
        }
        return packageLocationMetaDataBuilder;
    }

    public void deregisterFunction(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataHttps clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, (AuthenticationDataSource)clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to deregister {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        if (null != this.worker().getStateStoreAdminClient()) {
            String tableNs = FunctionCommon.getStateNamespace((String)tenant, (String)namespace);
            String tableName = componentName;
            try {
                FutureUtils.result((CompletableFuture)this.worker().getStateStoreAdminClient().deleteStream(tableNs, tableName));
            }
            catch (NamespaceNotFoundException | StreamNotFoundException throwable) {
            }
            catch (Exception e) {
                log.error("{}/{}/{} Failed to delete state table: {}", new Object[]{tenant, namespace, componentName, e.getMessage()});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        }
        try {
            this.validateDeregisterRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid deregister {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} to deregister does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData newVersionedMetaData = FunctionMetaDataUtils.incrMetadataVersion((Function.FunctionMetaData)functionMetaData, (Function.FunctionMetaData)functionMetaData);
        this.internalProcessFunctionRequest(newVersionedMetaData.getFunctionDetails().getTenant(), newVersionedMetaData.getFunctionDetails().getNamespace(), newVersionedMetaData.getFunctionDetails().getName(), newVersionedMetaData, true, String.format("Error deleting {} @ /{}/{}/{}", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName));
        String functionPackagePath = functionMetaData.getPackageLocation().getPackagePath();
        if (!(functionPackagePath.startsWith("http") || functionPackagePath.startsWith("file") || functionPackagePath.startsWith("builtin"))) {
            try {
                WorkerUtils.deleteFromBookkeeper(this.worker().getDlogNamespace(), functionMetaData.getPackageLocation().getPackagePath());
            }
            catch (IOException e) {
                log.error("{}/{}/{} Failed to cleanup package in BK with path {}", new Object[]{tenant, namespace, componentName, functionMetaData.getPackageLocation().getPackagePath(), e});
            }
        }
    }

    public FunctionConfig getFunctionInfo(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to get {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid get {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " %s doesn't exist", componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " %s doesn't exist", componentName));
        }
        FunctionConfig config = FunctionConfigUtils.convertFromDetails((Function.FunctionDetails)functionMetaData.getFunctionDetails());
        return config;
    }

    public void stopFunctionInstance(String tenant, String namespace, String componentName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        this.changeFunctionInstanceStatus(tenant, namespace, componentName, instanceId, false, uri, clientRole, clientAuthenticationDataHttps);
    }

    public void startFunctionInstance(String tenant, String namespace, String componentName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        this.changeFunctionInstanceStatus(tenant, namespace, componentName, instanceId, true, uri, clientRole, clientAuthenticationDataHttps);
    }

    public void changeFunctionInstanceStatus(String tenant, String namespace, String componentName, String instanceId, boolean start, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to start/stop {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionInstanceRequestParams(tenant, namespace, componentName, this.componentType, instanceId);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid start/stop {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        if (!FunctionMetaDataUtils.canChangeState((Function.FunctionMetaData)functionMetaData, (int)Integer.parseInt(instanceId), (Function.FunctionState)(start ? Function.FunctionState.RUNNING : Function.FunctionState.STOPPED))) {
            log.error("Operation not permitted on {}/{}/{}", new Object[]{tenant, namespace, componentName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Operation not permitted", new Object[0]));
        }
        Function.FunctionMetaData newFunctionMetaData = FunctionMetaDataUtils.changeFunctionInstanceStatus((Function.FunctionMetaData)functionMetaData, (Integer)Integer.parseInt(instanceId), (boolean)start);
        this.internalProcessFunctionRequest(tenant, namespace, componentName, newFunctionMetaData, false, String.format("Failed to start/stop {}: {}/{}/{}/{}", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, instanceId));
    }

    public void restartFunctionInstance(String tenant, String namespace, String componentName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to restart {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionInstanceRequestParams(tenant, namespace, componentName, this.componentType, instanceId);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid restart {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        try {
            functionRuntimeManager.restartFunctionInstance(tenant, namespace, componentName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("Failed to restart {}: {}/{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, instanceId, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public void stopFunctionInstances(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        this.changeFunctionStatusAllInstances(tenant, namespace, componentName, false, clientRole, clientAuthenticationDataHttps);
    }

    public void startFunctionInstances(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        this.changeFunctionStatusAllInstances(tenant, namespace, componentName, true, clientRole, clientAuthenticationDataHttps);
    }

    public void changeFunctionStatusAllInstances(String tenant, String namespace, String componentName, boolean start, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to start/stop {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid start/stop {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.warn("{} in stopFunctionInstances does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        if (!FunctionMetaDataUtils.canChangeState((Function.FunctionMetaData)functionMetaData, (int)-1, (Function.FunctionState)(start ? Function.FunctionState.RUNNING : Function.FunctionState.STOPPED))) {
            log.error("Operation not permitted on {}/{}/{}", new Object[]{tenant, namespace, componentName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Operation not permitted", new Object[0]));
        }
        Function.FunctionMetaData newFunctionMetaData = FunctionMetaDataUtils.changeFunctionInstanceStatus((Function.FunctionMetaData)functionMetaData, (Integer)-1, (boolean)start);
        this.internalProcessFunctionRequest(tenant, namespace, componentName, newFunctionMetaData, false, String.format("Failed to start/stop {}: {}/{}/{}", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName));
    }

    public void restartFunctionInstances(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to restart {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid restart {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.warn("{} in stopFunctionInstances does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        try {
            functionRuntimeManager.restartFunctionInstances(tenant, namespace, componentName);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("Failed to restart {}: {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public FunctionStats getFunctionStats(String tenant, String namespace, String componentName, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        FunctionStats functionStats;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to get stats for {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid get {} Stats request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.warn("{} in get {} Stats does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), this.componentType, tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        try {
            functionStats = functionRuntimeManager.getFunctionStats(tenant, namespace, componentName, uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Stats", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionStats;
    }

    public FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData getFunctionsInstanceStats(String tenant, String namespace, String componentName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData functionInstanceStatsData;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to get stats for {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionInstanceRequestParams(tenant, namespace, componentName, this.componentType, instanceId);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid get {} Stats request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.warn("{} in get {} Stats does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), this.componentType, tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        int instanceIdInt = Integer.parseInt(instanceId);
        if (instanceIdInt < 0 || instanceIdInt >= functionMetaData.getFunctionDetails().getParallelism()) {
            log.error("instanceId in get {} Stats out of bounds @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't have instance with id %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName, instanceId));
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        try {
            functionInstanceStatsData = functionRuntimeManager.getFunctionInstanceStats(tenant, namespace, componentName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Stats", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionInstanceStatsData;
    }

    public List<String> listFunctions(String tenant, String namespace, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{} Client [{}] is not authorized to list {}", new Object[]{tenant, namespace, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateListFunctionRequestParams(tenant, namespace);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid list {} request @ /{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        Collection<Function.FunctionMetaData> functionStateList = functionMetaDataManager.listFunctions(tenant, namespace);
        LinkedList<String> retVals = new LinkedList<String>();
        for (Function.FunctionMetaData functionMetaData : functionStateList) {
            if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) continue;
            retVals.add(functionMetaData.getFunctionDetails().getName());
        }
        return retVals;
    }

    void updateRequest(Function.FunctionMetaData existingFunctionMetaData, Function.FunctionMetaData functionMetaData) {
        Function.FunctionMetaData updatedVersionMetaData = FunctionMetaDataUtils.incrMetadataVersion((Function.FunctionMetaData)existingFunctionMetaData, (Function.FunctionMetaData)functionMetaData);
        this.internalProcessFunctionRequest(updatedVersionMetaData.getFunctionDetails().getTenant(), updatedVersionMetaData.getFunctionDetails().getNamespace(), updatedVersionMetaData.getFunctionDetails().getName(), updatedVersionMetaData, false, "Update Failed");
    }

    public List<ConnectorDefinition> getListOfConnectors() {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        return this.worker().getConnectorsManager().getConnectors();
    }

    public void reloadConnectors(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            throw new RestException(Response.Status.UNAUTHORIZED, "This operation requires super-user access");
        }
        try {
            this.worker().getConnectorsManager().reloadConnectors(this.worker().getWorkerConfig());
        }
        catch (IOException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String triggerFunction(String tenant, String namespace, String functionName, String input, InputStream uploadedInputStream, String topic, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        String inputTopicToWrite;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to trigger {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateTriggerRequestParams(tenant, namespace, functionName, topic, input, uploadedInputStream);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid trigger function request @ /{}/{}/{}", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, functionName)) {
            log.warn("Function in trigger function does not exist @ /{}/{}/{}", new Object[]{tenant, namespace, functionName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("Function %s doesn't exist", functionName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, functionName);
        if (topic != null) {
            inputTopicToWrite = topic;
        } else {
            if (functionMetaData.getFunctionDetails().getSource().getInputSpecsCount() != 1) {
                log.error("Function in trigger function has more than 1 input topics @ /{}/{}/{}", new Object[]{tenant, namespace, functionName});
                throw new RestException(Response.Status.BAD_REQUEST, "Function in trigger function has more than 1 input topics");
            }
            inputTopicToWrite = (String)functionMetaData.getFunctionDetails().getSource().getInputSpecsMap().keySet().iterator().next();
        }
        if (functionMetaData.getFunctionDetails().getSource().getInputSpecsCount() == 0 || !functionMetaData.getFunctionDetails().getSource().getInputSpecsMap().containsKey(inputTopicToWrite)) {
            log.error("Function in trigger function has unidentified topic @ /{}/{}/{} {}", new Object[]{tenant, namespace, functionName, inputTopicToWrite});
            throw new RestException(Response.Status.BAD_REQUEST, "Function in trigger function has unidentified topic");
        }
        try {
            this.worker().getBrokerAdmin().topics().getSubscriptions(inputTopicToWrite);
        }
        catch (PulsarAdminException e) {
            log.error("Function in trigger function is not ready @ /{}/{}/{}", new Object[]{tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, "Function in trigger function is not ready");
        }
        String outputTopic = functionMetaData.getFunctionDetails().getSink().getTopic();
        Reader reader = null;
        Producer producer = null;
        try {
            byte[] targetArray;
            if (outputTopic != null && !outputTopic.isEmpty()) {
                reader = this.worker().getClient().newReader().topic(outputTopic).startMessageId(MessageId.latest).readerName(this.worker().getWorkerConfig().getWorkerId() + "-trigger-" + FunctionCommon.getFullyQualifiedName((String)tenant, (String)namespace, (String)functionName)).create();
            }
            producer = this.worker().getClient().newProducer(Schema.AUTO_PRODUCE_BYTES()).topic(inputTopicToWrite).producerName(this.worker().getWorkerConfig().getWorkerId() + "-trigger-" + FunctionCommon.getFullyQualifiedName((String)tenant, (String)namespace, (String)functionName)).create();
            if (uploadedInputStream != null) {
                targetArray = new byte[uploadedInputStream.available()];
                uploadedInputStream.read(targetArray);
            } else {
                targetArray = input.getBytes();
            }
            MessageId msgId = producer.send((Object)targetArray);
            if (reader == null) {
                String string = null;
                return string;
            }
            long curTime = System.currentTimeMillis();
            long maxTime = curTime + 1000L;
            while (curTime < maxTime) {
                MessageId newMsgId;
                Message msg = reader.readNext(10000, TimeUnit.MILLISECONDS);
                if (msg == null) {
                    throw new RestException(Response.Status.REQUEST_TIMEOUT, "Request Timed Out");
                }
                if (msg.getProperties().containsKey("__pfn_input_msg_id__") && msg.getProperties().containsKey("__pfn_input_topic__") && msgId.equals(newMsgId = MessageId.fromByteArray((byte[])Base64.getDecoder().decode((String)msg.getProperties().get("__pfn_input_msg_id__")))) && msg.getProperties().get("__pfn_input_topic__").equals(TopicName.get((String)inputTopicToWrite).toString())) {
                    String string = new String(msg.getData());
                    return string;
                }
                curTime = System.currentTimeMillis();
            }
            throw new RestException(Response.Status.REQUEST_TIMEOUT, "Request Timed Out");
        }
        catch (SchemaSerializationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Failed to serialize input with error: %s. Please check if input data conforms with the schema of the input topic.", e.getMessage()));
        }
        catch (IOException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.closeAsync();
            }
            if (producer != null) {
                producer.closeAsync();
            }
        }
    }

    public FunctionState getFunctionState(String tenant, String namespace, String functionName, String key, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        FunctionState value;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to get state for {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        if (null == this.worker().getStateStoreAdminClient()) {
            this.throwStateStoreUnvailableResponse();
        }
        try {
            this.validateFunctionStateParams(tenant, namespace, functionName, key);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid getFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        String tableNs = FunctionCommon.getStateNamespace((String)tenant, (String)namespace);
        String tableName = functionName;
        String stateStorageServiceUrl = this.worker().getWorkerConfig().getStateStorageServiceUrl();
        if (this.storageClient.get() == null) {
            this.storageClient.compareAndSet(null, StorageClientBuilder.newBuilder().withSettings(StorageClientSettings.newBuilder().serviceUri(stateStorageServiceUrl).clientName("functions-admin").build()).withNamespace(tableNs).build());
        }
        try (Table table = (Table)FutureUtils.result((CompletableFuture)this.storageClient.get().openTable(tableName));
             KeyValue kv = (KeyValue)FutureUtils.result((CompletableFuture)table.getKv((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8))));){
            if (null == kv) {
                throw new RestException(Response.Status.NOT_FOUND, "key '" + key + "' doesn't exist.");
            }
            if (kv.isNumber()) {
                value = new FunctionState(key, null, null, Long.valueOf(kv.numberValue()), Long.valueOf(kv.version()));
            } else {
                try {
                    value = new FunctionState(key, new String(ByteBufUtil.getBytes((ByteBuf)((ByteBuf)kv.value()), (int)((ByteBuf)kv.value()).readerIndex(), (int)((ByteBuf)kv.value()).readableBytes()), StandardCharsets.UTF_8), null, null, Long.valueOf(kv.version()));
                }
                catch (Exception e) {
                    value = new FunctionState(key, null, ByteBufUtil.getBytes((ByteBuf)((ByteBuf)kv.value())), null, Long.valueOf(kv.version()));
                }
            }
        }
        catch (RestException e) {
            throw e;
        }
        catch (NamespaceNotFoundException | StreamNotFoundException e) {
            log.debug("State not found while processing getFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while getFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return value;
    }

    public void putFunctionState(String tenant, String namespace, String functionName, String key, FunctionState state, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (null == this.worker().getStateStoreAdminClient()) {
            this.throwStateStoreUnvailableResponse();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to put state for {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        if (!key.equals(state.getKey())) {
            log.error("{}/{}/{} Bad putFunction Request, path key doesn't match key in json", new Object[]{tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, "Path key doesn't match key in json");
        }
        if (state.getStringValue() == null && state.getByteValue() == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Setting Counter values not supported in put state");
        }
        try {
            this.validateFunctionStateParams(tenant, namespace, functionName, key);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid putFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        String tableNs = FunctionCommon.getStateNamespace((String)tenant, (String)namespace);
        String tableName = functionName;
        String stateStorageServiceUrl = this.worker().getWorkerConfig().getStateStorageServiceUrl();
        if (this.storageClient.get() == null) {
            this.storageClient.compareAndSet(null, StorageClientBuilder.newBuilder().withSettings(StorageClientSettings.newBuilder().serviceUri(stateStorageServiceUrl).clientName("functions-admin").build()).withNamespace(tableNs).build());
        }
        ByteBuf value = !StringUtils.isEmpty((CharSequence)state.getStringValue()) ? Unpooled.wrappedBuffer((byte[])state.getStringValue().getBytes()) : Unpooled.wrappedBuffer((byte[])state.getByteValue());
        try (Table table = (Table)FutureUtils.result((CompletableFuture)this.storageClient.get().openTable(tableName));){
            FutureUtils.result((CompletableFuture)table.put((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), (Object)value));
        }
        catch (NamespaceNotFoundException | StreamNotFoundException e) {
            log.debug("State not found while processing putFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while putFunctionState request @ /{}/{}/{}/{}", new Object[]{tenant, namespace, functionName, key, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public void uploadFunction(InputStream uploadedInputStream, String path, String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
        }
        try {
            if (uploadedInputStream == null || path == null) {
                throw new IllegalArgumentException("Function Package is not provided " + path);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid upload function request @ /{}", (Object)path, (Object)e);
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        try {
            log.info("Uploading function package to {}", (Object)path);
            WorkerUtils.uploadToBookeeper(this.worker().getDlogNamespace(), uploadedInputStream, path);
        }
        catch (IOException e) {
            log.error("Error uploading file {}", (Object)path, (Object)e);
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public StreamingOutput downloadFunction(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataHttps clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, (AuthenticationDataSource)clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not admin and authorized to download package for {} ", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        String pkgPath = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName).getPackageLocation().getPackagePath();
        StreamingOutput streamingOutput = output -> {
            if (pkgPath.startsWith("http")) {
                URL url = new URL(pkgPath);
                IOUtils.copy((InputStream)url.openStream(), (OutputStream)output);
            } else if (pkgPath.startsWith("file")) {
                URL url = new URL(pkgPath);
                try {
                    File file = new File(url.toURI());
                    IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)output);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("invalid file url path: " + pkgPath);
                }
            } else {
                WorkerUtils.downloadFromBookkeeper(this.worker().getDlogNamespace(), output, pkgPath);
            }
        };
        return streamingOutput;
    }

    public StreamingOutput downloadFunction(String path, String clientRole, AuthenticationDataHttps clientAuthenticationDataHttps) {
        block7: {
            if (!this.isWorkerServiceAvailable()) {
                RestUtils.throwUnavailableException();
            }
            if (this.worker().getWorkerConfig().isAuthorizationEnabled()) {
                String[] tokens = path.split("/");
                if (tokens.length == 4) {
                    String tenant = tokens[0];
                    String namespace = tokens[1];
                    String componentName = tokens[2];
                    try {
                        if (!this.isAuthorizedRole(tenant, namespace, clientRole, (AuthenticationDataSource)clientAuthenticationDataHttps)) {
                            log.warn("{}/{}/{} Client [{}] is not admin and authorized to download package for {} ", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                            throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
                        }
                        break block7;
                    }
                    catch (PulsarAdminException e) {
                        log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
                        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                    }
                }
                if (!this.isSuperUser(clientRole)) {
                    throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
                }
            }
        }
        StreamingOutput streamingOutput = output -> {
            if (path.startsWith("http")) {
                URL url = new URL(path);
                IOUtils.copy((InputStream)url.openStream(), (OutputStream)output);
            } else if (path.startsWith("file")) {
                URL url = new URL(path);
                try {
                    File file = new File(url.toURI());
                    IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)output);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("invalid file url path: " + path);
                }
            } else {
                WorkerUtils.downloadFromBookkeeper(this.worker().getDlogNamespace(), output, path);
            }
        };
        return streamingOutput;
    }

    private void validateListFunctionRequestParams(String tenant, String namespace) throws IllegalArgumentException {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant is not provided");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is not provided");
        }
    }

    protected void validateGetFunctionInstanceRequestParams(String tenant, String namespace, String componentName, Function.FunctionDetails.ComponentType componentType, String instanceId) throws IllegalArgumentException {
        this.validateGetFunctionRequestParams(tenant, namespace, componentName, componentType);
        if (instanceId == null) {
            throw new IllegalArgumentException(String.format("%s Instance Id is not provided", componentType));
        }
    }

    protected void validateGetFunctionRequestParams(String tenant, String namespace, String subject, Function.FunctionDetails.ComponentType componentType) throws IllegalArgumentException {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant is not provided");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is not provided");
        }
        if (subject == null) {
            throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)componentType) + " name is not provided");
        }
    }

    private void validateDeregisterRequestParams(String tenant, String namespace, String subject, Function.FunctionDetails.ComponentType componentType) throws IllegalArgumentException {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant is not provided");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is not provided");
        }
        if (subject == null) {
            throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)componentType) + " name is not provided");
        }
    }

    private void validateFunctionStateParams(String tenant, String namespace, String functionName, String key) throws IllegalArgumentException {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant is not provided");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is not provided");
        }
        if (functionName == null) {
            throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " name is not provided");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key is not provided");
        }
    }

    private String getFunctionCodeBuiltin(Function.FunctionDetails functionDetails) {
        Function.SinkSpec sinkSpec;
        Function.SourceSpec sourceSpec;
        if (functionDetails.hasSource() && !StringUtils.isEmpty((CharSequence)(sourceSpec = functionDetails.getSource()).getBuiltin())) {
            return sourceSpec.getBuiltin();
        }
        if (functionDetails.hasSink() && !StringUtils.isEmpty((CharSequence)(sinkSpec = functionDetails.getSink()).getBuiltin())) {
            return sinkSpec.getBuiltin();
        }
        return null;
    }

    private void validateTriggerRequestParams(String tenant, String namespace, String functionName, String topic, String input, InputStream uploadedInputStream) {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant is not provided");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is not provided");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Function name is not provided");
        }
        if (uploadedInputStream == null && input == null) {
            throw new IllegalArgumentException("Trigger Data is not provided");
        }
    }

    private void throwStateStoreUnvailableResponse() {
        throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "State storage client is not done initializing. Please try again in a little while.");
    }

    public static String createPackagePath(String tenant, String namespace, String functionName, String fileName) {
        return String.format("%s/%s/%s/%s", tenant, namespace, Codec.encode((String)functionName), FunctionCommon.getUniquePackageName((String)Codec.encode((String)fileName)));
    }

    public boolean isAuthorizedRole(String tenant, String namespace, String clientRole, AuthenticationDataSource authenticationData) throws PulsarAdminException {
        if (this.worker().getWorkerConfig().isAuthorizationEnabled()) {
            if (this.isSuperUser(clientRole)) {
                return true;
            }
            if (clientRole != null) {
                try {
                    TenantInfo tenantInfo = this.worker().getBrokerAdmin().tenants().getTenantInfo(tenant);
                    if (tenantInfo != null && ((Boolean)this.worker().getAuthorizationService().isTenantAdmin(tenant, clientRole, tenantInfo, authenticationData).get()).booleanValue()) {
                        return true;
                    }
                }
                catch (InterruptedException | ExecutionException | PulsarAdminException.NotFoundException throwable) {
                    // empty catch block
                }
            }
            if (clientRole != null && authenticationData != null) {
                return this.allowFunctionOps(NamespaceName.get((String)tenant, (String)namespace), clientRole, authenticationData);
            }
            return false;
        }
        return true;
    }

    protected void componentStatusRequestValidate(String tenant, String namespace, String componentName, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Function worker service is not done initializing. Please try again in a little while.");
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized get status for {}", new Object[]{tenant, namespace, componentName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid get {} Status request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.warn("{} in get {} Status does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), this.componentType, tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName));
        }
    }

    protected void componentInstanceStatusRequestValidate(String tenant, String namespace, String componentName, int instanceId, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        this.componentStatusRequestValidate(tenant, namespace, componentName, clientRole, clientAuthenticationDataHttps);
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        int parallelism = functionMetaData.getFunctionDetails().getParallelism();
        if (instanceId < 0 || instanceId >= parallelism) {
            log.error("instanceId in get {} Status out of bounds @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't have instance with id %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), componentName, instanceId));
        }
    }

    public boolean isSuperUser(String clientRole) {
        if (clientRole != null) {
            try {
                if (this.worker().getWorkerConfig().getSuperUserRoles() != null && this.worker().getWorkerConfig().getSuperUserRoles().contains(clientRole)) {
                    return true;
                }
                return (Boolean)this.worker().getAuthorizationService().isSuperUser(clientRole, null).get(this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Time-out {} sec while checking the role {} is a super user role ", (Object)this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), (Object)clientRole);
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            catch (Exception e) {
                log.warn("Admin-client with Role - failed to check the role {} is a super user role {} ", new Object[]{clientRole, e.getMessage(), e});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        }
        return false;
    }

    public boolean allowFunctionOps(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        try {
            switch (this.componentType) {
                case SINK: {
                    return (Boolean)this.worker().getAuthorizationService().allowSinkOpsAsync(namespaceName, role, authenticationData).get(this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
                }
                case SOURCE: {
                    return (Boolean)this.worker().getAuthorizationService().allowSourceOpsAsync(namespaceName, role, authenticationData).get(this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
                }
            }
            return (Boolean)this.worker().getAuthorizationService().allowFunctionOpsAsync(namespaceName, role, authenticationData).get(this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking function authorization on {} ", (Object)this.worker().getWorkerConfig().getZooKeeperOperationTimeoutSeconds(), (Object)namespaceName);
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.warn("Admin-client with Role - {} failed to get function permissions for namespace - {}. {}", new Object[]{role, namespaceName, e.getMessage(), e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private void internalProcessFunctionRequest(String tenant, String namespace, String functionName, Function.FunctionMetaData functionMetadata, boolean delete, String errorMsg) {
        try {
            if (this.worker().getLeaderService().isLeader()) {
                this.worker().getFunctionMetaDataManager().updateFunctionOnLeader(functionMetadata, delete);
            } else {
                FunctionsImpl functions = (FunctionsImpl)this.worker().getFunctionAdmin().functions();
                functions.updateOnWorkerLeader(tenant, namespace, functionName, functionMetadata.toByteArray(), delete);
            }
        }
        catch (PulsarAdminException e) {
            log.error(errorMsg, (Throwable)e);
            throw new RestException(e.getStatusCode(), e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    protected abstract class GetStatus<S, T> {
        protected GetStatus() {
        }

        public abstract T notScheduledInstance();

        public abstract T fromFunctionStatusProto(InstanceCommunication.FunctionStatus var1, String var2);

        public abstract T notRunning(String var1, String var2);

        public T getComponentInstanceStatus(String tenant, String namespace, String name, int instanceId, URI uri) {
            String workerId;
            Function.Assignment assignment = ComponentImpl.this.worker().getFunctionRuntimeManager().getRuntimeFactory().externallyManaged() ? ComponentImpl.this.worker().getFunctionRuntimeManager().findFunctionAssignment(tenant, namespace, name, -1) : ComponentImpl.this.worker().getFunctionRuntimeManager().findFunctionAssignment(tenant, namespace, name, instanceId);
            if (assignment == null) {
                return this.notScheduledInstance();
            }
            String assignedWorkerId = assignment.getWorkerId();
            if (assignedWorkerId.equals(workerId = ComponentImpl.this.worker().getWorkerConfig().getWorkerId())) {
                FunctionRuntimeInfo functionRuntimeInfo = ComponentImpl.this.worker().getFunctionRuntimeManager().getFunctionRuntimeInfo(FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)assignment.getInstance()));
                if (functionRuntimeInfo == null) {
                    return this.notRunning(assignedWorkerId, "");
                }
                RuntimeSpawner runtimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
                if (runtimeSpawner != null) {
                    try {
                        return this.fromFunctionStatusProto((InstanceCommunication.FunctionStatus)functionRuntimeInfo.getRuntimeSpawner().getFunctionStatus(instanceId).get(), assignedWorkerId);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                String message = functionRuntimeInfo.getStartupException() != null ? functionRuntimeInfo.getStartupException().getMessage() : "";
                return this.notRunning(assignedWorkerId, message);
            }
            List<WorkerInfo> workerInfoList = ComponentImpl.this.worker().getMembershipManager().getCurrentMembership();
            WorkerInfo workerInfo = null;
            for (WorkerInfo entry : workerInfoList) {
                if (!assignment.getWorkerId().equals(entry.getWorkerId())) continue;
                workerInfo = entry;
            }
            if (workerInfo == null) {
                return this.notScheduledInstance();
            }
            if (uri == null) {
                throw new WebApplicationException(Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build());
            }
            URI redirect = UriBuilder.fromUri((URI)uri).host(workerInfo.getWorkerHostname()).port(workerInfo.getPort()).build(new Object[0]);
            throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
        }

        public abstract S getStatus(String var1, String var2, String var3, Collection<Function.Assignment> var4, URI var5) throws PulsarAdminException;

        public abstract S getStatusExternal(String var1, String var2, String var3, int var4);

        public abstract S emptyStatus(int var1);

        public S getComponentStatus(String tenant, String namespace, String name, URI uri) {
            Function.FunctionMetaData functionMetaData = ComponentImpl.this.worker().getFunctionMetaDataManager().getFunctionMetaData(tenant, namespace, name);
            Collection<Function.Assignment> assignments = ComponentImpl.this.worker().getFunctionRuntimeManager().findFunctionAssignments(tenant, namespace, name);
            if (ComponentImpl.this.worker().getFunctionRuntimeManager().getRuntimeFactory().externallyManaged()) {
                Function.Assignment assignment = assignments.iterator().next();
                boolean isOwner = ComponentImpl.this.worker().getWorkerConfig().getWorkerId().equals(assignment.getWorkerId());
                if (isOwner) {
                    return this.getStatusExternal(tenant, namespace, name, functionMetaData.getFunctionDetails().getParallelism());
                }
                List<WorkerInfo> workerInfoList = ComponentImpl.this.worker().getMembershipManager().getCurrentMembership();
                WorkerInfo workerInfo = null;
                for (WorkerInfo entry : workerInfoList) {
                    if (!assignment.getWorkerId().equals(entry.getWorkerId())) continue;
                    workerInfo = entry;
                }
                if (workerInfo == null) {
                    return this.emptyStatus(functionMetaData.getFunctionDetails().getParallelism());
                }
                if (uri == null) {
                    throw new WebApplicationException(Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build());
                }
                URI redirect = UriBuilder.fromUri((URI)uri).host(workerInfo.getWorkerHostname()).port(workerInfo.getPort()).build(new Object[0]);
                throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
            }
            try {
                return this.getStatus(tenant, namespace, name, assignments, uri);
            }
            catch (PulsarAdminException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

