/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.pulsar.functions.worker.WorkerService;

@Path(value="/")
public class WorkerReadinessResource
implements Supplier<WorkerService> {
    public static final String ATTRIBUTE_WORKER_SERVICE = "worker";
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKER_SERVICE);
        }
        return this.workerService;
    }

    @GET
    @ApiOperation(value="Determines whether the worker service is initialized and ready for use", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/initialized")
    public boolean isInitialized() {
        if (!this.get().isInitialized()) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return true;
    }
}

