/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.WorkerServiceDefinition;
import org.apache.pulsar.functions.worker.service.WorkerServiceMetadata;
import org.apache.pulsar.functions.worker.service.WorkerServiceWithClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServiceLoader {
    private static final Logger log = LoggerFactory.getLogger(WorkerServiceLoader.class);
    static final String PULSAR_FN_WORKER_DEFINITION_FILE = "pulsar-functions-worker-service.yml";

    public static WorkerServiceDefinition getWorkerServiceDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).extractionDirectory(narExtractionDirectory).build();){
            WorkerServiceDefinition workerServiceDefinition = WorkerServiceLoader.getWorkerServiceDefinition(ncl);
            return workerServiceDefinition;
        }
    }

    private static WorkerServiceDefinition getWorkerServiceDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(PULSAR_FN_WORKER_DEFINITION_FILE);
        return (WorkerServiceDefinition)ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, WorkerServiceDefinition.class);
    }

    static WorkerServiceWithClassLoader load(WorkerServiceMetadata metadata, String narExtractionDirectory) throws IOException {
        File narFile = metadata.getArchivePath().toAbsolutePath().toFile();
        NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(narFile).parentClassLoader(WorkerService.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();
        WorkerServiceDefinition phDef = WorkerServiceLoader.getWorkerServiceDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)phDef.getHandlerClass())) {
            throw new IOException("Functions Worker Service Nar Package `" + phDef.getName() + "` does NOT provide a functions worker service implementation");
        }
        try {
            Class handlerClass = ncl.loadClass(phDef.getHandlerClass());
            Object handler = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(handler instanceof WorkerService)) {
                throw new IOException("Class " + phDef.getHandlerClass() + " does not implement worker service interface");
            }
            WorkerService ph = (WorkerService)handler;
            return new WorkerServiceWithClassLoader(ph, ncl);
        }
        catch (Throwable t) {
            WorkerServiceLoader.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    public static WorkerService load(WorkerConfig workerConfig) {
        return WorkerServiceLoader.load(workerConfig.getFunctionsWorkerServiceNarPackage(), workerConfig.getNarExtractionDirectory());
    }

    static WorkerService load(String wsNarPackage, String narExtractionDirectory) {
        WorkerServiceWithClassLoader service;
        WorkerServiceDefinition definition;
        if (StringUtils.isEmpty((CharSequence)wsNarPackage)) {
            return new PulsarWorkerService();
        }
        try {
            definition = WorkerServiceLoader.getWorkerServiceDefinition(wsNarPackage, narExtractionDirectory);
        }
        catch (IOException ioe) {
            log.error("Failed to get the worker service definition from {}", (Object)wsNarPackage, (Object)ioe);
            throw new RuntimeException("Failed to get the worker service definition from " + wsNarPackage, ioe);
        }
        WorkerServiceMetadata metadata = new WorkerServiceMetadata();
        Path narPath = Paths.get(wsNarPackage, new String[0]);
        metadata.setArchivePath(narPath);
        metadata.setDefinition(definition);
        try {
            service = WorkerServiceLoader.load(metadata, narExtractionDirectory);
        }
        catch (IOException e) {
            log.error("Failed to load the worker service {}", (Object)metadata, (Object)e);
            throw new RuntimeException("Failed to load the worker service " + String.valueOf(metadata), e);
        }
        log.info("Successfully loaded worker service {}", (Object)metadata);
        return service;
    }
}

