/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import io.opentelemetry.api.OpenTelemetry;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.util.DefaultPulsarSslFactory;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.Resources;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private final WorkerConfig workerConfig;
    private final WorkerService workerService;
    private final AuthenticationService authenticationService;
    private static final String MATCH_ALL = "/*";
    private final WebExecutorThreadPool webServerExecutor;
    private Server server;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;
    private final FilterInitializer filterInitializer;
    private PulsarSslFactory sslFactory;
    private ScheduledExecutorService scheduledExecutorService;

    public WorkerServer(WorkerService workerService, AuthenticationService authenticationService) {
        this.workerConfig = workerService.getWorkerConfig();
        this.workerService = workerService;
        this.authenticationService = authenticationService;
        this.webServerExecutor = new WebExecutorThreadPool(this.workerConfig.getNumHttpServerThreads(), "function-web", this.workerConfig.getHttpServerThreadPoolQueueSize());
        this.filterInitializer = new FilterInitializer(this.workerConfig, authenticationService);
        this.init();
    }

    public void start() throws Exception {
        this.server.start();
        log.info("Worker Server started at {}", (Object)this.server.getURI());
    }

    private void init() {
        this.server = new Server((ThreadPool)this.webServerExecutor);
        if (this.workerConfig.getMaxHttpServerConnections() > 0) {
            this.server.addBean((Object)new ConnectionLimit(this.workerConfig.getMaxHttpServerConnections(), this.server));
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (this.workerConfig.isWebServiceTrustXForwardedFor()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (this.workerConfig.getWorkerPort() != null) {
            log.info("Configuring http server on port={}", (Object)this.workerConfig.getWorkerPort());
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            if (this.workerConfig.isWebServiceHaProxyProtocolEnabled()) {
                connectionFactories.add(new ProxyConnectionFactory());
            }
            connectionFactories.add(httpConnectionFactory);
            this.httpConnector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
            this.httpConnector.setPort(this.workerConfig.getWorkerPort().intValue());
            connectors.add(this.httpConnector);
        }
        ArrayList<Object> handlers = new ArrayList<Object>(4);
        handlers.add(WorkerServer.newServletContextHandler("/admin", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v2", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v3", new ResourceConfig(Resources.getApiV3Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/", new ResourceConfig(Resources.getRootResources()), this.workerService, this.workerConfig.isAuthenticateMetricsEndpoint(), this.filterInitializer));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        boolean showDetailedAddresses = this.workerConfig.getWebServiceLogDetailedAddresses() != null ? this.workerConfig.getWebServiceLogDetailedAddresses() : this.workerConfig.isWebServiceHaProxyProtocolEnabled() || this.workerConfig.isWebServiceTrustXForwardedFor();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger((boolean)showDetailedAddresses, (Server)this.server));
        handlers.add(0, new ContextHandlerCollection());
        handlers.add(requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        handlers.add(stats);
        this.server.setHandler((Handler)stats);
        if (this.workerConfig.getTlsEnabled()) {
            log.info("Configuring https server on port={}", (Object)this.workerConfig.getWorkerPortTls());
            try {
                PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(this.workerConfig);
                this.sslFactory = new DefaultPulsarSslFactory();
                this.sslFactory.initialize(sslConfiguration);
                this.sslFactory.createInternalSslContext();
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("functions-worker-web-ssl-refresh"));
                this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshSslContext, this.workerConfig.getTlsCertRefreshCheckDurationSec(), this.workerConfig.getTlsCertRefreshCheckDurationSec(), TimeUnit.SECONDS);
                SslContextFactory.Server sslCtxFactory = JettySslContextFactory.createSslContextFactory((String)this.workerConfig.getTlsProvider(), (PulsarSslFactory)this.sslFactory, (boolean)this.workerConfig.isTlsRequireTrustedClientCertOnConnect(), (Set)this.workerConfig.getWebServiceTlsCiphers(), (Set)this.workerConfig.getWebServiceTlsProtocols());
                ArrayList<Object> connectionFactories = new ArrayList<Object>();
                if (this.workerConfig.isWebServiceHaProxyProtocolEnabled()) {
                    connectionFactories.add(new ProxyConnectionFactory());
                }
                connectionFactories.add(new SslConnectionFactory((SslContextFactory)sslCtxFactory, httpConnectionFactory.getProtocol()));
                connectionFactories.add(httpConnectionFactory);
                if (httpConfig.getCustomizer(SecureRequestCustomizer.class) == null) {
                    httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                }
                this.httpsConnector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
                this.httpsConnector.setPort(this.workerConfig.getWorkerPortTls().intValue());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.forEach(c -> c.setAcceptQueueSize(this.workerConfig.getHttpServerAcceptQueueSize()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, FilterInitializer filterInitializer) {
        return WorkerServer.newServletContextHandler(contextPath, config, workerService, true, filterInitializer);
    }

    static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, boolean requireAuthentication, FilterInitializer filterInitializer) {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setAttribute("function-worker", (Object)workerService);
        contextHandler.setAttribute("worker", (Object)workerService);
        contextHandler.setAttribute("worker-stats", (Object)workerService);
        contextHandler.setContextPath(contextPath);
        ServletHolder apiServlet = new ServletHolder((Servlet)new ServletContainer(config));
        contextHandler.addServlet(apiServlet, MATCH_ALL);
        filterInitializer.addFilters(contextHandler, requireAuthentication);
        return contextHandler;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                log.error("Failed to stop function web-server ", (Throwable)e);
            }
        }
        if (this.webServerExecutor != null && this.webServerExecutor.isRunning()) {
            try {
                this.webServerExecutor.stop();
            }
            catch (Exception e) {
                log.warn("Error stopping function web-server executor", (Throwable)e);
            }
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }

    protected PulsarSslConfiguration buildSslConfiguration(WorkerConfig config) {
        return PulsarSslConfiguration.builder().tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStore()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStore()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getWebServiceTlsCiphers()).tlsProtocols(config.getWebServiceTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(config.isTlsRequireTrustedClientCertOnConnect()).tlsEnabledWithKeystore(config.isTlsEnabledWithKeyStore()).serverMode(true).isHttps(true).build();
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(WorkerConfig config, AuthenticationService authenticationService) {
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder((Filter)new RateLimitingFilter(config.getHttpRequestsMaxPerSecond(), OpenTelemetry.noop().getMeter("org.apache.pulsar.function_worker"))));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder((Filter)new AuthenticationFilter(authenticationService));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WorkerServer.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }
    }
}

