/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.canal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class CanalSourceConfig
implements Serializable {
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Username to connect to mysql database")
    private String username;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Password to connect to mysql database")
    private String password;
    @FieldDoc(required=true, defaultValue="", help="Source destination that Canal source connector connects to")
    private String destination;
    @FieldDoc(required=false, defaultValue="", help="The mysql database hostname")
    private String singleHostname;
    @FieldDoc(required=false, defaultValue="", help="The mysql database port")
    private int singlePort;
    @FieldDoc(required=true, defaultValue="false", help="If setting to true, it will be talking to `zkServers` to figure out the actual database hosts. If setting to false, it will connect to the database specified by `singleHostname` and `singlePort`.")
    private Boolean cluster = false;
    @FieldDoc(required=true, defaultValue="", help="The zookeeper servers that canal source connector talks to figure out the actual database hosts")
    private String zkServers;
    @FieldDoc(required=false, defaultValue="1000", help="The batch size to fetch from canal.")
    private int batchSize = 1000;

    public static CanalSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CanalSourceConfig)mapper.readValue(new File(yamlFile), CanalSourceConfig.class);
    }

    public static CanalSourceConfig load(Map<String, Object> map, SourceContext sourceContext) throws IOException {
        return (CanalSourceConfig)IOConfigUtils.loadWithSecrets(map, CanalSourceConfig.class, (SourceContext)sourceContext);
    }

    @Generated
    public CanalSourceConfig() {
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getSingleHostname() {
        return this.singleHostname;
    }

    @Generated
    public int getSinglePort() {
        return this.singlePort;
    }

    @Generated
    public Boolean getCluster() {
        return this.cluster;
    }

    @Generated
    public String getZkServers() {
        return this.zkServers;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public CanalSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public CanalSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public CanalSourceConfig setDestination(String destination) {
        this.destination = destination;
        return this;
    }

    @Generated
    public CanalSourceConfig setSingleHostname(String singleHostname) {
        this.singleHostname = singleHostname;
        return this;
    }

    @Generated
    public CanalSourceConfig setSinglePort(int singlePort) {
        this.singlePort = singlePort;
        return this;
    }

    @Generated
    public CanalSourceConfig setCluster(Boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    @Generated
    public CanalSourceConfig setZkServers(String zkServers) {
        this.zkServers = zkServers;
        return this;
    }

    @Generated
    public CanalSourceConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanalSourceConfig)) {
            return false;
        }
        CanalSourceConfig other = (CanalSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSinglePort() != other.getSinglePort()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        Boolean this$cluster = this.getCluster();
        Boolean other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$singleHostname = this.getSingleHostname();
        String other$singleHostname = other.getSingleHostname();
        if (this$singleHostname == null ? other$singleHostname != null : !this$singleHostname.equals(other$singleHostname)) {
            return false;
        }
        String this$zkServers = this.getZkServers();
        String other$zkServers = other.getZkServers();
        return !(this$zkServers == null ? other$zkServers != null : !this$zkServers.equals(other$zkServers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CanalSourceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSinglePort();
        result = result * 59 + this.getBatchSize();
        Boolean $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $singleHostname = this.getSingleHostname();
        result = result * 59 + ($singleHostname == null ? 43 : $singleHostname.hashCode());
        String $zkServers = this.getZkServers();
        result = result * 59 + ($zkServers == null ? 43 : $zkServers.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CanalSourceConfig(username=" + this.getUsername() + ", password=" + this.getPassword() + ", destination=" + this.getDestination() + ", singleHostname=" + this.getSingleHostname() + ", singlePort=" + this.getSinglePort() + ", cluster=" + this.getCluster() + ", zkServers=" + this.getZkServers() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

