/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.debezium;

import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.debezium.PulsarDatabaseHistory;
import org.apache.pulsar.io.debezium.SerDeUtils;
import org.apache.pulsar.io.kafka.connect.KafkaConnectSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DebeziumSource
extends KafkaConnectSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebeziumSource.class);
    private static final String DEFAULT_CONVERTER = "org.apache.kafka.connect.json.JsonConverter";
    private static final String DEFAULT_HISTORY = "org.apache.pulsar.io.debezium.PulsarDatabaseHistory";
    private static final String DEFAULT_OFFSET_TOPIC = "debezium-offset-topic";
    private static final String DEFAULT_HISTORY_TOPIC = "debezium-history-topic";

    public static void throwExceptionIfConfigNotMatch(Map<String, Object> config, String key, String value) throws IllegalArgumentException {
        Object orig = config.get(key);
        if (orig == null) {
            config.put(key, value);
            return;
        }
        if (!orig.equals(value)) {
            throw new IllegalArgumentException("Expected " + value + " but has " + orig);
        }
    }

    public static void setConfigIfNull(Map<String, Object> config, String key, String value) {
        config.putIfAbsent(key, value);
    }

    public static String topicNamespace(SourceContext sourceContext) {
        String tenant = sourceContext.getTenant();
        String namespace = sourceContext.getNamespace();
        return (StringUtils.isEmpty((CharSequence)tenant) ? "public" : tenant) + "/" + (StringUtils.isEmpty((CharSequence)namespace) ? "default" : namespace);
    }

    public static void tryLoadingConfigSecret(String secretName, Map<String, Object> config, SourceContext context) {
        try {
            String secret = context.getSecret(secretName);
            if (secret != null) {
                config.put(secretName, secret);
                log.info("Config key {} set from secret.", (Object)secretName);
            }
        }
        catch (Exception e) {
            log.warn("Failed to read secret {}.", (Object)secretName, (Object)e);
        }
    }

    public abstract void setDbConnectorTask(Map<String, Object> var1) throws Exception;

    public void open(Map<String, Object> config, SourceContext sourceContext) throws Exception {
        this.setDbConnectorTask(config);
        DebeziumSource.tryLoadingConfigSecret("database.user", config, sourceContext);
        DebeziumSource.tryLoadingConfigSecret("database.password", config, sourceContext);
        DebeziumSource.setConfigIfNull(config, "key.converter", DEFAULT_CONVERTER);
        DebeziumSource.setConfigIfNull(config, "value.converter", DEFAULT_CONVERTER);
        DebeziumSource.setConfigIfNull(config, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY.name(), DEFAULT_HISTORY);
        String pulsarUrl = (String)config.get(PulsarDatabaseHistory.SERVICE_URL.name());
        String topicNamespace = DebeziumSource.topicNamespace(sourceContext);
        DebeziumSource.setConfigIfNull(config, "topic.namespace", topicNamespace);
        String sourceName = sourceContext.getSourceName();
        DebeziumSource.setConfigIfNull(config, PulsarDatabaseHistory.TOPIC.name(), topicNamespace + "/" + sourceName + "-debezium-history-topic");
        DebeziumSource.setConfigIfNull(config, "offset.storage.topic", topicNamespace + "/" + sourceName + "-debezium-offset-topic");
        if (StringUtils.isEmpty((CharSequence)pulsarUrl)) {
            String pulsarClientBuilder = SerDeUtils.serialize(sourceContext.getPulsarClientBuilder());
            config.put(PulsarDatabaseHistory.CLIENT_BUILDER.name(), pulsarClientBuilder);
        }
        super.open(config, sourceContext);
    }
}

