/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.dynamodb;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.io.aws.AwsCredentialProviderPlugin;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import software.amazon.awssdk.regions.Region;

public class DynamoDBSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", help="Dynamodb streams end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String awsEndpoint = "";
    @FieldDoc(required=false, defaultValue="", help="Appropriate aws region. E.g. us-west-1, us-west-2")
    private String awsRegion = "";
    @FieldDoc(required=true, defaultValue="", help="Dynamodb stream arn")
    private String awsDynamodbStreamArn = "";
    @FieldDoc(required=false, defaultValue="", help="Fully-Qualified class name of implementation of AwsCredentialProviderPlugin. It is a factory class which creates an AWSCredentialsProvider that will be used by dynamodb. If it is empty then dynamodb will create a default AWSCredentialsProvider which accepts json-map of credentials in `awsCredentialPluginParam`")
    private String awsCredentialPluginName = "";
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="json-parameters to initialize `AwsCredentialsProviderPlugin`")
    private String awsCredentialPluginParam = "";
    @FieldDoc(required=false, defaultValue="LATEST", help="Used to specify the position in the stream where the connector should start from.\n  #\n  # The available options are: \n  #\n  # - AT_TIMESTAMP \n  #\n  #   Start from the record at or after the specified timestamp. \n  #\n  # - LATEST \n  #\n  #   Start after the most recent data record (fetch new data). \n  #\n  # - TRIM_HORIZON \n  #\n  #   Start from the oldest available data record. \n")
    private InitialPositionInStream initialPositionInStream = InitialPositionInStream.LATEST;
    @FieldDoc(required=false, defaultValue="", help="If the initalPositionInStream is set to 'AT_TIMESTAMP', then this  property specifies the point in time to start consumption.")
    private Date startAtTime;
    @FieldDoc(required=false, defaultValue="Apache Pulsar IO Connector", help="Name of the dynamodb consumer application. By default the application name is included in the user agent string used to make AWS requests. This can assist with troubleshooting (e.g. distinguish requests made by separate connectors instances).")
    private String applicationName = "pulsar-dynamodb";
    @FieldDoc(required=false, defaultValue="60000", help="The frequency of the stream checkpointing (in milliseconds)")
    private long checkpointInterval = 60000L;
    @FieldDoc(required=false, defaultValue="3000", help="The amount of time to delay between requests when the connector encounters a Throttlingexception from dynamodb (in milliseconds)")
    private long backoffTime = 3000L;
    @FieldDoc(required=false, defaultValue="3", help="The number of re-attempts to make when the connector encounters an exception while trying to set a checkpoint")
    private int numRetries = 3;
    @FieldDoc(required=false, defaultValue="1000", help="The maximum number of AWS Records that can be buffered inside the connector. Once this is reached, the connector will not consume any more messages from Kinesis until some of the messages in the queue have been successfully consumed.")
    private int receiveQueueSize = 1000;
    @FieldDoc(required=false, defaultValue="", help="Dynamo end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String dynamoEndpoint = "";
    @FieldDoc(required=false, defaultValue="", help="Cloudwatch end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String cloudwatchEndpoint = "";

    public static DynamoDBSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (DynamoDBSourceConfig)mapper.readValue(new File(yamlFile), DynamoDBSourceConfig.class);
    }

    public static DynamoDBSourceConfig load(Map<String, Object> map, SourceContext sourceContext) throws IOException {
        return (DynamoDBSourceConfig)IOConfigUtils.loadWithSecrets(map, DynamoDBSourceConfig.class, (SourceContext)sourceContext);
    }

    protected Region regionAsV2Region() {
        return Region.of((String)this.getAwsRegion());
    }

    public AmazonDynamoDBStreams buildDynamoDBStreamsClient(AwsCredentialProviderPlugin credPlugin) {
        AmazonDynamoDBStreamsClientBuilder builder = AmazonDynamoDBStreamsClientBuilder.standard();
        if (!this.getAwsEndpoint().isEmpty()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getAwsEndpoint(), this.getAwsRegion()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.setRegion(this.getAwsRegion());
        }
        builder.setCredentials(credPlugin.getCredentialProvider());
        return (AmazonDynamoDBStreams)builder.build();
    }

    public AmazonDynamoDB buildDynamoDBClient(AwsCredentialProviderPlugin credPlugin) {
        AmazonDynamoDBClientBuilder builder = AmazonDynamoDBClientBuilder.standard();
        if (!this.getAwsEndpoint().isEmpty()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getDynamoEndpoint(), this.getAwsRegion()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.setRegion(this.getAwsRegion());
        }
        builder.setCredentials(credPlugin.getCredentialProvider());
        return (AmazonDynamoDB)builder.build();
    }

    public AmazonCloudWatch buildCloudwatchClient(AwsCredentialProviderPlugin credPlugin) {
        AmazonCloudWatchClientBuilder builder = AmazonCloudWatchClientBuilder.standard();
        if (!this.getAwsEndpoint().isEmpty()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getCloudwatchEndpoint(), this.getAwsRegion()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.setRegion(this.getAwsRegion());
        }
        builder.setCredentials(credPlugin.getCredentialProvider());
        return (AmazonCloudWatch)builder.build();
    }

    @Generated
    public DynamoDBSourceConfig() {
    }

    @Generated
    public String getAwsEndpoint() {
        return this.awsEndpoint;
    }

    @Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Generated
    public String getAwsDynamodbStreamArn() {
        return this.awsDynamodbStreamArn;
    }

    @Generated
    public String getAwsCredentialPluginName() {
        return this.awsCredentialPluginName;
    }

    @Generated
    public String getAwsCredentialPluginParam() {
        return this.awsCredentialPluginParam;
    }

    @Generated
    public InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    @Generated
    public Date getStartAtTime() {
        return this.startAtTime;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    @Generated
    public long getBackoffTime() {
        return this.backoffTime;
    }

    @Generated
    public int getNumRetries() {
        return this.numRetries;
    }

    @Generated
    public int getReceiveQueueSize() {
        return this.receiveQueueSize;
    }

    @Generated
    public String getDynamoEndpoint() {
        return this.dynamoEndpoint;
    }

    @Generated
    public String getCloudwatchEndpoint() {
        return this.cloudwatchEndpoint;
    }

    @Generated
    public void setAwsEndpoint(String awsEndpoint) {
        this.awsEndpoint = awsEndpoint;
    }

    @Generated
    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    @Generated
    public void setAwsDynamodbStreamArn(String awsDynamodbStreamArn) {
        this.awsDynamodbStreamArn = awsDynamodbStreamArn;
    }

    @Generated
    public void setAwsCredentialPluginName(String awsCredentialPluginName) {
        this.awsCredentialPluginName = awsCredentialPluginName;
    }

    @Generated
    public void setAwsCredentialPluginParam(String awsCredentialPluginParam) {
        this.awsCredentialPluginParam = awsCredentialPluginParam;
    }

    @Generated
    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
    }

    @Generated
    public void setStartAtTime(Date startAtTime) {
        this.startAtTime = startAtTime;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    @Generated
    public void setBackoffTime(long backoffTime) {
        this.backoffTime = backoffTime;
    }

    @Generated
    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    @Generated
    public void setReceiveQueueSize(int receiveQueueSize) {
        this.receiveQueueSize = receiveQueueSize;
    }

    @Generated
    public void setDynamoEndpoint(String dynamoEndpoint) {
        this.dynamoEndpoint = dynamoEndpoint;
    }

    @Generated
    public void setCloudwatchEndpoint(String cloudwatchEndpoint) {
        this.cloudwatchEndpoint = cloudwatchEndpoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBSourceConfig)) {
            return false;
        }
        DynamoDBSourceConfig other = (DynamoDBSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCheckpointInterval() != other.getCheckpointInterval()) {
            return false;
        }
        if (this.getBackoffTime() != other.getBackoffTime()) {
            return false;
        }
        if (this.getNumRetries() != other.getNumRetries()) {
            return false;
        }
        if (this.getReceiveQueueSize() != other.getReceiveQueueSize()) {
            return false;
        }
        String this$awsEndpoint = this.getAwsEndpoint();
        String other$awsEndpoint = other.getAwsEndpoint();
        if (this$awsEndpoint == null ? other$awsEndpoint != null : !this$awsEndpoint.equals(other$awsEndpoint)) {
            return false;
        }
        String this$awsRegion = this.getAwsRegion();
        String other$awsRegion = other.getAwsRegion();
        if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) {
            return false;
        }
        String this$awsDynamodbStreamArn = this.getAwsDynamodbStreamArn();
        String other$awsDynamodbStreamArn = other.getAwsDynamodbStreamArn();
        if (this$awsDynamodbStreamArn == null ? other$awsDynamodbStreamArn != null : !this$awsDynamodbStreamArn.equals(other$awsDynamodbStreamArn)) {
            return false;
        }
        String this$awsCredentialPluginName = this.getAwsCredentialPluginName();
        String other$awsCredentialPluginName = other.getAwsCredentialPluginName();
        if (this$awsCredentialPluginName == null ? other$awsCredentialPluginName != null : !this$awsCredentialPluginName.equals(other$awsCredentialPluginName)) {
            return false;
        }
        String this$awsCredentialPluginParam = this.getAwsCredentialPluginParam();
        String other$awsCredentialPluginParam = other.getAwsCredentialPluginParam();
        if (this$awsCredentialPluginParam == null ? other$awsCredentialPluginParam != null : !this$awsCredentialPluginParam.equals(other$awsCredentialPluginParam)) {
            return false;
        }
        InitialPositionInStream this$initialPositionInStream = this.getInitialPositionInStream();
        InitialPositionInStream other$initialPositionInStream = other.getInitialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        Date this$startAtTime = this.getStartAtTime();
        Date other$startAtTime = other.getStartAtTime();
        if (this$startAtTime == null ? other$startAtTime != null : !((Object)this$startAtTime).equals(other$startAtTime)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$dynamoEndpoint = this.getDynamoEndpoint();
        String other$dynamoEndpoint = other.getDynamoEndpoint();
        if (this$dynamoEndpoint == null ? other$dynamoEndpoint != null : !this$dynamoEndpoint.equals(other$dynamoEndpoint)) {
            return false;
        }
        String this$cloudwatchEndpoint = this.getCloudwatchEndpoint();
        String other$cloudwatchEndpoint = other.getCloudwatchEndpoint();
        return !(this$cloudwatchEndpoint == null ? other$cloudwatchEndpoint != null : !this$cloudwatchEndpoint.equals(other$cloudwatchEndpoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBSourceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $checkpointInterval = this.getCheckpointInterval();
        result = result * 59 + (int)($checkpointInterval >>> 32 ^ $checkpointInterval);
        long $backoffTime = this.getBackoffTime();
        result = result * 59 + (int)($backoffTime >>> 32 ^ $backoffTime);
        result = result * 59 + this.getNumRetries();
        result = result * 59 + this.getReceiveQueueSize();
        String $awsEndpoint = this.getAwsEndpoint();
        result = result * 59 + ($awsEndpoint == null ? 43 : $awsEndpoint.hashCode());
        String $awsRegion = this.getAwsRegion();
        result = result * 59 + ($awsRegion == null ? 43 : $awsRegion.hashCode());
        String $awsDynamodbStreamArn = this.getAwsDynamodbStreamArn();
        result = result * 59 + ($awsDynamodbStreamArn == null ? 43 : $awsDynamodbStreamArn.hashCode());
        String $awsCredentialPluginName = this.getAwsCredentialPluginName();
        result = result * 59 + ($awsCredentialPluginName == null ? 43 : $awsCredentialPluginName.hashCode());
        String $awsCredentialPluginParam = this.getAwsCredentialPluginParam();
        result = result * 59 + ($awsCredentialPluginParam == null ? 43 : $awsCredentialPluginParam.hashCode());
        InitialPositionInStream $initialPositionInStream = this.getInitialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        Date $startAtTime = this.getStartAtTime();
        result = result * 59 + ($startAtTime == null ? 43 : ((Object)$startAtTime).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $dynamoEndpoint = this.getDynamoEndpoint();
        result = result * 59 + ($dynamoEndpoint == null ? 43 : $dynamoEndpoint.hashCode());
        String $cloudwatchEndpoint = this.getCloudwatchEndpoint();
        result = result * 59 + ($cloudwatchEndpoint == null ? 43 : $cloudwatchEndpoint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamoDBSourceConfig(awsEndpoint=" + this.getAwsEndpoint() + ", awsRegion=" + this.getAwsRegion() + ", awsDynamodbStreamArn=" + this.getAwsDynamodbStreamArn() + ", awsCredentialPluginName=" + this.getAwsCredentialPluginName() + ", awsCredentialPluginParam=" + this.getAwsCredentialPluginParam() + ", initialPositionInStream=" + this.getInitialPositionInStream() + ", startAtTime=" + this.getStartAtTime() + ", applicationName=" + this.getApplicationName() + ", checkpointInterval=" + this.getCheckpointInterval() + ", backoffTime=" + this.getBackoffTime() + ", numRetries=" + this.getNumRetries() + ", receiveQueueSize=" + this.getReceiveQueueSize() + ", dynamoEndpoint=" + this.getDynamoEndpoint() + ", cloudwatchEndpoint=" + this.getCloudwatchEndpoint() + ")";
    }
}

