/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;

public class FileRecord
implements Record<byte[]> {
    public static final String FILE_NAME = "file.name";
    public static final String FILE_ABSOLUTE_PATH = "file.path";
    public static final String FILE_MODIFIED_TIME = "file.modified.time";
    private final Optional<String> key;
    private final byte[] value;
    private final HashMap<String, String> userProperties = new HashMap();

    public FileRecord(File srcFile, int lineNumber, byte[] value) {
        this.key = Optional.of(srcFile.getName() + "_" + lineNumber);
        this.value = value;
        this.setProperty(FILE_NAME, srcFile.getName());
        this.setProperty(FILE_ABSOLUTE_PATH, srcFile.getAbsolutePath());
        this.setProperty(FILE_MODIFIED_TIME, "" + srcFile.lastModified());
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Map<String, String> getProperties() {
        return this.userProperties;
    }

    public void setProperty(String key, String value) {
        this.userProperties.put(key, value);
    }

    public HashMap<String, String> getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileRecord)) {
            return false;
        }
        FileRecord other = (FileRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$key = this.getKey();
        Optional<String> other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        HashMap<String, String> this$userProperties = this.getUserProperties();
        HashMap<String, String> other$userProperties = other.getUserProperties();
        return !(this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        result = result * 59 + Arrays.hashCode(this.getValue());
        HashMap<String, String> $userProperties = this.getUserProperties();
        result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
        return result;
    }

    public String toString() {
        return "FileRecord(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ", userProperties=" + this.getUserProperties() + ")";
    }
}

