/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs2.sink.seq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.hdfs2.sink.HdfsAbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HdfsAbstractSequenceFileSink<K, V, HdfsK, HdfsV>
extends HdfsAbstractSink<K, V>
implements Sink<V> {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsAbstractSequenceFileSink.class);
    protected AtomicLong counter;
    protected FSDataOutputStream hdfsStream;
    protected SequenceFile.Writer writer = null;

    public abstract KeyValue<HdfsK, HdfsV> convert(KeyValue<K, V> var1);

    @Override
    public void close() throws Exception {
        this.writer.close();
        super.close();
    }

    @Override
    protected void createWriter() throws IOException {
        this.writer = this.getWriter();
    }

    public void write(Record<V> record) {
        try {
            KeyValue kv = this.extractKeyValue(record);
            KeyValue<HdfsK, HdfsV> keyValue = this.convert(kv);
            this.writer.append(keyValue.getKey(), keyValue.getValue());
            this.unackedRecords.put(record);
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Unable to write to file " + this.getPath(), (Throwable)e);
            record.fail();
        }
    }

    protected SequenceFile.Writer getWriter() throws IOException {
        this.counter = new AtomicLong(0L);
        List<SequenceFile.Writer.Option> options = this.getOptions();
        return SequenceFile.createWriter((Configuration)this.getConfiguration(), (SequenceFile.Writer.Option[])options.toArray(new SequenceFile.Writer.Option[options.size()]));
    }

    protected List<SequenceFile.Writer.Option> getOptions() throws IllegalArgumentException, IOException {
        ArrayList<SequenceFile.Writer.Option> list = new ArrayList<SequenceFile.Writer.Option>();
        list.add(SequenceFile.Writer.stream((FSDataOutputStream)this.getHdfsStream()));
        if (this.getCompressionCodec() != null) {
            list.add(SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)this.getCompressionCodec()));
        }
        return list;
    }
}

