/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class PulsarKafkaConnectSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(defaultValue="16384", help="Size of messages in bytes the sink will attempt to batch messages together before flush.")
    private int batchSize = 16384;
    @FieldDoc(defaultValue="2147483647L", help="Time interval in milliseconds the sink will attempt to batch messages together before flush.")
    private long lingerTimeMs = Integer.MAX_VALUE;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic name that passed to kafka sink.")
    private String topic;
    @FieldDoc(required=true, defaultValue="", help="A kafka-connector sink class to use.")
    private String kafkaConnectorSinkClass;
    @FieldDoc(defaultValue="", help="Config properties to pass to the kafka connector.")
    private Map<String, String> kafkaConnectorConfigProperties;
    @FieldDoc(required=true, defaultValue="", help="Pulsar topic to store offsets at.")
    private String offsetStorageTopic;
    @FieldDoc(defaultValue="true", help="In case of Record<KeyValue<>> data use key from KeyValue<> instead of one from Record.")
    private boolean unwrapKeyValueIfAvailable = true;
    @FieldDoc(defaultValue="true", help="Allows use of message index instead of message sequenceId as offset, if available.\nRequires AppendIndexMetadataInterceptor and exposingBrokerEntryMetadataToClientEnabled=true on brokers.")
    private boolean useIndexAsOffset = true;
    @FieldDoc(defaultValue="12", help="Number of bits (0 to 20) to use for index of message in the batch for translation into an offset.\n0 to disable this behavior (Messages from the same batch will have the same offset which can affect some connectors.)")
    private int maxBatchBitsForOffset = 12;
    @FieldDoc(defaultValue="false", help="Some connectors cannot handle pulsar topic names like persistent://a/b/topic and do not sanitize the topic name themselves. \nIf enabled, all non alpha-digital characters in topic name will be replaced with underscores. \nIn some cases it may result in topic name collisions (topic_a and topic.a will become the same)")
    private boolean sanitizeTopicName = false;
    @FieldDoc(defaultValue="false", help="Supply kafka record with topic name without -partition- suffix for partitioned topics.")
    private boolean collapsePartitionedTopics = false;
    @FieldDoc(defaultValue="false", help="Pulsar schema does not contain information whether the Schema is optional, Kafka's does. \nThis provides a way to force all primitive schemas to be optional for Kafka. \n")
    private boolean useOptionalPrimitives = false;

    public static PulsarKafkaConnectSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (PulsarKafkaConnectSinkConfig)mapper.readValue(new File(yamlFile), PulsarKafkaConnectSinkConfig.class);
    }

    public static PulsarKafkaConnectSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (PulsarKafkaConnectSinkConfig)mapper.readValue(mapper.writeValueAsString(map), PulsarKafkaConnectSinkConfig.class);
    }

    @Generated
    public PulsarKafkaConnectSinkConfig() {
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public long getLingerTimeMs() {
        return this.lingerTimeMs;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getKafkaConnectorSinkClass() {
        return this.kafkaConnectorSinkClass;
    }

    @Generated
    public Map<String, String> getKafkaConnectorConfigProperties() {
        return this.kafkaConnectorConfigProperties;
    }

    @Generated
    public String getOffsetStorageTopic() {
        return this.offsetStorageTopic;
    }

    @Generated
    public boolean isUnwrapKeyValueIfAvailable() {
        return this.unwrapKeyValueIfAvailable;
    }

    @Generated
    public boolean isUseIndexAsOffset() {
        return this.useIndexAsOffset;
    }

    @Generated
    public int getMaxBatchBitsForOffset() {
        return this.maxBatchBitsForOffset;
    }

    @Generated
    public boolean isSanitizeTopicName() {
        return this.sanitizeTopicName;
    }

    @Generated
    public boolean isCollapsePartitionedTopics() {
        return this.collapsePartitionedTopics;
    }

    @Generated
    public boolean isUseOptionalPrimitives() {
        return this.useOptionalPrimitives;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setLingerTimeMs(long lingerTimeMs) {
        this.lingerTimeMs = lingerTimeMs;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setKafkaConnectorSinkClass(String kafkaConnectorSinkClass) {
        this.kafkaConnectorSinkClass = kafkaConnectorSinkClass;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setKafkaConnectorConfigProperties(Map<String, String> kafkaConnectorConfigProperties) {
        this.kafkaConnectorConfigProperties = kafkaConnectorConfigProperties;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setUnwrapKeyValueIfAvailable(boolean unwrapKeyValueIfAvailable) {
        this.unwrapKeyValueIfAvailable = unwrapKeyValueIfAvailable;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setUseIndexAsOffset(boolean useIndexAsOffset) {
        this.useIndexAsOffset = useIndexAsOffset;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setMaxBatchBitsForOffset(int maxBatchBitsForOffset) {
        this.maxBatchBitsForOffset = maxBatchBitsForOffset;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setSanitizeTopicName(boolean sanitizeTopicName) {
        this.sanitizeTopicName = sanitizeTopicName;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setCollapsePartitionedTopics(boolean collapsePartitionedTopics) {
        this.collapsePartitionedTopics = collapsePartitionedTopics;
        return this;
    }

    @Generated
    public PulsarKafkaConnectSinkConfig setUseOptionalPrimitives(boolean useOptionalPrimitives) {
        this.useOptionalPrimitives = useOptionalPrimitives;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarKafkaConnectSinkConfig)) {
            return false;
        }
        PulsarKafkaConnectSinkConfig other = (PulsarKafkaConnectSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getLingerTimeMs() != other.getLingerTimeMs()) {
            return false;
        }
        if (this.isUnwrapKeyValueIfAvailable() != other.isUnwrapKeyValueIfAvailable()) {
            return false;
        }
        if (this.isUseIndexAsOffset() != other.isUseIndexAsOffset()) {
            return false;
        }
        if (this.getMaxBatchBitsForOffset() != other.getMaxBatchBitsForOffset()) {
            return false;
        }
        if (this.isSanitizeTopicName() != other.isSanitizeTopicName()) {
            return false;
        }
        if (this.isCollapsePartitionedTopics() != other.isCollapsePartitionedTopics()) {
            return false;
        }
        if (this.isUseOptionalPrimitives() != other.isUseOptionalPrimitives()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$kafkaConnectorSinkClass = this.getKafkaConnectorSinkClass();
        String other$kafkaConnectorSinkClass = other.getKafkaConnectorSinkClass();
        if (this$kafkaConnectorSinkClass == null ? other$kafkaConnectorSinkClass != null : !this$kafkaConnectorSinkClass.equals(other$kafkaConnectorSinkClass)) {
            return false;
        }
        Map<String, String> this$kafkaConnectorConfigProperties = this.getKafkaConnectorConfigProperties();
        Map<String, String> other$kafkaConnectorConfigProperties = other.getKafkaConnectorConfigProperties();
        if (this$kafkaConnectorConfigProperties == null ? other$kafkaConnectorConfigProperties != null : !((Object)this$kafkaConnectorConfigProperties).equals(other$kafkaConnectorConfigProperties)) {
            return false;
        }
        String this$offsetStorageTopic = this.getOffsetStorageTopic();
        String other$offsetStorageTopic = other.getOffsetStorageTopic();
        return !(this$offsetStorageTopic == null ? other$offsetStorageTopic != null : !this$offsetStorageTopic.equals(other$offsetStorageTopic));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PulsarKafkaConnectSinkConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        long $lingerTimeMs = this.getLingerTimeMs();
        result = result * 59 + (int)($lingerTimeMs >>> 32 ^ $lingerTimeMs);
        result = result * 59 + (this.isUnwrapKeyValueIfAvailable() ? 79 : 97);
        result = result * 59 + (this.isUseIndexAsOffset() ? 79 : 97);
        result = result * 59 + this.getMaxBatchBitsForOffset();
        result = result * 59 + (this.isSanitizeTopicName() ? 79 : 97);
        result = result * 59 + (this.isCollapsePartitionedTopics() ? 79 : 97);
        result = result * 59 + (this.isUseOptionalPrimitives() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $kafkaConnectorSinkClass = this.getKafkaConnectorSinkClass();
        result = result * 59 + ($kafkaConnectorSinkClass == null ? 43 : $kafkaConnectorSinkClass.hashCode());
        Map<String, String> $kafkaConnectorConfigProperties = this.getKafkaConnectorConfigProperties();
        result = result * 59 + ($kafkaConnectorConfigProperties == null ? 43 : ((Object)$kafkaConnectorConfigProperties).hashCode());
        String $offsetStorageTopic = this.getOffsetStorageTopic();
        result = result * 59 + ($offsetStorageTopic == null ? 43 : $offsetStorageTopic.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PulsarKafkaConnectSinkConfig(batchSize=" + this.getBatchSize() + ", lingerTimeMs=" + this.getLingerTimeMs() + ", topic=" + this.getTopic() + ", kafkaConnectorSinkClass=" + this.getKafkaConnectorSinkClass() + ", kafkaConnectorConfigProperties=" + this.getKafkaConnectorConfigProperties() + ", offsetStorageTopic=" + this.getOffsetStorageTopic() + ", unwrapKeyValueIfAvailable=" + this.isUnwrapKeyValueIfAvailable() + ", useIndexAsOffset=" + this.isUseIndexAsOffset() + ", maxBatchBitsForOffset=" + this.getMaxBatchBitsForOffset() + ", sanitizeTopicName=" + this.isSanitizeTopicName() + ", collapsePartitionedTopics=" + this.isCollapsePartitionedTopics() + ", useOptionalPrimitives=" + this.isUseOptionalPrimitives() + ")";
    }
}

