/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class KinesisRecord
implements Record<byte[]> {
    public static final String ARRIVAL_TIMESTAMP = "";
    public static final String ENCRYPTION_TYPE = "";
    public static final String PARTITION_KEY = "";
    public static final String SEQUENCE_NUMBER = "";
    private static final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private final Optional<String> key;
    private final byte[] value;
    private final HashMap<String, String> userProperties = new HashMap();

    public KinesisRecord(KinesisClientRecord record) {
        this.key = Optional.of(record.partitionKey());
        EncryptionType encType = EncryptionType.NONE;
        if (record.encryptionType() != null) {
            encType = record.encryptionType();
        }
        this.setProperty("", record.approximateArrivalTimestamp().toString());
        this.setProperty("", encType.toString());
        this.setProperty("", record.partitionKey());
        this.setProperty("", record.sequenceNumber());
        if (encType == EncryptionType.NONE) {
            String s = null;
            try {
                s = decoder.decode(record.data()).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
            this.value = s != null ? s.getBytes() : null;
        } else {
            this.value = (byte[])(encType == EncryptionType.KMS ? record.data().array() : null);
        }
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Map<String, String> getProperties() {
        return this.userProperties;
    }

    public void setProperty(String key, String value) {
        this.userProperties.put(key, value);
    }
}

