/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.io.kinesis.KinesisRecord;
import org.apache.pulsar.io.kinesis.KinesisSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.exceptions.InvalidStateException;
import software.amazon.kinesis.exceptions.KinesisClientLibDependencyException;
import software.amazon.kinesis.exceptions.ShutdownException;
import software.amazon.kinesis.exceptions.ThrottlingException;
import software.amazon.kinesis.lifecycle.events.InitializationInput;
import software.amazon.kinesis.lifecycle.events.LeaseLostInput;
import software.amazon.kinesis.lifecycle.events.ProcessRecordsInput;
import software.amazon.kinesis.lifecycle.events.ShardEndedInput;
import software.amazon.kinesis.lifecycle.events.ShutdownRequestedInput;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.processor.ShardRecordProcessor;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class KinesisRecordProcessor
implements ShardRecordProcessor {
    private static final Logger log = LoggerFactory.getLogger(KinesisRecordProcessor.class);
    private final int numRetries;
    private final long checkpointInterval;
    private final long backoffTime;
    private final LinkedBlockingQueue<KinesisRecord> queue;
    private long nextCheckpointTimeInNanos;
    private String kinesisShardId;

    public KinesisRecordProcessor(LinkedBlockingQueue<KinesisRecord> queue, KinesisSourceConfig config) {
        this.queue = queue;
        this.checkpointInterval = config.getCheckpointInterval();
        this.numRetries = config.getNumRetries();
        this.backoffTime = config.getBackoffTime();
    }

    private void checkpoint(RecordProcessorCheckpointer checkpointer) {
        log.info("Checkpointing shard " + this.kinesisShardId);
        for (int i = 0; i < this.numRetries; ++i) {
            try {
                checkpointer.checkpoint();
                break;
            }
            catch (ShutdownException se) {
                log.info("Caught shutdown exception, skipping checkpoint.", (Throwable)se);
                break;
            }
            catch (InvalidStateException e) {
                log.error("Cannot save checkpoint to the DynamoDB table.", (Throwable)e);
                break;
            }
            catch (KinesisClientLibDependencyException | ThrottlingException e) {
                if (i >= this.numRetries - 1) {
                    log.error("Checkpoint failed after " + (i + 1) + "attempts.", e);
                    break;
                }
                try {
                    Thread.sleep(this.backoffTime);
                }
                catch (InterruptedException e2) {
                    log.debug("Interrupted sleep", (Throwable)e2);
                }
                continue;
            }
        }
    }

    public void initialize(InitializationInput initializationInput) {
        this.kinesisShardId = initializationInput.shardId();
    }

    public void processRecords(ProcessRecordsInput processRecordsInput) {
        log.info("Processing " + processRecordsInput.records().size() + " records from " + this.kinesisShardId);
        for (KinesisClientRecord record : processRecordsInput.records()) {
            try {
                this.queue.put(new KinesisRecord(record));
            }
            catch (InterruptedException e) {
                log.warn("unable to create KinesisRecord ", (Throwable)e);
            }
        }
        if (System.nanoTime() > this.nextCheckpointTimeInNanos) {
            this.checkpoint(processRecordsInput.checkpointer());
            this.nextCheckpointTimeInNanos = System.nanoTime() + this.checkpointInterval;
        }
    }

    public void leaseLost(LeaseLostInput leaseLostInput) {
        log.info("lease lost, will terminate soon");
    }

    public void shardEnded(ShardEndedInput shardEndedInput) {
        log.info("reached end of shard, will checkpoint");
        this.checkpoint(shardEndedInput.checkpointer());
    }

    public void shutdownRequested(ShutdownRequestedInput shutdownRequestedInput) {
        log.info("Shutting down record processor for shard: " + this.kinesisShardId);
        this.checkpoint(shutdownRequestedInput.checkpointer());
    }
}

