/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public abstract class MongoAbstractConfig
implements Serializable {
    private static final long serialVersionUID = -3830568531897300005L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final long DEFAULT_BATCH_TIME_MS = 1000L;
    @FieldDoc(required=true, sensitive=true, defaultValue="", help="The URI of MongoDB that the connector connects to (see: https://docs.mongodb.com/manual/reference/connection-string/)")
    private final String mongoUri;
    @FieldDoc(defaultValue="", help="The database name to which the collection belongs and which must be watched for the source connector (required for the sink connector)")
    private final String database;
    @FieldDoc(defaultValue="", help="The collection name where the messages are written or which is watched for the source connector (required for the sink connector)")
    private final String collection;
    @FieldDoc(defaultValue="100", help="The batch size of write to or read from the database")
    private final int batchSize;
    @FieldDoc(defaultValue="1000", help="The batch operation interval in milliseconds")
    private final long batchTimeMs;

    public MongoAbstractConfig() {
        this(null, null, null, 100, 1000L);
    }

    @JsonCreator
    public MongoAbstractConfig(@JsonProperty(value="mongoUri") String mongoUri, @JsonProperty(value="database") String database, @JsonProperty(value="collection") String collection, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="batchTimeMs") long batchTimeMs) {
        this.mongoUri = mongoUri;
        this.database = database;
        this.collection = collection;
        this.batchSize = batchSize;
        this.batchTimeMs = batchTimeMs;
    }

    public void validate() {
        Preconditions.checkArgument((this.getBatchSize() > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
        Preconditions.checkArgument((this.getBatchTimeMs() > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
    }

    public String getMongoUri() {
        return this.mongoUri;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoAbstractConfig)) {
            return false;
        }
        MongoAbstractConfig other = (MongoAbstractConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        String this$mongoUri = this.getMongoUri();
        String other$mongoUri = other.getMongoUri();
        if (this$mongoUri == null ? other$mongoUri != null : !this$mongoUri.equals(other$mongoUri)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoAbstractConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        String $mongoUri = this.getMongoUri();
        result = result * 59 + ($mongoUri == null ? 43 : $mongoUri.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        return result;
    }

    public String toString() {
        return "MongoAbstractConfig(mongoUri=" + this.getMongoUri() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ", batchSize=" + this.getBatchSize() + ", batchTimeMs=" + this.getBatchTimeMs() + ")";
    }
}

