/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.bookkeeper.AbstractMetadataDriver;
import org.apache.pulsar.metadata.bookkeeper.HierarchicalLedgerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyHierarchicalLedgerRangeIterator
implements LedgerManager.LedgerRangeIterator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyHierarchicalLedgerRangeIterator.class);
    private static final String MAX_ID_SUFFIX = "9999";
    private static final String MIN_ID_SUFFIX = "0000";
    private final MetadataStore store;
    private final String ledgersRoot;
    private Iterator<String> l1NodesIter = null;
    private Iterator<String> l2NodesIter = null;
    private String curL1Nodes = "";
    private boolean iteratorDone = false;
    private LedgerManager.LedgerRange nextRange = null;
    private static final ThreadLocal<StringBuilder> threadLocalNodeBuilder = ThreadLocal.withInitial(() -> new StringBuilder());

    public LegacyHierarchicalLedgerRangeIterator(MetadataStore store, String ledgersRoot) {
        this.store = store;
        this.ledgersRoot = ledgersRoot;
    }

    private boolean nextL1Node() throws ExecutionException, InterruptedException, TimeoutException {
        this.l2NodesIter = null;
        while (this.l2NodesIter == null) {
            if (!this.l1NodesIter.hasNext()) {
                return false;
            }
            this.curL1Nodes = this.l1NodesIter.next();
            if (!this.isLedgerParentNode(this.curL1Nodes)) continue;
            List<String> l2Nodes = this.store.getChildren(this.ledgersRoot + "/" + this.curL1Nodes).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
            this.l2NodesIter = l2Nodes.iterator();
            if (this.l2NodesIter.hasNext()) continue;
            this.l2NodesIter = null;
        }
        return true;
    }

    private synchronized void preload() throws IOException {
        while (this.nextRange == null && !this.iteratorDone) {
            boolean hasMoreElements = false;
            try {
                if (this.l1NodesIter == null) {
                    List<String> l1Nodes = this.store.getChildren(this.ledgersRoot).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
                    this.l1NodesIter = l1Nodes.iterator();
                    hasMoreElements = this.nextL1Node();
                } else {
                    hasMoreElements = this.l2NodesIter == null || !this.l2NodesIter.hasNext() ? this.nextL1Node() : true;
                }
            }
            catch (ExecutionException | TimeoutException ke) {
                throw new IOException("Error preloading next range", ke);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while preloading", ie);
            }
            if (hasMoreElements) {
                this.nextRange = this.getLedgerRangeByLevel(this.curL1Nodes, this.l2NodesIter.next());
                if (this.nextRange.size() != 0) continue;
                this.nextRange = null;
                continue;
            }
            this.iteratorDone = true;
        }
    }

    public synchronized boolean hasNext() throws IOException {
        this.preload();
        return this.nextRange != null && !this.iteratorDone;
    }

    public synchronized LedgerManager.LedgerRange next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        LedgerManager.LedgerRange r = this.nextRange;
        this.nextRange = null;
        return r;
    }

    LedgerManager.LedgerRange getLedgerRangeByLevel(String level1, String level2) throws IOException {
        StringBuilder nodeBuilder = threadLocalNodeBuilder.get();
        nodeBuilder.setLength(0);
        nodeBuilder.append(this.ledgersRoot).append("/").append(level1).append("/").append(level2);
        String nodePath = nodeBuilder.toString();
        List<String> ledgerNodes = null;
        try {
            ledgerNodes = this.store.getChildren(nodePath).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException("Error when get child nodes from zk", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Error when get child nodes from zk", e);
        }
        NavigableSet<Long> zkActiveLedgers = HierarchicalLedgerUtils.ledgerListToSet(ledgerNodes, this.ledgersRoot, nodePath);
        if (log.isDebugEnabled()) {
            log.debug("All active ledgers from ZK for hash node " + level1 + "/" + level2 + " : " + zkActiveLedgers);
        }
        return new LedgerManager.LedgerRange(zkActiveLedgers.subSet(this.getStartLedgerIdByLevel(level1, level2), true, this.getEndLedgerIdByLevel(level1, level2), true));
    }

    private long getStartLedgerIdByLevel(String level1, String level2) throws IOException {
        return StringUtils.stringToHierarchicalLedgerId((String[])new String[]{level1, level2, MIN_ID_SUFFIX});
    }

    private long getEndLedgerIdByLevel(String level1, String level2) throws IOException {
        return StringUtils.stringToHierarchicalLedgerId((String[])new String[]{level1, level2, MAX_ID_SUFFIX});
    }

    private boolean isLedgerParentNode(String path) {
        return path.matches("\\d{2}");
    }
}

