/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.mledger.offload.OffloaderUtils;
import org.apache.bookkeeper.mledger.offload.Offloaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadersCache
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(OffloadersCache.class);
    private Map<String, Offloaders> loadedOffloaders = new ConcurrentHashMap<String, Offloaders>();

    public Offloaders getOrLoadOffloaders(String offloadersPath, String narExtractionDirectory) {
        return this.loadedOffloaders.computeIfAbsent(offloadersPath, directory -> {
            try {
                return OffloaderUtils.searchForOffloaders(directory, narExtractionDirectory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() {
        this.loadedOffloaders.values().forEach(offloaders -> {
            try {
                offloaders.close();
            }
            catch (Exception e) {
                log.error("Error while closing offloader.", (Throwable)e);
            }
        });
        this.loadedOffloaders.clear();
    }
}

