/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class PulsarLayoutManager
implements LayoutManager {
    private final MetadataStoreExtended store;
    private final String ledgersRootPath;
    private final String layoutPath;

    public PulsarLayoutManager(MetadataStoreExtended store, String ledgersRootPath) {
        this.ledgersRootPath = ledgersRootPath;
        this.store = store;
        this.layoutPath = ledgersRootPath + "/LAYOUT";
    }

    public LedgerLayout readLedgerLayout() throws IOException {
        try {
            byte[] layoutData = this.store.get(this.layoutPath).get().orElseThrow(() -> new BookieException.MetadataStoreException("Layout node not found")).getValue();
            return LedgerLayout.parseLayout((byte[])layoutData);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | BookieException e) {
            throw new IOException(e);
        }
    }

    public void storeLedgerLayout(LedgerLayout ledgerLayout) throws IOException {
        try {
            byte[] layoutData = ledgerLayout.serialize();
            this.store.put(this.layoutPath, layoutData, Optional.of(-1L)).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MetadataStoreException.BadVersionException) {
                throw new LayoutManager.LedgerLayoutExistsException((Throwable)e);
            }
            throw new IOException(e);
        }
    }

    public void deleteLedgerLayout() throws IOException {
        try {
            this.store.delete(this.layoutPath, Optional.empty()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    MetadataStoreExtended getStore() {
        return this.store;
    }

    String getLedgersRootPath() {
        return this.ledgersRootPath;
    }
}

