/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;

public class PulsarColumnMetadata
extends ColumnMetadata {
    private boolean isInternal;
    private String nameWithCase;
    private PulsarColumnHandle.HandleKeyValueType handleKeyValueType;
    public static final String KEY_SCHEMA_COLUMN_PREFIX = "__key.";
    private DecoderExtraInfo decoderExtraInfo;

    public PulsarColumnMetadata(String name, Type type, String comment, String extraInfo, boolean hidden, boolean isInternal, PulsarColumnHandle.HandleKeyValueType handleKeyValueType, DecoderExtraInfo decoderExtraInfo) {
        super(name, type, comment, extraInfo, hidden);
        this.nameWithCase = name;
        this.isInternal = isInternal;
        this.handleKeyValueType = handleKeyValueType;
        this.decoderExtraInfo = decoderExtraInfo;
    }

    public DecoderExtraInfo getDecoderExtraInfo() {
        return this.decoderExtraInfo;
    }

    public String getNameWithCase() {
        return this.nameWithCase;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public PulsarColumnHandle.HandleKeyValueType getHandleKeyValueType() {
        return this.handleKeyValueType;
    }

    public boolean isKey() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)PulsarColumnHandle.HandleKeyValueType.KEY);
    }

    public boolean isValue() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)PulsarColumnHandle.HandleKeyValueType.VALUE);
    }

    public static String getColumnName(PulsarColumnHandle.HandleKeyValueType handleKeyValueType, String name) {
        if (Objects.equals((Object)PulsarColumnHandle.HandleKeyValueType.KEY, (Object)handleKeyValueType)) {
            return KEY_SCHEMA_COLUMN_PREFIX + name;
        }
        return name;
    }

    public String toString() {
        return "PulsarColumnMetadata{isInternal=" + this.isInternal + ", nameWithCase='" + this.nameWithCase + "', handleKeyValueType=" + this.handleKeyValueType + ", decoderExtraInfo=" + this.decoderExtraInfo.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PulsarColumnMetadata that = (PulsarColumnMetadata)((Object)o);
        if (this.isInternal != that.isInternal) {
            return false;
        }
        if (!Objects.equals(this.nameWithCase, that.nameWithCase)) {
            return false;
        }
        if (!Objects.equals(this.decoderExtraInfo, that.decoderExtraInfo)) {
            return false;
        }
        return Objects.equals((Object)this.handleKeyValueType, (Object)that.handleKeyValueType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isInternal ? 1 : 0);
        result = 31 * result + (this.nameWithCase != null ? this.nameWithCase.hashCode() : 0);
        result = 31 * result + (this.decoderExtraInfo != null ? this.decoderExtraInfo.hashCode() : 0);
        result = 31 * result + (this.handleKeyValueType != null ? this.handleKeyValueType.hashCode() : 0);
        return result;
    }

    public static class DecoderExtraInfo {
        private String mapping;
        private String dataFormat;
        private String formatHint;

        public DecoderExtraInfo(String mapping, String dataFormat, String formatHint) {
            this.mapping = mapping;
            this.dataFormat = dataFormat;
            this.formatHint = formatHint;
        }

        public DecoderExtraInfo() {
        }

        public String getMapping() {
            return this.mapping;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public String getDataFormat() {
            return this.dataFormat;
        }

        public void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public String getFormatHint() {
            return this.formatHint;
        }

        public void setFormatHint(String formatHint) {
            this.formatHint = formatHint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DecoderExtraInfo that = (DecoderExtraInfo)o;
            if (!Objects.equals(this.mapping, that.mapping)) {
                return false;
            }
            if (!Objects.equals(this.dataFormat, that.dataFormat)) {
                return false;
            }
            return Objects.equals(this.formatHint, that.formatHint);
        }

        public String toString() {
            return "DecoderExtraInfo{mapping=" + this.mapping + ", dataFormat=" + this.dataFormat + ", formatHint=" + this.formatHint + "}";
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
            result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
            result = 31 * result + (this.formatHint != null ? this.formatHint.hashCode() : 0);
            return result;
        }
    }
}

