/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.collect.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private final Server server;
    private final ExecutorService webServiceExecutor;
    private final List<Handler> handlers = Lists.newArrayList();
    protected final int externalServicePort;
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);

    public WebServer(ProxyConfiguration config) {
        this.webServiceExecutor = Executors.newFixedThreadPool(32, (ThreadFactory)new DefaultThreadFactory("pulsar-external-web"));
        this.server = new Server((ThreadPool)new ExecutorThreadPool(this.webServiceExecutor));
        this.externalServicePort = config.getWebServicePort();
        ArrayList connectors = Lists.newArrayList();
        ServerConnector connector = new ServerConnector(this.server, 1, 1);
        connector.setPort(this.externalServicePort);
        connectors.add(connector);
        if (config.isTlsEnabledInProxy()) {
            SslContextFactory sslCtxFactory = new SslContextFactory();
            try {
                SSLContext sslCtx = SecurityUtility.createSslContext((boolean)false, null, (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath());
                sslCtxFactory.setSslContext(sslCtx);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            sslCtxFactory.setWantClientAuth(false);
            ServerConnector tlsConnector = new ServerConnector(this.server, 1, 1, sslCtxFactory);
            tlsConnector.setPort(config.getWebServicePortTls());
            connectors.add(tlsConnector);
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public URI getServiceUri() {
        return this.server.getURI();
    }

    public void addServlet(String path, ServletHolder servletHolder) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.addServlet(servletHolder, path);
        this.handlers.add((Handler)context);
    }

    public int getExternalServicePort() {
        return this.externalServicePort;
    }

    public void start() throws Exception {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setExtended(true);
        requestLog.setLogTimeZone("GMT");
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.server.setHandler((Handler)handlerCollection);
        this.server.start();
        log.info("Server started at end point {}", (Object)this.getServiceUri());
    }

    public void stop() throws Exception {
        this.server.stop();
        this.webServiceExecutor.shutdown();
        log.info("Server stopped successfully");
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }
}

