/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.impl.ConnectionPool;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ServiceChannelInitializer;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyService
implements Closeable {
    private final ProxyConfiguration proxyConfig;
    private final String serviceUrl;
    private final String serviceUrlTls;
    private ConfigurationCacheService configurationCacheService;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private ZooKeeperClientFactory zkClientFactory = null;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private final DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-discovery-acceptor");
    private final DefaultThreadFactory workersThreadFactory = new DefaultThreadFactory("pulsar-discovery-io");
    private final PulsarClientImpl client;
    private final Authentication clientAuthentication;
    private BrokerDiscoveryProvider discoveryProvider;
    protected final AtomicReference<Semaphore> lookupRequestSemaphore;
    private static final int numThreads = Runtime.getRuntime().availableProcessors();
    private static final Logger LOG = LoggerFactory.getLogger(ProxyService.class);

    public ProxyService(ProxyConfiguration proxyConfig) throws IOException {
        String hostname;
        Preconditions.checkNotNull((Object)proxyConfig);
        this.proxyConfig = proxyConfig;
        this.lookupRequestSemaphore = new AtomicReference<Semaphore>(new Semaphore(proxyConfig.getMaxConcurrentLookupRequests(), false));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.serviceUrl = String.format("pulsar://%s:%d/", hostname, proxyConfig.getServicePort());
        this.serviceUrlTls = String.format("pulsar://%s:%d/", hostname, proxyConfig.getServicePortTls());
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)1, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)numThreads, (ThreadFactory)this.workersThreadFactory);
        ClientConfigurationData clientConf = new ClientConfigurationData();
        clientConf.setServiceUrl(this.serviceUrl);
        if (proxyConfig.getBrokerClientAuthenticationPlugin() != null) {
            clientConf.setAuthentication(AuthenticationFactory.create((String)proxyConfig.getBrokerClientAuthenticationPlugin(), (String)proxyConfig.getBrokerClientAuthenticationParameters()));
        }
        if (proxyConfig.isTlsEnabledWithBroker()) {
            clientConf.setUseTls(true);
            clientConf.setTlsTrustCertsFilePath(proxyConfig.getBrokerClientTrustCertsFilePath());
            clientConf.setTlsAllowInsecureConnection(proxyConfig.isTlsAllowInsecureConnection());
        }
        this.client = new PulsarClientImpl(clientConf, this.workerGroup);
        this.clientAuthentication = clientConf.getAuthentication();
    }

    public void start() throws Exception {
        ServiceConfiguration serviceConfiguration = PulsarConfigurationLoader.convertFrom((PulsarConfiguration)this.proxyConfig);
        this.authenticationService = new AuthenticationService(serviceConfiguration);
        if (!StringUtils.isBlank((CharSequence)this.proxyConfig.getZookeeperServers()) && !StringUtils.isBlank((CharSequence)this.proxyConfig.getConfigurationStoreServers())) {
            this.discoveryProvider = new BrokerDiscoveryProvider(this.proxyConfig, this.getZooKeeperClientFactory());
            this.configurationCacheService = new ConfigurationCacheService((ZooKeeperCache)this.discoveryProvider.globalZkCache);
            this.authorizationService = new AuthorizationService(serviceConfiguration, this.configurationCacheService);
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        bootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, false));
        bootstrap.bind(this.proxyConfig.getServicePort()).sync();
        LOG.info("Started Pulsar Proxy at {}", (Object)this.serviceUrl);
        if (this.proxyConfig.isTlsEnabledInProxy()) {
            ServerBootstrap tlsBootstrap = bootstrap.clone();
            tlsBootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, true));
            tlsBootstrap.bind(this.proxyConfig.getServicePortTls()).sync();
            LOG.info("Started Pulsar TLS Proxy on port {}", (Object)this.proxyConfig.getServicePortTls());
        }
    }

    long newRequestId() {
        return this.client.newRequestId();
    }

    ConnectionPool getConnectionPool() {
        return this.client.getCnxPool();
    }

    public ZooKeeperClientFactory getZooKeeperClientFactory() {
        if (this.zkClientFactory == null) {
            this.zkClientFactory = new ZookeeperClientFactoryImpl();
        }
        return this.zkClientFactory;
    }

    public BrokerDiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.discoveryProvider != null) {
            this.discoveryProvider.close();
        }
        this.acceptorGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.client.close();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public ProxyConfiguration getConfiguration() {
        return this.proxyConfig;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public Authentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    public ConfigurationCacheService getConfigurationCacheService() {
        return this.configurationCacheService;
    }

    public void setConfigurationCacheService(ConfigurationCacheService configurationCacheService) {
        this.configurationCacheService = configurationCacheService;
    }

    public Semaphore getLookupRequestSemaphore() {
        return this.lookupRequestSemaphore.get();
    }
}

