/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdminProxyHandler
extends AsyncProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AdminProxyHandler.class);
    private final ProxyConfiguration config;
    private final BrokerDiscoveryProvider discoveryProvider;
    private final String brokerWebServiceUrl;

    AdminProxyHandler(ProxyConfiguration config, BrokerDiscoveryProvider discoveryProvider) {
        this.config = config;
        this.discoveryProvider = discoveryProvider;
        this.brokerWebServiceUrl = config.isTlsEnabledWithBroker() ? config.getBrokerWebServiceURLTLS() : config.getBrokerWebServiceURL();
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        client.setFollowRedirects(true);
        return client;
    }

    protected HttpClient newHttpClient() {
        block6: {
            try {
                Authentication auth = AuthenticationFactory.create((String)this.config.getBrokerClientAuthenticationPlugin(), (String)this.config.getBrokerClientAuthenticationParameters());
                Objects.requireNonNull(auth, "No supported auth found for proxy");
                auth.start();
                if (!this.config.isTlsEnabledWithBroker()) break block6;
                try {
                    Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile((String)this.config.getTlsTrustCertsFilePath());
                    AuthenticationDataProvider authData = auth.getAuthData();
                    SSLContext sslCtx = authData.hasDataForTls() ? SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates, (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey()) : SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates);
                    SslContextFactory contextFactory = new SslContextFactory();
                    contextFactory.setSslContext(sslCtx);
                    return new HttpClient(contextFactory);
                }
                catch (Exception e) {
                    try {
                        auth.close();
                    }
                    catch (IOException ioe) {
                        LOG.error("Failed to close the authentication service", (Throwable)ioe);
                    }
                    throw new PulsarClientException.InvalidConfigurationException(e.getMessage());
                }
            }
            catch (PulsarClientException e) {
                throw new RuntimeException(e);
            }
        }
        return new HttpClient();
    }

    /*
     * Unable to fully structure code
     */
    protected String rewriteTarget(HttpServletRequest request) {
        url = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.brokerWebServiceUrl)) {
            try {
                availableBroker = this.discoveryProvider.nextBroker();
                if (this.config.isTlsEnabledWithBroker()) {
                    url.append(availableBroker.getWebServiceUrlTls());
                } else {
                    url.append(availableBroker.getWebServiceUrl());
                }
                if (!AdminProxyHandler.LOG.isDebugEnabled()) ** GOTO lbl19
                AdminProxyHandler.LOG.debug("[{}:{}] Selected active broker is {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), url.toString()});
            }
            catch (Exception e) {
                AdminProxyHandler.LOG.warn("[{}:{}] Failed to get next active broker {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), e.getMessage(), e});
                return null;
            }
        } else {
            url.append(this.brokerWebServiceUrl);
        }
lbl19:
        // 3 sources

        if (url.lastIndexOf("/") == url.length() - 1) {
            url.deleteCharAt(url.lastIndexOf("/"));
        }
        url.append(request.getRequestURI());
        query = request.getQueryString();
        if (query != null) {
            url.append("?").append(query);
        }
        if (!this.validateDestination((rewrittenUrl = URI.create(url.toString()).normalize()).getHost(), rewrittenUrl.getPort())) {
            return null;
        }
        return rewrittenUrl.toString();
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        String user = (String)clientRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName);
        if (user != null) {
            proxyRequest.header("X-Original-Principal", user);
        }
    }
}

