/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.protocol.OptionalProxyProtocolDecoder;
import org.apache.pulsar.common.util.NettyServerSslContextBuilder;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final ProxyService proxyService;
    private final boolean enableTls;
    private final boolean tlsEnabledWithKeyStore;
    private final int brokerProxyReadTimeoutMs;
    private SslContextAutoRefreshBuilder<SslContext> serverSslCtxRefresher;
    private NettySSLContextAutoRefreshBuilder serverSSLContextAutoRefreshBuilder;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTls) throws Exception {
        this.proxyService = proxyService;
        this.enableTls = enableTls;
        this.tlsEnabledWithKeyStore = serviceConfig.isTlsEnabledWithKeyStore();
        this.brokerProxyReadTimeoutMs = serviceConfig.getBrokerProxyReadTimeoutMs();
        if (enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                this.serverSSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(serviceConfig.getTlsProvider(), serviceConfig.getTlsKeyStoreType(), serviceConfig.getTlsKeyStore(), serviceConfig.getTlsKeyStorePassword(), serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustStoreType(), serviceConfig.getTlsTrustStore(), serviceConfig.getTlsTrustStorePassword(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            } else {
                SslProvider sslProvider = null;
                if (serviceConfig.getTlsProvider() != null) {
                    sslProvider = SslProvider.valueOf((String)serviceConfig.getTlsProvider());
                }
                this.serverSslCtxRefresher = new NettyServerSslContextBuilder(sslProvider, serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            }
        } else {
            this.serverSslCtxRefresher = null;
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        if (this.serverSslCtxRefresher != null && this.enableTls) {
            SslContext sslContext = (SslContext)this.serverSslCtxRefresher.get();
            if (sslContext != null) {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslContext.newHandler(ch.alloc()));
            }
        } else if (this.tlsEnabledWithKeyStore && this.serverSSLContextAutoRefreshBuilder != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(((KeyStoreSSLContext)this.serverSSLContextAutoRefreshBuilder.get()).createSSLEngine()));
        }
        if (this.brokerProxyReadTimeoutMs > 0) {
            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.brokerProxyReadTimeoutMs, TimeUnit.MILLISECONDS));
        }
        if (this.proxyService.getConfiguration().isHaProxyProtocolEnabled()) {
            ch.pipeline().addLast("optional-proxy-protocol-decoder", (ChannelHandler)new OptionalProxyProtocolDecoder());
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService, this.proxyService.getDnsAddressResolverGroup()));
    }
}

