/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.common.util.ClientSslContextRefresher;
import org.apache.pulsar.common.util.NettySslContextBuilder;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final ProxyService proxyService;
    private final NettySslContextBuilder serverSslCtxRefresher;
    private final ClientSslContextRefresher clientSslCtxRefresher;
    private final boolean enableTls;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTls) throws Exception {
        this.proxyService = proxyService;
        this.enableTls = enableTls;
        this.serverSslCtxRefresher = enableTls ? new NettySslContextBuilder(serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec()) : null;
        if (serviceConfig.isTlsEnabledWithBroker()) {
            AuthenticationDataProvider authData = null;
            if (!StringUtils.isEmpty((CharSequence)serviceConfig.getBrokerClientAuthenticationPlugin())) {
                authData = AuthenticationFactory.create((String)serviceConfig.getBrokerClientAuthenticationPlugin(), (String)serviceConfig.getBrokerClientAuthenticationParameters()).getAuthData();
            }
            this.clientSslCtxRefresher = new ClientSslContextRefresher(serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getBrokerClientTrustCertsFilePath(), authData);
        } else {
            this.clientSslCtxRefresher = null;
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        SslContext sslContext;
        if (this.serverSslCtxRefresher != null && this.enableTls && (sslContext = (SslContext)this.serverSslCtxRefresher.get()) != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslContext.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService, this.clientSslCtxRefresher == null ? null : this.clientSslCtxRefresher.get()));
    }
}

